!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv!
!                                                                      !
!  Module name: URS1_DES                                               !
!                                                                      !
!  Purpose: This routine is called within the discrete phase time loop !
!  after the source terms have been calculated but before they are     !
!  applied. The user may insert code in this routine or call user      !
!  defined subroutines.                                                !
!                                                                      !
!  This routien is called from the time loop, but no indicies (fluid   !
!  cell or particle) are defined.                                      !
!                                                                      !
!  Author: J.Musser                                   Date: 06-Nov-12  !
!                                                                      !
!  Comments:                                                           !
!                                                                      !
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^!
      SUBROUTINE USR1_DES

      !Use des_rxns
      !Use des_thermo
      Use discretelement
      Use run
      Use usr
      !Use mpi_utility
      USE DES_TIME_MARCH, ONLY: EXIT_LOOP

      IMPLICIT NONE


!ll      IF (myPE .EQ. PE_IO) THEN

        ! see if v_p changed from positive to negative
        IF (v_old .GT. 0.0d0 .AND. DES_VEL_NEW(1,2) .LT. 0.0d0) THEN
          WRITE(*,*) ' '
          WRITE(*,*) ' First maximum reached at time = ', S_TIME
          WRITE(*,*) ' h_0 = ', h_old
          WRITE(*,*) ' Printing to file and exiting code'
          WRITE(*,*) ' '
          OPEN(UNIT=801,FILE='rebound.dat',STATUS='UNKNOWN')
          WRITE(801,*) h_old
          CLOSE(801)
          TSTOP = S_TIME-DTSOLID
          EXIT_LOOP = .True.
        END IF

      ! store the initial old particle vertical velocity for next loop
      h_old = DES_POS_NEW(1,2)
      v_old = DES_VEL_NEW(1,2)

!ll      END IF


      RETURN
      END SUBROUTINE USR1_DES
