!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv!
!                                                                      !
!  Module name: URS1_DES                                               !
!                                                                      !
!  Purpose: This routine is called within the discrete phase time loop !
!  after the source terms have been calculated but before they are     !
!  applied. The user may insert code in this routine or call user      !
!  defined subroutines.                                                !
!                                                                      !
!  This routien is called from the time loop, but no indicies (fluid   !
!  cell or particle) are defined.                                      !
!                                                                      !
!  Author: J.Musser                                   Date: 06-Nov-12  !
!                                                                      !
!  Comments:                                                           !
!                                                                      !
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^!
      SUBROUTINE USR1_DES

!      Use des_rxns
!      Use des_thermo
      Use discretelement, only: grav, des_pos_new, max_pip, des_radius
      Use run, only: tstop
      Use usr
!      Use constant, only: gravity_x, gravity_y, gravity_z
      Use run, only: time, dt
      use functions, only: is_normal
      use compar, only: myPE
      IMPLICIT NONE
      double precision  :: gravity_mag = 9.814
      double Precision  :: minx = 1e10
      double Precision  :: maxx = -1e10
      double Precision  :: maxy1 = -1e10
      double Precision  :: maxy2 = -1e10
      double Precision  :: maxy3 = -1e10
      double Precision  :: sp_actual
      double precision  :: rotation_rate = 0.1
      double precision  :: angle, dt_start, maxY, maxRadius, diffInX
      double precision  :: gravity_x, gravity_y
      integer 	  	:: LL
      integer, parameter :: out_unit = 26505

      if (myPE == 0) then
            dt = 1e-4
	    maxY = -1e10
	    DO LL = 1, MAX_PIP
      		  IF(.NOT.IS_NORMAL(LL)) CYCLE
		  maxY = max(maxY, des_pos_new(LL,2))
	    end do
	    if (time > start_time) then
		  if (.not. EvaluatedHeight) then
			DO LL = 1, MAX_PIP
      			      IF(.NOT.IS_NORMAL(LL)) CYCLE
			      if (des_pos_new(LL,2) >= 0.0) then
				    call delete_particle(LL)
			      end if
			end do	    	  
	    		EvaluatedHeight = .True.
		  else
		  	dt = 1e-3
      			dt_start = time - start_time
			angle = dt_start*rotation_rate
      !      		  if (.not. Settled) then
      !		      DO LL = 1, MAX_PIP
      !      			    IF(.NOT.IS_NORMAL(LL)) CYCLE
      !			    maxRadius = max(maxRadius, des_radius(LL))
      !		      end do
      !      	    	      Settled_Height = maxY + maxRadius*0.25
      !		      Settled = .True.  
      !		  end if
      			
			if (maxY > 0.0001) then
			      open(unit=out_unit, file="slideAngle.txt", action="write", status="replace")
			      write(out_unit,*) angle*180.0/3.14159265359
			      close(out_unit)
			      write(*,*) 'going to exit'
			      call EXIT(0)
			end if
			gravity_y = -cos(angle)*gravity_mag
			gravity_x = -sin(angle)*gravity_mag
			grav(1) = gravity_x
			grav(2) = gravity_y
			grav(3) = 0.0
			!write(*,*) "force y: ", gravity_y, "force x:", gravity_x
			!write(*,*) "ratating: ", angle
		  end if
	    else if (time >= shake_start_time .and. time <= shake_end_time) then
      		  if (.not. Shaking) then
	    		shakeTimer = time
			Shaking = .True.
		  end if
      		  dt_start = time - shakeTimer
		  if (shakeDir < 0.0) then
	    		sp_actual = 2.0 * shake_period
		  else
	    		sp_actual = shake_period
		  end if
		  if (dt_start >= sp_actual) then
	    		ShakeDir = -1.0 * ShakeDir
			shakeTimer = time
		  end if
      		  grav(1) = 0.0
		  grav(2) = ShakeDir * shake_accel
		  grav(3) = 0.0
		  !write(*,*) "shaking: ", ShakeDir * shake_accel, "dt_start: ", dt_start, "shakeTimer: ", shakeTimer, "shake_period: ", sp_actual

	    else
      		  !write(*,*) "Normal Gravity"
      		  grav(1) = 0.0
		  grav(2) = -gravity_mag
		  grav(3) = 0.0
	    endif
      endif

      RETURN
      END SUBROUTINE USR1_DES
      
