from conans import ConanFile, Meson, tools


class CsgEbConan(ConanFile):
    name = "csg-eb"
    version = "0.1"
    license = "<Put the package license here>"
    author = "Deepak Rangarajan <Deepak.Rangarajan@netl.doe.gov>"
    url = "https://mfix.netl.doe.gov/gitlab/exa/csg-eb"
    description = "Library for reading CSG geometry files"
    topics = ("<Put some tag here>", "<here>", "<and here>")
    settings = "os", "compiler", "build_type", "arch"
    options = {"shared": [True, False]}
    default_options = {"shared": False}
    generators = "pkg_config"
    requires = ("catch2/2.13.0", "cgal/5.0.2", "taocpp-pegtl/2.8.3")
    build_requires = (
        "meson/0.55.0",
        "pkg-config_installer/0.29.2@bincrafters/stable",
    )
    exports_sources = "meson.build", "include/*", "src/*"

    def build(self):
        meson = Meson(self)
        meson.configure(build_folder="build")
        meson.build()
        meson.meson_test(args=["--verbose", "--print-errorlog"])

    def package(self):
        self.copy("*.h", dst="include", src="csg-eb")
        self.copy("*.a", dst="lib", keep_path=False)

    def package_info(self):
        self.cpp_info.libs = ["csg-eb"]
