#ifndef CGAL_HELPER_H_
#define CGAL_HELPER_H_

#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/Polygon_2.h>
#include <CGAL/Polyhedron_3.h>
#include <CGAL/Simple_cartesian.h>

namespace cgal_helper {

typedef CGAL::Simple_cartesian<double> CK;
typedef CGAL::Polyhedron_3<CK> Polyhedron;
typedef CGAL::Polygon_2<CK> Polygon;

Polyhedron
create_polyhedron(const std::vector<std::tuple<double, double, double>> &points,
                  const std::vector<std::vector<unsigned int>> &faces);

Polygon create_polygon(const std::vector<std::tuple<double, double>> &points,
                       const std::vector<unsigned int> &path);

bool inside(const Polyhedron &polyhedron, double xx, double yy, double zz);

bool inside(const Polygon &polygon, double xx, double yy);

double abs_max_distance(const Polygon &ploygon, double xx, double yy,
                        bool inside);

} // namespace cgal_helper

#endif
