#include "catch2/catch.hpp"

#include <csg.hpp>
#include <csg_types.hpp>

namespace {

TEST_CASE("two shape linear", "[Levelset Extrude]") {
  auto my_lin_ext = csg::LinearExtrude();

  csg::Circle my_cir{.name = std::nullopt, .radius = 1};
  my_lin_ext.group.objs.push_back(my_cir);

  auto my_mat = csg::Mulmatrix2D();
  my_mat.rotation[0] = std::array<double, 2>{{1, 0}};
  my_mat.rotation[1] = std::array<double, 2>{{0, 1}};
  my_mat.translation = {4, 0};
  my_mat.group.objs.push_back(my_cir);
  my_lin_ext.group.objs.push_back(my_mat);

  auto my_tree = std::make_shared<csg::Tree>();
  my_tree->top.objs.push_back(my_lin_ext);
  csg::CsgIF my_levelset(my_tree);

  SECTION("Outside") {
    CHECK_FALSE(0 < my_levelset(0, 2, 0));
    CHECK_FALSE(0 < my_levelset(-4, 0, 0));
  }
  SECTION("Inside") {
    CHECK(0 < my_levelset(0, 0, 0));
    CHECK(0 < my_levelset(0.5, 0, 0));
    CHECK(0 < my_levelset(-0.5, 0, 0));
    CHECK(0 < my_levelset(4.5, 0, 0));
    CHECK(0 < my_levelset(3.5, 0, 0));
    CHECK(0 < my_levelset(3.5, 0, 100));
    CHECK(0 < my_levelset(3.5, 0, -100));
  }
}

TEST_CASE("simple torus", "[Levelset Extrude]") {
  auto my_rot_ext = csg::RotateExtrude();

  csg::Circle my_cir{.name = std::nullopt, .radius = 1};
  auto my_mat = csg::Mulmatrix2D();
  my_mat.rotation[0] = std::array<double, 2>{{1, 0}};
  my_mat.rotation[1] = std::array<double, 2>{{0, 1}};
  my_mat.translation = {2, 0};
  my_mat.group.objs.push_back(my_cir);
  my_rot_ext.group.objs.push_back(my_mat);

  auto my_tree = std::make_shared<csg::Tree>();
  my_tree->top.objs.push_back(my_rot_ext);
  csg::CsgIF my_levelset(my_tree);

  SECTION("Outside") {
    CHECK_FALSE(0 < my_levelset(0, 0, 0));
    CHECK_FALSE(0 < my_levelset(0.9, 0, 0));
    CHECK_FALSE(0 < my_levelset(-0.9, 0, 0));
    CHECK_FALSE(0 < my_levelset(2, 0, 1.1));
    CHECK_FALSE(0 < my_levelset(-2, 0, -1.1));
  }
  SECTION("Inside") {
    CHECK(0 < my_levelset(2, 0, 0));
    CHECK(0 < my_levelset(1.1, 0, 0));
    CHECK(0 < my_levelset(-1.1, 0, 0));
    CHECK(0 < my_levelset(2, 0, 0.9));
    CHECK(0 < my_levelset(-2, 0, -0.9));
  }
}

} // namespace
