#include "catch2/catch.hpp"

#include <csg.hpp>
#include <csg_types.hpp>

// Tests for the primitives on their own

TEST_CASE("cylinder", "[csg]") {
  auto st = *csg::parse_csg(R"(
cylinder($name="my_cyl", h = 2, r = 10, center=true);
)");
  auto cyl = std::get<csg::Cylinder>(st.top.objs.at(0));
  CHECK(cyl.name == "my_cyl");
  CHECK(cyl.radius == 10);
  CHECK(cyl.height == 2);
}

TEST_CASE("nameless cylinder", "[csg]") {
  auto st = *csg::parse_csg(R"(
cylinder(h = 2, r = 10, center=true);
)");
  auto cyl = std::get<csg::Cylinder>(st.top.objs.at(0));
  CHECK_FALSE(cyl.name.has_value());
  CHECK(cyl.radius == 10);
  CHECK(cyl.height == 2);
}

TEST_CASE("cube", "[csg]") {
  auto st = *csg::parse_csg(R"(
cube(size = [1,2,3], center=true, $name="my_cube");
)");
  auto cub = std::get<csg::Cube>(st.top.objs.at(0));
  auto [XX, YY, ZZ] = cub.size;
  CHECK(cub.name == "my_cube");
  CHECK(XX == 1);
  CHECK(YY == 2);
  CHECK(ZZ == 3);
}

TEST_CASE("sphere", "[csg]") {
  auto st = *csg::parse_csg(R"(
sphere(r = 10, $name="my_sphere");
)");
  auto sph = std::get<csg::Sphere>(st.top.objs.at(0));
  CHECK(sph.name == "my_sphere");
  CHECK(sph.radius == 10);
}

TEST_CASE("semicolon optional", "[csg]") {
  auto st = *csg::parse_csg(R"(
sphere(r = 10)
)");
  auto sph = std::get<csg::Sphere>(st.top.objs.at(0));
  CHECK(sph.radius == 10);
}

// TODO: polyhedron()
