#include "solver_impl.hpp"

namespace solver {

solver::GeometrySettings make_geometry(solver::InputInfo ii,
                                       std::vector<InputsMessage> messages) {
  solver::GeometrySettings geo;

  if (ii.count(CSG_FILENAME)) {
    auto csg_filename = std::get<solver::StringArray>(ii[CSG_FILENAME]);
    if (csg_filename.size() != 1) {
      messages.push_back(
          InputsMessage{"geometry.filename should only have 1 element"});
    }
  } else {
    geo.csg_filename = "";
  }

  if (!ii.count(PROB_LO)) {
    require(PROB_LO, messages, 0);
  }
  if (!ii.count(PROB_HI)) {
    require(PROB_HI, messages, 0);
  }
  if (!ii.count(PERIODIC)) {
    require(PERIODIC, messages, 0);
  }
  auto lows = std::get<solver::NumberArray>(ii[PROB_LO]);
  auto highs = std::get<solver::NumberArray>(ii[PROB_HI]);
  auto is_periodic = std::get<solver::NumberArray>(ii[PERIODIC]);
  if (lows.size() != 3) {
    require(PROB_LO, messages, 3);
  } else {
    std::get<0>(geo.axes).low = lows[0];
    std::get<1>(geo.axes).low = lows[1];
    std::get<2>(geo.axes).low = lows[2];
  }
  if (highs.size() != 3) {
    require(PROB_HI, messages, 3);
  } else {
    std::get<0>(geo.axes).high = highs[0];
    std::get<1>(geo.axes).high = highs[1];
    std::get<2>(geo.axes).high = highs[2];
  }
  if (is_periodic.size() != 3) {
    require(PERIODIC, messages, 3);
  } else {
    std::get<0>(geo.axes).periodic = is_periodic[0];
    std::get<1>(geo.axes).periodic = is_periodic[1];
    std::get<2>(geo.axes).periodic = is_periodic[2];
  }
  return geo;
}
} // namespace solver
