#ifndef INPUTS_H_
#define INPUTS_H_

// Geometry
static const std::string DT_MAX("mfix.dt_max");
static const std::string DT_MIN("mfix.dt_min");
static const std::string PERIODIC("geometry.is_periodic");
static const std::string PROB_HI("geometry.prob_hi");
static const std::string PROB_LO("geometry.prob_lo");
static const std::string CSG_FILENAME("mfix.geometry_filename");

// Mesh
static const std::string BLOCKING_FACTOR("amr.blocking_factor");
static const std::string FABARRAY_TILE_SZ("fabarray.mfiter_tile_size");
static const std::string GRID_SIZE_X("amr.max_grid_size_x");
static const std::string GRID_SIZE_Y("amr.max_grid_size_y");
static const std::string GRID_SIZE_Z("amr.max_grid_size_z");
static const std::string N_CELL("amr.n_cell");
static const std::string PARTICLE_GRID_SIZE_X("particles.max_grid_size_x");
static const std::string PARTICLE_GRID_SIZE_Y("particles.max_grid_size_y");
static const std::string PARTICLE_GRID_SIZE_Z("particles.max_grid_size_z");
static const std::string PARTICLE_TILE_SZ("particles.tile_size");
static const std::string SMALL_VOLFRAC("eb2.small_volfrac");

// Time
static const std::string CFL("mfix.cfl");
static const std::string FIXED_DT("mfix.fixed_dt");
static const std::string MAXSTEP("mfix.max_step");
static const std::string TCOLL_RATIO("mfix.tcoll_ratio");
static const std::string TSTOP("mfix.stop_time");

#endif
