#include "solver_impl.hpp"

namespace solver {

solver::MeshSettings make_mesh(solver::InputInfo ii,
                               std::vector<InputsMessage> messages) {
  solver::MeshSettings mesh;
  auto [mx, my, mz] = mesh.axes;

  if (!ii.count(N_CELL)) {
    require(N_CELL, messages, 0);
  } else {

    auto n_cell = std::get<solver::NumberArray>(ii[N_CELL]);
    if (n_cell.size() != 3) {
      require(N_CELL, messages, 3);
    } else {
      mx.n_cell = n_cell[0];
      my.n_cell = n_cell[1];
      mz.n_cell = n_cell[2];
    }
  }

  auto fabarray_size = std::get<solver::NumberArray>(ii[FABARRAY_TILE_SZ]);
  if (fabarray_size.size() != 3) {
    require(FABARRAY_TILE_SZ, messages, 3);
  } else {
    mx.fluid_max_tile_size = fabarray_size[0];
    my.fluid_max_tile_size = fabarray_size[1];
    mz.fluid_max_tile_size = fabarray_size[2];
  }

  auto part_grid_size = std::get<solver::NumberArray>(ii[PARTICLE_TILE_SZ]);
  if (part_grid_size.size() != 3) {
    require(PARTICLE_TILE_SZ, messages, 3);
  } else {
    mx.particle_max_tile_size = part_grid_size[0];
    my.particle_max_tile_size = part_grid_size[1];
    mz.particle_max_tile_size = part_grid_size[2];
  }

  auto grid_size_x = std::get<solver::NumberArray>(ii[GRID_SIZE_X]);
  if (grid_size_x.size() != 1) {
    require(GRID_SIZE_X, messages, 1);
  } else {
    mx.max_grid_size = grid_size_x[0];
  }
  auto grid_size_y = std::get<solver::NumberArray>(ii[GRID_SIZE_Y]);
  if (grid_size_y.size() != 1) {
    require(GRID_SIZE_Y, messages, 1);
  } else {
    my.max_grid_size = grid_size_y[0];
  }
  auto grid_size_z = std::get<solver::NumberArray>(ii[GRID_SIZE_Z]);
  if (grid_size_z.size() != 1) {
    require(GRID_SIZE_Z, messages, 1);
  } else {
    mz.max_grid_size = grid_size_z[0];
  }

  auto particle_grid_size_x =
      std::get<solver::NumberArray>(ii[PARTICLE_GRID_SIZE_X]);
  if (particle_grid_size_x.size() != 1) {
    require(PARTICLE_GRID_SIZE_X, messages, 1);
  } else {
    mx.particle_max_grid_size = particle_grid_size_x[0];
  }
  auto particle_grid_size_y =
      std::get<solver::NumberArray>(ii[PARTICLE_GRID_SIZE_Y]);
  if (particle_grid_size_y.size() != 1) {
    require(PARTICLE_GRID_SIZE_Y, messages, 1);
  } else {
    my.particle_max_grid_size = particle_grid_size_y[0];
  }
  auto particle_grid_size_z =
      std::get<solver::NumberArray>(ii[PARTICLE_GRID_SIZE_Z]);
  if (particle_grid_size_z.size() != 1) {
    require(PARTICLE_GRID_SIZE_Z, messages, 1);
  } else {
    mz.particle_max_grid_size = particle_grid_size_z[0];
  }

  auto bf = std::get<solver::NumberArray>(ii[BLOCKING_FACTOR]);
  if (bf.size() != 1) {
    require(BLOCKING_FACTOR, messages, 1);
  } else {
    mesh.blocking_factor = bf[0];
  }

  auto volfrac = std::get<solver::NumberArray>(ii[SMALL_VOLFRAC]);
  if (volfrac.size() != 1) {
    require(SMALL_VOLFRAC, messages, 1);
  } else {
    mesh.small_volfrac = volfrac[0];
  }

  mesh.axes[0] = mx;
  mesh.axes[1] = my;
  mesh.axes[2] = mz;

  return mesh;
}
} // namespace solver
