#include <sstream>

#include "solver_impl.hpp"

namespace solver {

void require(std::string key, std::vector<InputsMessage> messages, int size) {
  std::ostringstream oss;

  if (size == 0) {
    oss << "missing required key: " << key;
  } else if (size == 1) {
    oss << key << " is a scalar";
  } else if (size == 1) {
    oss << key << " requires " << size << " elements";
  }
  messages.push_back(InputsMessage{oss.str()});
}

std::pair<solver::SolverSettings, std::vector<InputsMessage>>
make_solver(solver::InputInfo ii) {
  std::vector<InputsMessage> messages;
  solver::SolverSettings ss;
  ss.geometry = make_geometry(ii, messages);
  ss.mesh = make_mesh(ii, messages);
  ss.time = make_time(ii, messages);
  return std::make_pair(ss, messages);
}

std::string serialize(solver::SolverSettings settings) {

  std::stringstream buffer;

  auto [xx, yy, zz] = settings.geometry.axes;
  buffer << std::endl;
  buffer << "  geometry.is_periodic = " << xx.periodic << " " << yy.periodic
         << " " << zz.periodic << std::endl;
  buffer << "  geometry.prob_lo     = " << xx.low << " " << yy.low << " "
         << zz.low << std::endl;
  buffer << "  geometry.prob_hi     = " << xx.high << " " << yy.high << " "
         << zz.high << std::endl;

  auto [mx, my, mz] = settings.mesh.axes;
  buffer << "  amr.n_cell      = " << mx.n_cell << " " << my.n_cell << " "
         << mz.n_cell;
  return buffer.str();
}

} // namespace solver
