#include "solver_impl.hpp"

namespace solver {

solver::TimeSettings make_time(solver::InputInfo ii,
                               std::vector<InputsMessage> messages) {
  solver::TimeSettings time;

  auto dt_max = std::get<solver::NumberArray>(ii[DT_MAX]);
  if (dt_max.size() != 1) {
    require(DT_MAX, messages, 1);
  } else {
    time.dt_max = dt_max[0];
  }

  auto dt_min = std::get<solver::NumberArray>(ii[DT_MIN]);
  if (dt_min.size() != 1) {
    require(DT_MIN, messages, 1);
  } else {
    time.dt_min = dt_min[0];
  }

  auto maxstep = std::get<solver::NumberArray>(ii[MAXSTEP]);
  if (maxstep.size() != 1) {
    require(MAXSTEP, messages, 1);
  } else {
    time.max_step = maxstep[0];
  }

  if (!ii.count(TSTOP)) {
    require(TSTOP, messages, 0);
  }
  auto tstop = std::get<solver::NumberArray>(ii[TSTOP]);
  if (tstop.size() != 1) {
    require(TSTOP, messages, 1);
  } else {
    time.tstop = tstop[0];
  }

  auto fixed_dt = std::get<solver::NumberArray>(ii[FIXED_DT]);
  if (fixed_dt.size() != 1) {
    require(FIXED_DT, messages, 1);
  } else {
    time.fixed_dt = (fixed_dt[0] != 0);
  }

  auto cfl = std::get<solver::NumberArray>(ii[CFL]);
  if (cfl.size() != 1) {
    require(CFL, messages, 1);
  } else {
    time.cfl = cfl[0];
  }

  auto tcoll_ratio = std::get<solver::NumberArray>(ii[TCOLL_RATIO]);
  if (tcoll_ratio.size() != 1) {
    require(TCOLL_RATIO, messages, 1);
  } else {
    time.tcoll_ratio = tcoll_ratio[0];
  }

  return time;
}
} // namespace solver
