#include <fstream>
#include <iostream>
#include <sstream>

#include "solver.hpp"

std::string read_file(std::string inputs_file) {
  std::ifstream in_stream;
  in_stream.open(inputs_file.c_str());

  std::stringstream str_stream;
  str_stream << in_stream.rdbuf();
  return str_stream.str();
}

int main(int argc, char *argv[]) {
  if (argc < 2) {
    std::cout << "Usage:  mfix-parser <inputs file>";
    return -1;
  }
  std::string fname(argv[1]);
  auto inputs_str = read_file(fname);
  auto maybe_success = solver::parse_inputs(inputs_str);
  if (maybe_success.has_value()) {
    return 0;
  }
  return -1;
}
