import shutil
import sys

from conans import ConanFile, Meson


class CsgEbConan(ConanFile):
    name = "csg-eb"
    version = "0.1"
    license = "<Put the package license here>"
    author = "Deepak Rangarajan <Deepak.Rangarajan@netl.doe.gov>"
    url = "https://mfix.netl.doe.gov/gitlab/exa/csg-eb"
    description = "Library for reading CSG geometry files"
    topics = ("<Put some tag here>", "<here>", "<and here>")
    settings = "os", "compiler", "build_type", "arch"
    options = {"shared": [True, False]}
    default_options = {"shared": False}
    generators = "pkg_config"
    requires = ("catch2/2.13.7", "cgal/5.2.1", "taocpp-pegtl/3.2.0")
    build_requires = ("meson/0.59.2", "pkgconf/1.7.4", "ninja/1.10.2")
    exports_sources = "meson.build", "include/*", "src/*"

    def build(self):
        meson = Meson(self)
        args = ["-Dcpp_std=vc++latest"] if sys.platform in ("win32", "cygwin") else []
        meson.configure(build_folder="build", args=args)
        meson.build()
        meson.meson_test(args=["--verbose", "--print-errorlog"])

    def package(self):
        self.copy("*.hpp", dst="include", src="include", keep_path=False)
        self.copy("*.a", dst="lib", keep_path=False)

    def package_info(self):
        self.cpp_info.includedirs = ["include"]
        self.cpp_info.libs = ["csg-eb"]
        self.cpp_info.defines = ["CSG_EB=1"]
