# MFIX-Exa Documentation
This is the documentation for MFIX-Exa. Every merge request to `main` will get
built and synced to the AWS S3 bucket, through the pipeline, making the edits live.
Side branches will only be built through the pipeline. The job artifact can be
downloaded to see the built documentation.

## User Manual

The MFIX-Exa User Manual is built using [sphinx](https://www.sphinx-doc.org/en/master/)
with the source located in `docs/user-manual`. The `docs/user-manual/config.py`
file contains the settings for building this documentation.

- AWS S3: https://exa-doc.s3.amazonaws.com/user-manual/latest/index.html
- MFIX: https://mfix.netl.doe.gov/doc/mfix-exa/guide/latest

## MFIX-Exa PIC VVA Manual

The MFIX-Exa User Manual is built using [sphinx](https://www.sphinx-doc.org/en/master/)
with the source located in `docs/picvva`. The `docs/picvva/config.py`
file contains the settings for building this documentation.

- AWS S3: https://exa-doc.s3.amazonaws.com/pic-vva/latest/index.html
- MFIX: https://mfix.netl.doe.gov/doc/mfix-exa/vva/pic/latest

## How to build docs locally

The documentation is built using
[sphinx](https://www.sphinx-doc.org/en/master/).  The documentation
can be built locally by:

1. Install sphinx:

```shell
> pip install sphinx sphinx_rtd_theme sphinx-tabs sphinxcontrib-bibtex
```

2. Build the documentation:

```shell
> mkdir build
> sphinx-build -b html docs/source_docs/ build
```

The HTML pages will now be located in the `build` directory. Open the
`index.html` with your favorite browser:

```shell
> firefox build/index.html
```
