# -*- coding: utf-8 -*-

import matplotlib.pyplot as plt
import numpy as np
import os, glob
from glob import glob
import csv

basepath = os.getcwd()
dirs = sorted(glob(basepath+str('/*/')))
fout1 = open('Bayesian_dp2_mean.dat','w')
fout2 = open('Bayesian_dp2_std.dat','w')

fout1.write('# Filename'+'\t'+'dp2_mean'+'\t'+'dp3_mean'+'\t'+'dp4_mean'+'\t'+'dp5_mean'+'\n')
fout2.write('# Filename'+'\t'+'dp2_std'+'\t'+'dp3_std'+'\t'+'dp4_std'+'\t'+'dp5_std'+'\n')

start = 2000
end = 4500

for entry in dirs:
    filename1 = str(entry)+'P1.csv'
    filename2 = str(entry)+'P2.csv'
    filename3 = str(entry)+'P3.csv'
    filename4 = str(entry)+'P4.csv'
    
    filenames = [filename1,filename2,filename3,filename4]
    data = np.genfromtxt(filename1, delimiter=",")
    t = data[start:end,0]
    p1 = data[start:end,1]
    
    data = np.genfromtxt(filename2, delimiter=",")
    t = data[start:end,0]
    p2 = data[start:end,1]
    
    data = np.genfromtxt(filename3, delimiter=",")
    t = data[start:end,0]
    p3 = data[start:end,1]
    
    data = np.genfromtxt(filename4, delimiter=",")
    t = data[start:end,0]
    p4 = data[start:end,1]
    
    dp2_mean = np.mean(p1-p2)
    dp3_mean = np.mean(p2-p3)
    dp4_mean = np.mean(p3-p4)
    dp5_mean = np.mean(p1-p4)
    dp2pdp3_mean = np.mean(p1-p3)
    
    dp2_std = np.std(p1-p2)
    dp3_std = np.std(p2-p3)
    dp4_std = np.std(p3-p4)
    dp5_std = np.std(p1-p4)
    dp2pdp3_std = np.std(p1-p3)
    
    fout1.write(str(entry)  + '\t ' + str(dp2_mean) + '\t ' + str(dp3_mean) + '\t' + str(dp4_mean) + '\t ' + str(dp5_mean) + '\n');
    fout2.write(str(entry)  + '\t ' + str(dp2_std) + '\t ' + str(dp3_std) + '\t' + str(dp4_std) + '\t ' + str(dp5_std) + '\n');
    
fout1.close
fout2.close
