import os, glob
import numpy as np
from glob import glob

basepath = os.getcwd()
j_slices = 5
dirs = sorted(glob(basepath+str('/*/')))

with open('Input_OLH_n120_i6_11June2020_rerun_April2021.csv') as f1:
	data = np.genfromtxt(f1,delimiter=',')
	theta1 = data[:,0]
	theta2 = data[:,1]
	theta3 = data[:,2]
	theta4 = data[:,3]
	theta5 = data[:,4]
	x1 = data[:,5]

count = 0

for entry in dirs:
	fname=str(entry)+str('/VF.dat')
	dir_name = os.path.basename(os.path.dirname(entry))

	with open(fname) as f1:
		lines1 = f1.readlines()[5:]
	
	f1.close()
	
	start=0
	end = len(lines1)
	
	x = []
	y = []
	z = []
	vf = []
	
	for line in lines1[start:end]:
		values = [float(s) for s in line.split()]
		x.append(values[0])
		y.append(values[1])
		z.append(values[2])
		vf.append(values[3])
	
	startk = 0
	endk = int((end + 1)/j_slices - 1)
	
	ycut_settling = []
	ycut_filling = []
	vf_filling = []

	vf_upper = 0.5*(1.0+(1.0-x1[count+1])) # mean of ep_g= 1.0-x1 and 1.0
		
	for j in range(j_slices):
		for k in range(endk-2,startk,-1):
			if (vf[k] < vf_upper):	
				break
		ycut_settling.append(y[k])
		startk = endk + 1
		endk = startk + int((end + 1)/j_slices - 1)

	ycut_settling_mean = np.mean(np.asarray(ycut_settling))

	startk = 0
	endk = int((end + 1)/j_slices - 1)

	vf_lower = 0.5*(0.40 + (1.0-x1[count+1])) # mean of ep_g= 1.0-x1 and 0.4

	for j in range(j_slices):
		for k in range(startk+2,endk):
			if (vf[k] > vf_lower):	
				break
		ycut_filling.append(y[k])
		vf_filling.append(vf[startk])
		startk = endk + 1
		endk = startk + int((end + 1)/j_slices - 1)
	
	ycut_filling_mean = np.mean(np.asarray(ycut_filling))
	vf_filling_mean = np.mean(np.asarray(vf_filling))
	
	print (dir_name, ycut_settling_mean,ycut_filling_mean,vf_filling_mean)
	#print (vf_filling_mean)
	
	count = count + 1
