/* *************************************/
/* Regression interpolator from PSUADE.*/
/* ====================================*/
/* This file contains information for interpolation
   using response surface. Follow the steps below:
   1. move this file to *.c file (e.g. main.c)
   2. Compile main.c (cc -o main main.c -lm)
   3. run: main input output
          where input has the number of inputs and
          the input values
*/
/* ====================================*/
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
/*AIKE add string.h */
#include <string.h>
int interpolate(int,double*,double*,double*);
/*AIKE added int main to main */
/* main(int argc, char **argv) */
int main(int argc, char **argv) {
  int    ii, iOne=1, nInps; /*AIKE replaced i with ii */
  double X[6], Y, S;
  double SSE;  /*AIKE added SSE declaration */
  /*AIKE Add experimental dataset */
  double Exp[21][4] = {
       {1,  0.25, 0.088980934,  0.001},
       {2,  0.24, 0.088593673,  0.001},
       {3,  0.23, 0.088014071,  0.001},
       {4,  0.22, 0.087231143,  0.001},
       {5,  0.21, 0.0862336,    0.001},
       {6,  0.2,  0.085009842,  0.001},
       {7,  0.19, 0.08354796,   0.001},
       {8,  0.18, 0.081835729,  0.001},
       {9,  0.17, 0.079860606,  0.001},
       {10, 0.16, 0.077609728,  0.001},
       {11, 0.15, 0.075069909,  0.001},
       {12, 0.14, 0.072227635,  0.001},
       {13, 0.13, 0.069069065,  0.001},
       {14, 0.12, 0.065580023,  0.001},
       {15, 0.11, 0.061746,     0.001},
       {16, 0.1,  0.057552148,  0.001},
       {17, 0.09, 0.052983279,  0.001},
       {18, 0.08, 0.048023859,  0.001},
       {19, 0.07, 0.042658011,  0.001},
       {20, 0.06, 0.036869505,  0.001},
       {21, 0.05, 0.03064176,   0.001}
      };
  /* AIKE debug prints
  printf("sizeof of Exp array: %d\n", (int) sizeof(Exp));
  printf("Length of array: %d\n", (int)( sizeof(Exp) / sizeof(Exp[0]) ));
  */
  size_t nExp = sizeof Exp / sizeof *Exp;
  //AIKE printf("Length of array: %d\n", nExp);
  FILE   *fIn=NULL, *fOut=NULL;
  /* AIKE modified argc < 3 to < 2 */
  if (argc < 2) {
    printf("ERROR: not enough argument.\n");
    exit(1);
  }
  fIn = fopen(argv[1], "r");
  if (fIn == NULL) {
    printf("ERROR: cannot open input file.\n");
    exit(1);
  }
  fscanf(fIn, "%d", &nInps);
  /*AIKE changed nInps != 6 from 6 to 5 */
  if (nInps != 5) {
    printf("ERROR - wrong nInputs.\n");
    exit(1);
  }
  /*AIKE changed counter from i to ii and replaced 6 with nInps */
  for (ii=0; ii<nInps; ii++) fscanf(fIn, "%lg", &X[ii]);
  fclose(fIn);
  /*AIKE replace the following two lines with the SSE=0 block */
  /*   interpolate(iOne, X, &Y, &S);
  printf("Y = %e (stdev = %e)\n", Y, Std); */
  SSE = 0;
  /* AIKE must change 21 in loop if Exp size changes */
  for (ii = 0; ii < nExp; ii++)
  {
    X[5] = Exp[ii][1];
    interpolate(iOne, X, &Y, &S);
    SSE += (Y - Exp[ii][2]) * (Y - Exp[ii][2]);
  }

  printf("SSE = %e\n", SSE);
  printf("S = %e\n", S);
  /* AIKE added if (argc >= 3) {} conditional */
  if (argc >= 3)
  {
     fOut = fopen(argv[2], "w");
     if (fOut == NULL) {
       printf("ERROR: cannot open output file.\n");
       exit(1);
     }
  /*AIKE changed Y to finalY */
  /* fprintf(fOut," %e\n", Y); */
  fprintf(fOut," %e\n", SSE);
  fclose(fOut);
  }
}

/* *************************************/
/*  Regression interpolation function  */
/* X[0], X[1],   .. X[m-1]   - first point
 * X[m], X[m+1], .. X[2*m-1] - second point
 * ... */
/* ==============================================*/
static double
regCoefs[28] =
{
   7.4256517826636947e-02,
   1.2522443805619340e-03,
  -6.8555069513462699e-04,
  -4.5185820166751822e-03,
   3.6196289098024276e-03,
   6.0573673282075515e-03,
   1.5704961810162666e-02,
  -3.9803144213754367e-04,
  -3.0355193775881401e-04,
   1.6773732655192173e-04,
   7.1779877410649230e-04,
   5.1316386598481128e-05,
   7.5250412230351419e-04,
  -7.3358870508534457e-04,
   1.5774405858163133e-06,
  -4.1924696923418512e-04,
  -3.2675165344887044e-04,
   4.3055881204692161e-04,
  -7.0951434196170164e-04,
  -1.5940467756838032e-03,
   8.9583195320890984e-04,
  -1.9357161833230190e-03,
   6.4094239515662468e-04,
   5.1820193283413907e-04,
   1.4399622115568228e-03,
  -5.5835507448139671e-05,
   4.8210895251541127e-03,
  -3.5517059206310536e-03,
};
static double invCovMat[28][28] =
{
 {   9.8087817118827098e-07,  -6.5237885065269102e-10,   4.4654696272816927e-09,  -1.6776250701176878e-09,  -4.5056518825186766e-09,   1.6021560441632130e-09,  -5.5293031874711776e-09,  -1.5357717596538992e-07,   4.1325938238304118e-09,   1.2604392833086423e-08,   9.1896701127283564e-09,  -7.9351346419032686e-09,   1.8282978976619163e-08,  -1.4520860893393185e-07,  -1.2453343225920266e-08,  -3.2003798668808637e-09,  -1.1417607586925336e-08,  -2.0507340033771864e-08,  -1.5450946145685117e-07,  -2.9889610658448534e-09,   6.0695789766595900e-09,   1.2142160292650630e-08,  -1.4709780114026771e-07,  -1.1936702922076714e-08,  -2.7564365408685021e-08,  -1.4159565776157470e-07,  -6.8944764512948173e-09,  -1.5448691165900089e-07 },
 {  -6.5237885065269112e-10,   9.2622280667067646e-08,   4.2829328252198576e-11,   4.3376301911617837e-10,   1.3611818208570968e-10,  -8.5502516273431538e-11,   1.0193911236348321e-10,  -2.8695442773465258e-10,  -1.7165761488065882e-09,   1.1756088835165146e-09,   1.7933042197982583e-09,  -1.2862098210716235e-09,   2.5071986236778870e-11,   6.7004633711948053e-10,  -1.9852185518459977e-09,   4.9818647371288094e-10,  -2.9279848855834975e-09,   2.7567715648957480e-09,  -7.0447380172702524e-10,   1.5354969155167934e-09,   1.9449067400532572e-09,  -4.0350409703381685e-09,   8.8092739920422906e-10,   2.3413565032989414e-09,   3.0997870998254777e-10,  -6.6798519491584222e-10,   7.3291215776868579e-10,   7.6113726760064079e-10 },
 {   4.4654696272816927e-09,   4.2829328252196870e-11,   9.2503982553903795e-08,  -1.7304965540123424e-11,  -3.2881139271038152e-10,  -4.8867878544106840e-10,  -4.9737239969518482e-10,  -1.7625027739720289e-09,   7.3609283219615985e-10,  -1.6025885835214775e-09,   1.8055124375764438e-10,  -2.8379812598503986e-09,   2.3229316698748519e-09,  -1.4044489963121393e-10,  -1.8225384503933935e-10,   7.6557232554041559e-10,  -6.5629509746761932e-10,   2.1344741490416580e-09,  -1.8507593867741831e-09,  -8.5077205867111845e-10,   9.3858868121863916e-10,   1.1280268213050526e-09,  -1.0144300582707539e-09,  -1.5446729122910369e-09,   1.7806427170979337e-09,  -6.3406095292767319e-10,   7.0192288582485005e-10,   8.9126428854810474e-10 },
 {  -1.6776250701176878e-09,   4.3376301911618178e-10,  -1.7304965540125182e-11,   9.2693315377695829e-08,   3.0570937453882394e-10,   4.7232647053628430e-10,   3.9569068805035802e-10,   1.6000614930995489e-09,  -1.7293355804359884e-09,  -1.2819966275618911e-09,   1.6138898337091723e-09,   2.1893296193910341e-09,  -4.3140337216009984e-09,   7.1617997204415858e-10,  -9.5958262754897558e-10,  -8.2269358229596728e-10,   1.3444355035920332e-09,   2.0038158896965723e-09,  -7.6465206499427750e-11,   9.1201080613513893e-10,  -3.0730570942019748e-10,   1.4985127971166946e-09,   8.5482246282938984e-10,   9.3218605941277775e-10,   3.9699519005265539e-09,  -6.6285208990802129e-10,   2.7150288581579248e-09,  -7.7405775893445764e-10 },
 {  -4.5056518825186766e-09,   1.3611818208570474e-10,  -3.2881139271037832e-10,   3.0570937453882735e-10,   9.2452144515383277e-08,  -2.1757331232371243e-10,  -4.8547163300462915e-10,   7.0987722953432275e-10,  -1.3953418569103352e-10,   1.0911240989526563e-09,   6.2484399367578920e-10,   2.2443731214758826e-09,   9.0129730341763086e-10,   5.9445332832548296e-11,  -2.1614164987184333e-10,  -9.2915974956451055e-10,  -1.5487847018151758e-09,   1.8487878004535236e-09,   1.4300500294528481e-09,   6.3940240069081423e-10,   1.0864812684064124e-09,   3.2471344848470210e-09,   3.7648296887161627e-10,   1.6790238743639306e-10,   1.5930063368072316e-09,   1.2939421221683217e-09,  -1.1050403095202990e-09,   6.8145553432963205e-10 },
 {   1.6021560441632130e-09,  -8.5502516273431434e-11,  -4.8867878544106840e-10,   4.7232647053628410e-10,  -2.1757331232371243e-10,   9.2486130345213076e-08,   1.3839434239013755e-10,  -7.8601344490427938e-10,  -3.7081834006340581e-09,   2.0453137712876599e-09,   1.8400062768695330e-09,  -1.0112400551356963e-09,   6.2552296630808918e-11,  -1.2454997512417360e-09,   1.0150017378878963e-09,  -1.5195496542808978e-09,  -7.8797737743299925e-10,   1.4582099190625514e-09,   3.3659869241935358e-10,   6.0127275731323985e-10,  -4.0687146268011911e-10,   2.1797569385012483e-09,  -8.0916848876339942e-10,   1.9547149687268369e-09,  -1.9070323966446342e-09,   7.7586944422885678e-11,   3.3103931072359434e-10,   8.3492668302107580e-10 },
 {  -5.5293031874711776e-09,   1.0193911236348321e-10,  -4.9737239969518317e-10,   3.9569068805035389e-10,  -4.8547163300462925e-10,   1.3839434239013918e-10,   9.2745345525994088e-08,  -5.7714375224916725e-10,   2.4012542665649476e-09,  -4.2213272718868875e-09,   1.0485290464847326e-09,   3.0039640242094445e-10,   3.2455052197390784e-10,   2.9475593059255239e-09,   1.3555265555102764e-09,   2.2637767819247785e-09,   6.6921156554052887e-10,   1.0980261645170334e-09,   1.3124715576428122e-09,   3.1673690523954159e-09,   2.2953430401628681e-09,  -9.5973840999589552e-10,   2.1962982803246268e-09,  -1.9680146624243752e-09,   1.0002933849209533e-09,  -5.0475596440292339e-10,   2.9124640067642079e-10,   1.8550174018888982e-10 },
 {  -1.5357717596538992e-07,  -2.8695442773465341e-10,  -1.7625027739720291e-09,   1.6000614930995500e-09,   7.0987722953432027e-10,  -7.8601344490427949e-10,  -5.7714375224916456e-10,   1.1972469081339691e-07,  -6.4040196060566157e-10,  -1.1992114725380203e-09,  -1.9596235350127469e-09,   1.4455269815319044e-09,  -3.8157572902044027e-09,   8.2626419971406394e-09,   3.9687824399757427e-10,  -4.0379855582661679e-09,   8.6746179425566382e-09,   5.5585283268474261e-09,   8.0431958185340710e-09,  -2.0041611317014308e-09,  -2.5924800305723094e-09,   1.4523094313905325e-09,   9.4161600620761259e-09,   2.5848859240320259e-09,   3.0037222276822671e-09,   2.9404221405298672e-09,  -2.8746714239899190e-09,   6.3537134468374146e-09 },
 {   4.1325938238304118e-09,  -1.7165761488065882e-09,   7.3609283219615510e-10,  -1.7293355804359888e-09,  -1.3953418569103187e-10,  -3.7081834006340573e-09,   2.4012542665649476e-09,  -6.4040196060566157e-10,   1.0546568617160170e-07,  -4.8295631921116059e-09,  -6.5484179463566120e-09,   7.7230504017657182e-09,   1.7801960053657660e-09,   1.8884400166280101e-09,  -5.7511736788958768e-09,  -4.4764219498729179e-10,   1.8633327455314600e-09,  -1.2620844848132266e-08,  -6.1310645184284362e-09,  -2.9994608468127198e-09,  -1.3462943879589441e-09,  -5.4214942155994416e-09,   3.7949052769880271e-09,  -1.6553035314772029e-08,   9.0719999648004458e-09,  -2.7426920514661905e-09,  -1.5657610153758802e-08,  -3.6446115179145189e-10 },
 {   1.2604392833086423e-08,   1.1756088835165162e-09,  -1.6025885835214781e-09,  -1.2819966275618920e-09,   1.0911240989526610e-09,   2.0453137712876591e-09,  -4.2213272718868858e-09,  -1.1992114725380207e-09,  -4.8295631921116093e-09,   1.0243735068409267e-07,   1.3246499171170334e-09,  -2.1014147622279698e-09,   4.1302113986739277e-09,  -8.5551978051404309e-09,  -2.8152992034829579e-09,  -3.3621216509504562e-09,  -1.8536783445796747e-09,  -4.2571595421969886e-09,   3.5383945079689497e-09,   6.5529450276051461e-10,   3.0001176775305269e-09,   1.4230423786920661e-09,  -5.3865175651197778e-09,   1.5195756004251805e-08,  -8.2918227419139369e-09,  -8.1687379544982283e-11,   1.3144058774701456e-08,  -4.9503014835683874e-10 },
 {   9.1896701127283564e-09,   1.7933042197982583e-09,   1.8055124375763958e-10,   1.6138898337091721e-09,   6.2484399367579251e-10,   1.8400062768695326e-09,   1.0485290464847318e-09,  -1.9596235350127461e-09,  -6.5484179463566120e-09,   1.3246499171170285e-09,   1.0709188793367348e-07,  -9.8923367550361117e-10,   4.1069236281980474e-09,  -3.2379507869110296e-11,  -5.0490509243498860e-09,   3.8574592168692784e-09,  -1.4339393133727593e-08,   1.1630362997564761e-08,   2.1574040020588348e-09,  -1.6730268814030881e-09,   1.2773867046664368e-08,  -8.7584929408365913e-09,   1.9501976158283345e-09,   8.2536921862430618e-09,  -2.8201353907279484e-09,  -1.9494462099651178e-09,   1.2626630011777532e-08,  -9.2114851263421867e-09 },
 {  -7.9351346419032686e-09,  -1.2862098210716233e-09,  -2.8379812598503978e-09,   2.1893296193910308e-09,   2.2443731214758838e-09,  -1.0112400551356970e-09,   3.0039640242094570e-10,   1.4455269815319057e-09,   7.7230504017657182e-09,  -2.1014147622279698e-09,  -9.8923367550361117e-10,   1.0278525582691416e-07,  -5.6676812362585258e-09,   3.2520752437638348e-09,  -6.1083042084873948e-10,  -1.4091789199107218e-08,  -1.0338477589143329e-09,  -1.2700990904912099e-08,   2.2541637247620759e-09,   1.1986418113322730e-08,   1.5461271982249625e-09,   1.1768457348199363e-08,   6.0005002189223891e-09,  -3.7050440062926325e-09,   1.1075391946949388e-08,   3.6862866245306907e-10,  -1.8434541066208727e-09,  -5.3143232164999877e-09 },
 {   1.8282978976619163e-08,   2.5071986236778457e-11,   2.3229316698748535e-09,  -4.3140337216009993e-09,   9.0129730341763158e-10,   6.2552296630808931e-11,   3.2455052197390634e-10,  -3.8157572902044044e-09,   1.7801960053657660e-09,   4.1302113986739294e-09,   4.1069236281980441e-09,  -5.6676812362585225e-09,   1.0382854392283115e-07,  -1.2725315327010366e-08,  -8.0042109697770004e-09,   8.6689718618100760e-09,  -1.2143941983985414e-08,   1.8867232398864304e-09,   1.8847605535946269e-09,  -5.3263845767025550e-09,   1.1739997523484123e-08,  -2.5659427968757756e-09,  -3.2479698737438785e-09,   1.0939084148217268e-08,  -8.6881174720246979e-09,  -1.8884203081555096e-10,  -3.5226317967130775e-09,  -1.8436305046136631e-10 },
 {  -1.4520860893393185e-07,   6.7004633711948073e-10,  -1.4044489963121361e-10,   7.1617997204415869e-10,   5.9445332832550985e-11,  -1.2454997512417325e-09,   2.9475593059255219e-09,   8.2626419971406394e-09,   1.8884400166280101e-09,  -8.5551978051404276e-09,  -3.2379507869105333e-11,   3.2520752437638340e-09,  -1.2725315327010366e-08,   1.2001334735425270e-07,   2.0043472336186475e-09,  -7.7760800697032217e-11,   1.9567101975967492e-09,   1.2744280053902194e-09,   6.8991857162342425e-09,   6.4328540095475155e-10,  -1.7813932879212945e-12,   9.7065414857702832e-10,   4.0786274975365751e-09,  -7.3818171770212625e-09,   7.0527082599052016e-09,   1.8872986078234658e-09,  -8.1478339437269919e-11,   5.2157376102693258e-09 },
 {  -1.2453343225920266e-08,  -1.9852185518459957e-09,  -1.8225384503933852e-10,  -9.5958262754897600e-10,  -2.1614164987184333e-10,   1.0150017378878967e-09,   1.3555265555102760e-09,   3.9687824399757489e-10,  -5.7511736788958768e-09,  -2.8152992034829603e-09,  -5.0490509243498835e-09,  -6.1083042084874320e-10,  -8.0042109697770020e-09,   2.0043472336186466e-09,   1.0079457306339624e-07,  -1.5391961306320702e-10,   3.3579991764737558e-09,   1.0089937202032177e-09,   2.0155510407607752e-09,  -3.6748954411454670e-09,  -4.8676253020435983e-09,   8.8388024407253562e-09,   3.4869502949355403e-09,  -5.4918002110280808e-09,  -2.2895170310338736e-09,   4.9454087421126767e-09,   4.0295245813696826e-09,  -2.6596932459438605e-10 },
 {  -3.2003798668808633e-09,   4.9818647371288052e-10,   7.6557232554041797e-10,  -8.2269358229596811e-10,  -9.2915974956451096e-10,  -1.5195496542808963e-09,   2.2637767819247818e-09,  -4.0379855582661671e-09,  -4.4764219498729179e-10,  -3.3621216509504596e-09,   3.8574592168692784e-09,  -1.4091789199107221e-08,   8.6689718618100777e-09,  -7.7760800697036352e-11,  -1.5391961306320722e-10,   9.9208013953375636e-08,  -7.0074795379267424e-09,   4.6888888591896366e-09,  -3.8480754390744694e-09,   1.4193778472431117e-09,  -4.6029152182062711e-09,  -6.4269997367400509e-09,   9.6111639802944462e-10,  -2.3113368308708485e-09,  -3.7593073419484451e-09,   2.9387310630104296e-09,   7.5052389820498003e-09,   6.9354057910712338e-09 },
 {  -1.1417607586925336e-08,  -2.9279848855834992e-09,  -6.5629509746761787e-10,   1.3444355035920365e-09,  -1.5487847018151740e-09,  -7.8797737743300049e-10,   6.6921156554052557e-10,   8.6746179425566382e-09,   1.8633327455314583e-09,  -1.8536783445796764e-09,  -1.4339393133727596e-08,  -1.0338477589143379e-09,  -1.2143941983985414e-08,   1.9567101975967492e-09,   3.3579991764737591e-09,  -7.0074795379267416e-09,   9.9067889546711690e-08,   4.0520462372831753e-10,  -2.1663751777497914e-09,  -5.2810423265544346e-09,   1.1981074201978659e-09,   6.0957553660713486e-09,  -3.4251997700192689e-09,  -4.6388324852923705e-10,   9.0462741618360787e-09,  -3.5503881604601770e-10,  -2.6720383360741204e-09,   6.2707425501566517e-09 },
 {  -2.0507340033771864e-08,   2.7567715648957451e-09,   2.1344741490416571e-09,   2.0038158896965748e-09,   1.8487878004535236e-09,   1.4582099190625534e-09,   1.0980261645170336e-09,   5.5585283268474245e-09,  -1.2620844848132266e-08,  -4.2571595421969886e-09,   1.1630362997564759e-08,  -1.2700990904912101e-08,   1.8867232398864288e-09,   1.2744280053902227e-09,   1.0089937202032199e-09,   4.6888888591896350e-09,   4.0520462372831588e-10,   1.0328213261959763e-07,   1.2689982759239642e-08,  -5.1957410996729684e-09,   4.5741212279172802e-09,  -2.9551517326219286e-09,  -9.3209363783861337e-10,   1.1196469696754801e-08,   4.2400082462151652e-09,   1.7253549493298997e-09,   7.8663266269961632e-09,  -3.6387646731774690e-10 },
 {  -1.5450946145685117e-07,  -7.0447380172702896e-10,  -1.8507593867741822e-09,  -7.6465206499427750e-11,   1.4300500294528481e-09,   3.3659869241935379e-10,   1.3124715576428122e-09,   8.0431958185340710e-09,  -6.1310645184284329e-09,   3.5383945079689464e-09,   2.1574040020588348e-09,   2.2541637247620759e-09,   1.8847605535946265e-09,   6.8991857162342458e-09,   2.0155510407607727e-09,  -3.8480754390744703e-09,  -2.1663751777497951e-09,   1.2689982759239642e-08,   1.2158656502029134e-07,  -6.1440807828235861e-10,   5.1841007071716494e-10,  -1.3441501567002269e-09,   5.5798458653584103e-09,   1.3524002490572512e-08,   1.5511036928419315e-10,   7.0410215640340714e-09,   2.9669835221275954e-09,   6.5729260555758747e-09 },
 {  -2.9889610658448534e-09,   1.5354969155167924e-09,  -8.5077205867111866e-10,   9.1201080613514234e-10,   6.3940240069081423e-10,   6.0127275731323861e-10,   3.1673690523954163e-09,  -2.0041611317014308e-09,  -2.9994608468127207e-09,   6.5529450276051461e-10,  -1.6730268814030848e-09,   1.1986418113322731e-08,  -5.3263845767025517e-09,   6.4328540095475165e-10,  -3.6748954411454679e-09,   1.4193778472431117e-09,  -5.2810423265544363e-09,  -5.1957410996729667e-09,  -6.1440807828235530e-10,   9.9848026882540406e-08,   8.0178790495201738e-09,  -6.8639591473299243e-10,   2.8160915225189921e-09,  -5.8071466743143026e-10,  -5.2686180612805968e-09,   8.7218677226543154e-10,   8.6163566541468131e-11,   1.6416684730738497e-09 },
 {   6.0695789766595891e-09,   1.9449067400532560e-09,   9.3858868121863999e-10,  -3.0730570942019769e-10,   1.0864812684064124e-09,  -4.0687146268011994e-10,   2.2953430401628681e-09,  -2.5924800305723094e-09,  -1.3462943879589432e-09,   3.0001176775305261e-09,   1.2773867046664363e-08,   1.5461271982249583e-09,   1.1739997523484123e-08,  -1.7813932879196401e-12,  -4.8676253020435975e-09,  -4.6029152182062728e-09,   1.1981074201978668e-09,   4.5741212279172786e-09,   5.1841007071716453e-10,   8.0178790495201738e-09,   1.0166772725835549e-07,  -8.8956342499778650e-10,  -1.1135158647985335e-09,   3.7808022000240063e-09,  -8.5757165528473004e-10,   4.9571837561110276e-11,  -4.8451715526750763e-09,  -2.4655423873557958e-09 },
 {   1.2142160292650630e-08,  -4.0350409703381677e-09,   1.1280268213050521e-09,   1.4985127971166921e-09,   3.2471344848470210e-09,   2.1797569385012488e-09,  -9.5973840999589676e-10,   1.4523094313905358e-09,  -5.4214942155994399e-09,   1.4230423786920694e-09,  -8.7584929408365897e-09,   1.1768457348199369e-08,  -2.5659427968757789e-09,   9.7065414857702666e-10,   8.8388024407253529e-09,  -6.4269997367400509e-09,   6.0957553660713453e-09,  -2.9551517326219302e-09,  -1.3441501567002293e-09,  -6.8639591473299243e-10,  -8.8956342499778733e-10,   1.0147801338627873e-07,  -7.3543044915883850e-09,  -2.6399560449743337e-10,   2.3299557752070458e-09,  -6.7455712771525025e-09,  -9.2905440163759248e-10,   1.1130094329399792e-09 },
 {  -1.4709780114026771e-07,   8.8092739920422700e-10,  -1.0144300582707529e-09,   8.5482246282939191e-10,   3.7648296887161679e-10,  -8.0916848876339942e-10,   2.1962982803246268e-09,   9.4161600620761226e-09,   3.7949052769880271e-09,  -5.3865175651197761e-09,   1.9501976158283353e-09,   6.0005002189223891e-09,  -3.2479698737438752e-09,   4.0786274975365751e-09,   3.4869502949355403e-09,   9.6111639802944296e-10,  -3.4251997700192656e-09,  -9.3209363783861544e-10,   5.5798458653584170e-09,   2.8160915225189888e-09,  -1.1135158647985321e-09,  -7.3543044915883850e-09,   1.1960901033534644e-07,  -1.9883274176047385e-09,   2.9186366933426895e-09,   1.6340759569223538e-09,   1.9168667048848543e-09,   7.9814767419855623e-09 },
 {  -1.1936702922076714e-08,   2.3413565032989419e-09,  -1.5446729122910377e-09,   9.3218605941277692e-10,   1.6790238743639327e-10,   1.9547149687268377e-09,  -1.9680146624243752e-09,   2.5848859240320242e-09,  -1.6553035314772035e-08,   1.5195756004251805e-08,   8.2536921862430684e-09,  -3.7050440062926325e-09,   1.0939084148217271e-08,  -7.3818171770212642e-09,  -5.4918002110280816e-09,  -2.3113368308708485e-09,  -4.6388324852923870e-10,   1.1196469696754801e-08,   1.3524002490572507e-08,  -5.8071466743143067e-10,   3.7808022000240038e-09,  -2.6399560449743668e-10,  -1.9883274176047385e-09,   1.0263589158443886e-07,  -2.6418797600795822e-10,   1.4440613092550386e-09,   1.5387109537051932e-08,   3.5863713008584347e-09 },
 {  -2.7564365408685021e-08,   3.0997870998254627e-10,   1.7806427170979337e-09,   3.9699519005265556e-09,   1.5930063368072333e-09,  -1.9070323966446346e-09,   1.0002933849209548e-09,   3.0037222276822667e-09,   9.0719999648004458e-09,  -8.2918227419139402e-09,  -2.8201353907279467e-09,   1.1075391946949384e-08,  -8.6881174720247012e-09,   7.0527082599052058e-09,  -2.2895170310338686e-09,  -3.7593073419484401e-09,   9.0462741618360787e-09,   4.2400082462151668e-09,   1.5511036928419397e-10,  -5.2686180612806001e-09,  -8.5757165528472673e-10,   2.3299557752070425e-09,   2.9186366933426854e-09,  -2.6418797600795987e-10,   1.0491574520644845e-07,   1.3795506077563023e-08,   1.2710997642831047e-09,   2.1784198465961952e-10 },
 {  -1.4159565776157467e-07,  -6.6798519491584325e-10,  -6.3406095292767402e-10,  -6.6285208990802191e-10,   1.2939421221683217e-09,   7.7586944422884954e-11,  -5.0475596440292174e-10,   2.9404221405298672e-09,  -2.7426920514661913e-09,  -8.1687379544980215e-11,  -1.9494462099651211e-09,   3.6862866245307196e-10,  -1.8884203081555054e-10,   1.8872986078234625e-09,   4.9454087421126718e-09,   2.9387310630104304e-09,  -3.5503881604601976e-10,   1.7253549493299043e-09,   7.0410215640340648e-09,   8.7218677226543134e-10,   4.9571837561109655e-11,  -6.7455712771525009e-09,   1.6340759569223471e-09,   1.4440613092550373e-09,   1.3795506077563022e-08,   1.2001856841594096e-07,   3.5917502873359300e-09,   9.1563075014725103e-09 },
 {  -6.8944764512948173e-09,   7.3291215776868372e-10,   7.0192288582484819e-10,   2.7150288581579240e-09,  -1.1050403095202994e-09,   3.3103931072359434e-10,   2.9124640067642141e-10,  -2.8746714239899173e-09,  -1.5657610153758799e-08,   1.3144058774701454e-08,   1.2626630011777534e-08,  -1.8434541066208694e-09,  -3.5226317967130837e-09,  -8.1478339437268264e-11,   4.0295245813696842e-09,   7.5052389820497954e-09,  -2.6720383360741188e-09,   7.8663266269961583e-09,   2.9669835221275970e-09,   8.6163566541468338e-11,  -4.8451715526750796e-09,  -9.2905440163759000e-10,   1.9168667048848535e-09,   1.5387109537051932e-08,   1.2710997642831063e-09,   3.5917502873359300e-09,   1.0678400916641816e-07,   1.7533109269346943e-09 },
 {  -1.5448691165900086e-07,   7.6113726760063903e-10,   8.9126428854810484e-10,  -7.7405775893445743e-10,   6.8145553432963081e-10,   8.3492668302107311e-10,   1.8550174018888972e-10,   6.3537134468374112e-09,  -3.6446115179145179e-10,  -4.9503014835683585e-10,  -9.2114851263421867e-09,  -5.3143232164999877e-09,  -1.8436305046136465e-10,   5.2157376102693225e-09,  -2.6596932459438439e-10,   6.9354057910712305e-09,   6.2707425501566483e-09,  -3.6387646731775062e-10,   6.5729260555758747e-09,   1.6416684730738497e-09,  -2.4655423873557958e-09,   1.1130094329399804e-09,   7.9814767419855656e-09,   3.5863713008584343e-09,   2.1784198465962200e-10,   9.1563075014725087e-09,   1.7533109269346980e-09,   1.2042729483304084e-07 },
};
static int N=28;
/* ====================================*/
int interpolate(int npts,double *X,double *Y,double *S){
  int    ii, jj, kk, nInps=6;
  double y, *x, *x2, std, dtmp;
  x2 = (double *) malloc(28 * sizeof(double));
  for (ii = 0; ii < npts; ii++) {
    x = &X[ii * 6];
    y = regCoefs[0];
    x2[0] = 1.0;
    x2[1] = (x[0] - 1.019283e+01) / 5.700418e+00;
    x2[2] = (x[1] - 3.502822e+00) / 8.787263e-01;
    x2[3] = (x[2] - 1.153600e+01) / 4.993532e+00;
    x2[4] = (x[3] - 4.250141e-01) / 4.345087e-02;
    x2[5] = (x[4] - 7.499306e-01) / 1.450351e-01;
    x2[6] = (x[5] - 1.500666e-01) / 5.816071e-02;
    y += regCoefs[1] * x2[1];
    y += regCoefs[2] * x2[2];
    y += regCoefs[3] * x2[3];
    y += regCoefs[4] * x2[4];
    y += regCoefs[5] * x2[5];
    y += regCoefs[6] * x2[6];
    y += regCoefs[7] * x2[1] * x2[1];
    x2[7] = x2[1] * x2[1];
    y += regCoefs[8] * x2[1] * x2[2];
    x2[8] = x2[1] * x2[2];
    y += regCoefs[9] * x2[1] * x2[3];
    x2[9] = x2[1] * x2[3];
    y += regCoefs[10] * x2[1] * x2[4];
    x2[10] = x2[1] * x2[4];
    y += regCoefs[11] * x2[1] * x2[5];
    x2[11] = x2[1] * x2[5];
    y += regCoefs[12] * x2[1] * x2[6];
    x2[12] = x2[1] * x2[6];
    y += regCoefs[13] * x2[2] * x2[2];
    x2[13] = x2[2] * x2[2];
    y += regCoefs[14] * x2[2] * x2[3];
    x2[14] = x2[2] * x2[3];
    y += regCoefs[15] * x2[2] * x2[4];
    x2[15] = x2[2] * x2[4];
    y += regCoefs[16] * x2[2] * x2[5];
    x2[16] = x2[2] * x2[5];
    y += regCoefs[17] * x2[2] * x2[6];
    x2[17] = x2[2] * x2[6];
    y += regCoefs[18] * x2[3] * x2[3];
    x2[18] = x2[3] * x2[3];
    y += regCoefs[19] * x2[3] * x2[4];
    x2[19] = x2[3] * x2[4];
    y += regCoefs[20] * x2[3] * x2[5];
    x2[20] = x2[3] * x2[5];
    y += regCoefs[21] * x2[3] * x2[6];
    x2[21] = x2[3] * x2[6];
    y += regCoefs[22] * x2[4] * x2[4];
    x2[22] = x2[4] * x2[4];
    y += regCoefs[23] * x2[4] * x2[5];
    x2[23] = x2[4] * x2[5];
    y += regCoefs[24] * x2[4] * x2[6];
    x2[24] = x2[4] * x2[6];
    y += regCoefs[25] * x2[5] * x2[5];
    x2[25] = x2[5] * x2[5];
    y += regCoefs[26] * x2[5] * x2[6];
    x2[26] = x2[5] * x2[6];
    y += regCoefs[27] * x2[6] * x2[6];
    x2[27] = x2[6] * x2[6];
    Y[ii] = y * 1.000000e+00 + 0.000000e+00;
    std = 0.0;
    for (jj = 0; jj < N; jj++) {
      dtmp = 0.0;
      for (kk = 0; kk < N; kk++)
        dtmp += invCovMat[jj][kk] * x2[kk];
      std += dtmp * x2[jj];
    }
    std = sqrt(std);
    S[ii] = std;
  }
  free(x2);
  return 0;
}

/* ==============================================*/
