% This file stores CV error for each point
% Column 1: error (true - predicted)
% Column 2: true
% Column 3: predicted
% Column 4: standard deviations
% Set morePlots=1 for normalized residual error plot
% Set errBoundOn=1 for error bars in CV plot
errBoundOn = 0;
morePlots  = 0;
A = [
  5.883923e-04 1.030000e-01 1.035884e-01 4.890976e-03
  -5.604042e-03 8.380000e-02 7.819596e-02 5.816131e-03
  -1.085252e-02 6.660000e-02 5.574748e-02 2.621006e-03
  -6.098791e-04 4.660000e-02 4.599012e-02 2.671528e-03
  -1.144334e-02 5.660000e-02 4.515666e-02 4.867891e-03
  1.808348e-03 6.380000e-02 6.560835e-02 4.042132e-03
  1.843228e-02 7.940000e-02 9.783228e-02 6.667359e-03
  6.530161e-03 6.700000e-02 7.353016e-02 1.741823e-03
  6.608778e-04 4.060000e-02 4.126088e-02 3.509039e-03
  6.760484e-03 7.420000e-02 8.096048e-02 3.136493e-03
  1.321852e-03 4.660000e-02 4.792185e-02 5.113368e-03
  4.326754e-03 4.460000e-02 4.892675e-02 3.741481e-03
  3.813260e-03 6.700000e-02 7.081326e-02 4.875993e-03
  3.282911e-03 5.940000e-02 6.268291e-02 3.328213e-03
  6.187710e-04 7.020000e-02 7.081877e-02 1.915234e-03
  3.437984e-03 4.540000e-02 4.883798e-02 6.305585e-03
  -7.045091e-03 7.260000e-02 6.555491e-02 3.582795e-03
  -6.254786e-03 5.580000e-02 4.954521e-02 4.772713e-03
  6.134725e-04 6.780000e-02 6.841347e-02 2.200417e-03
  4.208482e-03 7.940000e-02 8.360848e-02 4.025112e-03
  -3.781725e-03 5.060000e-02 4.681828e-02 2.118748e-03
  -6.297179e-03 8.860000e-02 8.230282e-02 6.549719e-03
  -5.560540e-03 8.300000e-02 7.743946e-02 2.846894e-03
  6.902899e-03 4.700000e-02 5.390290e-02 2.624223e-03
  -3.670339e-04 7.580000e-02 7.543297e-02 3.781874e-03
  -3.110752e-03 8.460000e-02 8.148925e-02 1.644336e-03
  1.223791e-03 6.460000e-02 6.582379e-02 3.346882e-03
  1.316759e-03 3.780000e-02 3.911676e-02 4.009638e-03
  -4.952940e-03 6.340000e-02 5.844706e-02 3.835406e-03
  -1.116602e-02 6.180000e-02 5.063398e-02 2.603874e-03
  -2.079820e-03 8.860000e-02 8.652018e-02 3.388792e-03
  8.895827e-03 6.580000e-02 7.469583e-02 6.294645e-03
  1.141379e-03 6.780000e-02 6.894138e-02 4.942055e-03
  -2.924161e-03 7.380000e-02 7.087584e-02 3.578812e-03
  2.702851e-03 8.020000e-02 8.290285e-02 2.639472e-03
  -2.874880e-03 8.220000e-02 7.932512e-02 2.965024e-03
  -7.111339e-03 8.420000e-02 7.708866e-02 4.185330e-03
  1.788452e-04 7.940000e-02 7.957885e-02 3.131059e-03
  -3.705359e-03 3.860000e-02 3.489464e-02 2.231127e-03
  -5.019241e-03 7.300000e-02 6.798076e-02 4.395780e-03
  -8.807884e-03 8.740000e-02 7.859212e-02 2.326625e-03
  -8.205193e-03 1.222000e-01 1.139948e-01 4.223383e-03
  -1.151698e-02 8.580000e-02 7.428302e-02 3.837856e-03
  1.119127e-02 6.460000e-02 7.579127e-02 4.643457e-03
  -2.380224e-04 4.340000e-02 4.316198e-02 4.780659e-03
  -3.377903e-03 5.780000e-02 5.442210e-02 1.944191e-03
  -3.796678e-03 6.740000e-02 6.360332e-02 6.988720e-03
  -1.536265e-03 5.340000e-02 5.186374e-02 3.733620e-03
  1.330460e-02 9.020000e-02 1.035046e-01 2.847067e-03
  1.098512e-02 5.980000e-02 7.078512e-02 4.358506e-03
  2.609871e-03 1.190000e-01 1.216099e-01 7.218784e-03
  -8.662207e-03 1.046000e-01 9.593779e-02 3.992401e-03
  -2.788427e-02 1.054000e-01 7.751573e-02 5.114825e-03
  -4.247942e-03 6.980000e-02 6.555206e-02 2.183378e-03
  4.856708e-03 8.340000e-02 8.825671e-02 1.986638e-03
  -9.745632e-03 6.580000e-02 5.605437e-02 4.823170e-03
  -5.978981e-03 6.420000e-02 5.822102e-02 4.498433e-03
  -8.507987e-04 6.060000e-02 5.974920e-02 1.959772e-03
  -1.265308e-03 4.660000e-02 4.533469e-02 2.815679e-03
  8.504079e-03 3.900000e-02 4.750408e-02 6.269835e-03
  -2.242098e-03 7.660000e-02 7.435790e-02 1.504111e-03
  -3.752879e-03 9.980000e-02 9.604712e-02 4.855843e-03
  1.437008e-02 4.620000e-02 6.057008e-02 4.064066e-03
  2.763116e-04 6.620000e-02 6.647631e-02 5.860477e-03
  -1.220574e-03 4.660000e-02 4.537943e-02 3.207405e-03
  4.890213e-03 6.700000e-02 7.189021e-02 4.116029e-03
  1.145083e-02 6.020000e-02 7.165083e-02 3.931706e-03
  1.285791e-04 7.420000e-02 7.432858e-02 2.224384e-03
  2.274751e-03 9.380000e-02 9.607475e-02 4.152772e-03
  3.970984e-03 5.260000e-02 5.657098e-02 4.461916e-03
  -5.272694e-03 9.140000e-02 8.612731e-02 3.503032e-03
  1.514528e-03 3.940000e-02 4.091453e-02 3.269748e-03
  7.150945e-03 5.020000e-02 5.735094e-02 2.837833e-03
  1.741852e-03 9.740000e-02 9.914185e-02 4.500127e-03
  -5.243400e-03 8.860000e-02 8.335660e-02 2.217635e-03
  -6.228563e-03 4.660000e-02 4.037144e-02 3.903206e-03
  -1.510229e-03 1.022000e-01 1.006898e-01 3.408148e-03
  4.442245e-03 7.300000e-02 7.744225e-02 2.497340e-03
  7.715832e-03 4.220000e-02 4.991583e-02 7.877814e-03
  -3.563541e-03 7.700000e-02 7.343646e-02 2.171519e-03
  3.888937e-03 6.500000e-02 6.888894e-02 2.157244e-03
  -1.310653e-03 5.380000e-02 5.248935e-02 3.976494e-03
  3.998901e-03 5.340000e-02 5.739890e-02 4.538772e-03
  2.768162e-03 1.042000e-01 1.069682e-01 3.485986e-03
  7.146187e-03 9.180000e-02 9.894619e-02 1.908476e-03
  2.266856e-03 9.220000e-02 9.446686e-02 2.937043e-03
  -1.792173e-04 5.940000e-02 5.922078e-02 3.107590e-03
  -4.894340e-03 9.380000e-02 8.890566e-02 1.831201e-03
  4.798609e-03 8.220000e-02 8.699861e-02 2.018558e-03
  -2.679806e-03 8.700000e-02 8.432019e-02 3.944323e-03
  -5.499969e-03 5.620000e-02 5.070003e-02 2.677281e-03
  -5.900537e-03 5.940000e-02 5.349946e-02 4.593869e-03
  6.729602e-04 6.620000e-02 6.687296e-02 2.019617e-03
  -5.006144e-03 7.660000e-02 7.159386e-02 2.185393e-03
  -3.588389e-03 5.300000e-02 4.941161e-02 3.630985e-03
  -1.196123e-02 9.100000e-02 7.903877e-02 4.091141e-03
  -1.592610e-03 5.940000e-02 5.780739e-02 4.191346e-03
  3.587106e-03 5.060000e-02 5.418711e-02 2.344980e-03
  3.661520e-04 8.140000e-02 8.176615e-02 1.353204e-03
  1.440881e-02 7.100000e-02 8.540881e-02 2.566250e-03
  -9.106669e-03 9.460000e-02 8.549333e-02 3.953145e-03
  5.567297e-03 3.460000e-02 4.016730e-02 3.974410e-03
  4.476794e-03 7.780000e-02 8.227679e-02 4.750436e-03
  -6.198830e-03 4.380000e-02 3.760117e-02 3.606079e-03
  1.639292e-03 6.340000e-02 6.503929e-02 1.481826e-03
  -5.119844e-03 7.700000e-02 7.188016e-02 1.751766e-03
  1.129055e-02 3.540000e-02 4.669055e-02 5.074267e-03
  5.222651e-03 5.420000e-02 5.942265e-02 4.420783e-03
  1.463138e-03 5.700000e-02 5.846314e-02 3.516713e-03
  9.792045e-03 7.140000e-02 8.119205e-02 3.735819e-03
  1.935492e-03 7.300000e-02 7.493549e-02 3.637485e-03
  3.006746e-03 8.020000e-02 8.320675e-02 1.453077e-03
  5.553169e-03 6.020000e-02 6.575317e-02 3.537934e-03
  -6.900681e-03 7.500000e-02 6.809932e-02 4.425216e-03
  -1.723239e-03 6.620000e-02 6.447676e-02 4.577053e-03
  -2.941291e-04 4.220000e-02 4.190587e-02 7.392310e-03
  7.663337e-03 3.700000e-02 4.466334e-02 3.664648e-03
  -1.130038e-02 1.050000e-01 9.369962e-02 2.917332e-03
  -5.556709e-03 7.820000e-02 7.264329e-02 3.855534e-03
  2.409369e-03 1.014000e-01 1.038094e-01 2.168605e-03
];
hold off
figure(1)
subplot(1,2,1)
[nk, xk] = hist(A(:,1), 10);
bar(xk,nk/sum(nk))
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('CV Error','FontWeight','bold','FontSize',12)
xlabel('Error (unnormalized)','FontWeight','bold','FontSize',12)
ylabel('Probabilities','FontWeight','bold','FontSize',12)
disp(['Error Mean  = ' num2str(mean(A(:,1)))])
disp(['Error stdev = ' num2str(std(A(:,1)))])
subplot(1,2,2)
xmax = max(A(:,2));
xmin = min(A(:,2));
if (xmax == xmin)
   xmin = 0.9 * xmin;
   xmax = 1.1 * xmax;
end;
if (xmax == xmin)
   xmin = -0.1;
   xmax = 0.1;
end;
if errBoundOn == 1
ymax = max(A(:,3)+A(:,4));
ymin = min(A(:,3)-A(:,4));
else
ymax = max(A(:,3));
ymin = min(A(:,3));
end;
if (ymax == ymin)
   ymin = 0.9 * ymin;
   ymax = 1.1 * ymax;
end;
if (ymax == ymin)
   ymin = -0.1;
   ymax = 0.1;
end;
xmin = min(xmin, ymin);
xmax = max(xmax, ymax);
XX = xmin : xmax-xmin : xmax;
plot(A(:,2), A(:,3),'*','MarkerSize',12)
hold on
plot(XX, XX)
axis([xmin xmax xmin xmax])
cnt1 = 0;
cnt2 = 0;
cnt3 = 0;
cnt4 = 0;
if errBoundOn == 1
for ii = 1 : 120
  xx = [A(ii,2) A(ii,2)];
  d1 = A(ii,3)-A(ii,4);
  d2 = A(ii,3)+A(ii,4);
  yy = [d1 d2];
  if (xx(1) < d1 | xx(1) > d2)
    plot(xx, yy, 'r-', 'lineWidth', 1)
    d3 = A(ii,3)-2*A(ii,4);
    d4 = A(ii,3)+2*A(ii,4);
    if (xx(1) < d3 | xx(1) > d4)
      d5 = A(ii,3)-3*A(ii,4);
      d6 = A(ii,3)+3*A(ii,4);
      if (xx(1) > d5 & xx(1) < d6)
        cnt3 = cnt3 + 1;
      else
        d7 = A(ii,3)-4*A(ii,4);
        d8 = A(ii,3)+4*A(ii,4);
        if (xx(1) > d7 & xx(1) < d8)
          cnt4 = cnt4 + 1;
        else
          disp(['Point outside 4-sigma = ',int2str(ii)])
        end;
      end;
    else
      cnt2 = cnt2 + 1;
    end;
  else
    plot(xx, yy, 'g-', 'lineWidth', 1);
    cnt1 = cnt1 + 1;
  end;
%plot(xx(1), yy(1),'rv','markerSize',10);
%plot(xx(2), yy(2),'r^','markerSize',10);
end;
end;
cnt4 = cnt1 + cnt2 + cnt3 + cnt4;
cnt3 = cnt1 + cnt2 + cnt3;
cnt2 = cnt1 + cnt2;
disp('Total sample size = 120')
disp(['Num points inside 1 sigma = ',int2str(cnt1)])
disp(['Num points inside 2 sigma = ',int2str(cnt2)])
disp(['Num points inside 3 sigma = ',int2str(cnt3)])
disp(['Num points inside 4 sigma = ',int2str(cnt4)])
%text(0.1,0.9,'RED: prediction outside +/- 1 std dev','sc','fontSize',11,'fontweight','bold')
hold off
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Parity Plot','FontWeight','bold','FontSize',12)
xlabel('Sample Output','FontWeight','bold','FontSize',12)
ylabel('Predicted Output','FontWeight','bold','FontSize',12)
rsme_unscaled = 6.611732e-03;
rsme_scaled   = 1.011750e-01;
R2 = 8.813390e-01;
if morePlots == 1
%  For the following B matrix
% Column 1: true values
% Column 2: normalized residual
% Column 3: predicted values
% Column 4-(m+3): inputs
figure(2)
B = [
 1.030000e-01 5.712546e-03  1.035884e-01  6.360520e+00  4.267258e+00  8.992355e+00  3.954849e-01  6.398683e-01  1.369130e-01
 8.380000e-02 -6.687401e-02  7.819596e-02  7.654893e+00  4.682246e+00  1.036629e+01  4.465452e-01  6.801400e-01  2.087748e-01
 6.660000e-02 -1.629507e-01  5.574748e-02  1.918745e+01  3.770260e+00  4.718583e+00  4.684413e-01  6.744377e-01  1.231369e-01
 4.660000e-02 -1.308753e-02  4.599012e-02  6.063233e+00  3.916166e+00  1.925014e+01  4.436765e-01  7.644663e-01  5.720672e-02
 5.660000e-02 -2.021791e-01  4.515666e-02  1.489744e+01  3.345950e+00  1.373961e+01  4.646970e-01  8.744606e-01  1.646466e-01
 6.380000e-02 2.834402e-02  6.560835e-02  1.038615e+01  2.243132e+00  1.817720e+01  3.969778e-01  5.270366e-01  1.789155e-01
 7.940000e-02 2.321445e-01  9.783228e-02  5.354393e+00  3.573638e+00  6.939636e+00  4.997498e-01  8.916727e-01  1.484867e-01
 6.700000e-02 9.746509e-02  7.353016e-02  1.801631e+01  3.374336e+00  5.465025e+00  3.734620e-01  5.406043e-01  1.567887e-01
 4.060000e-02 1.627778e-02  4.126088e-02  1.524148e+01  2.596807e+00  1.516966e+01  4.156258e-01  6.874304e-01  1.119057e-01
 7.420000e-02 9.111165e-02  8.096048e-02  1.071613e+01  3.062482e+00  6.490147e+00  3.601017e-01  6.549956e-01  8.397606e-02
 4.660000e-02 2.836592e-02  4.792185e-02  5.883871e+00  3.111340e+00  9.490973e+00  4.119719e-01  8.245167e-01  1.681505e-01
 4.460000e-02 9.701242e-02  4.892675e-02  8.713139e+00  2.328679e+00  8.179281e+00  4.975175e-01  6.420814e-01  1.864963e-01
 6.700000e-02 5.691432e-02  7.081326e-02  7.214231e+00  5.000000e+00  7.125972e+00  3.544874e-01  7.766473e-01  1.479898e-01
 5.940000e-02 5.526787e-02  6.268291e-02  2.730276e+00  2.539163e+00  1.972986e+01  3.861010e-01  5.606695e-01  1.502383e-01
 7.020000e-02 8.814402e-03  7.081877e-02  4.612862e+00  3.656385e+00  1.936074e+01  3.627227e-01  9.895369e-01  1.728574e-01
 4.540000e-02 7.572653e-02  4.883798e-02  8.833830e+00  4.427096e+00  1.612230e+01  4.793981e-01  9.074125e-01  1.161642e-01
 7.260000e-02 -9.703982e-02  6.555491e-02  1.392801e+01  4.624708e+00  1.532798e+01  3.587896e-01  8.823699e-01  2.442245e-01
 5.580000e-02 -1.120929e-01  4.954521e-02  8.265782e+00  4.150976e+00  4.286263e+00  4.135844e-01  6.957872e-01  9.308373e-02
 6.780000e-02 9.048267e-03  6.841347e-02  2.432125e+00  4.553522e+00  1.334862e+01  4.293769e-01  7.284263e-01  2.387406e-01
 7.940000e-02 5.300355e-02  8.360848e-02  4.149747e+00  4.510979e+00  1.455565e+01  4.374068e-01  5.140554e-01  1.239846e-01
 5.060000e-02 -7.473764e-02  4.681828e-02  1.360911e+00  2.899271e+00  1.278408e+01  3.647042e-01  6.300902e-01  2.337662e-01
 8.860000e-02 -7.107425e-02  8.230282e-02  5.627139e-01  4.171317e+00  1.509063e+01  4.499202e-01  9.668164e-01  1.437247e-01
 8.300000e-02 -6.699445e-02  7.743946e-02  1.860037e+01  4.321546e+00  4.180616e+00  4.443891e-01  7.511117e-01  1.519671e-01
 4.700000e-02 1.468702e-01  5.390290e-02  1.333593e+01  2.398630e+00  1.710816e+01  3.809915e-01  9.651259e-01  6.272629e-02
 7.580000e-02 -4.842136e-03  7.543297e-02  5.020024e+00  4.095250e+00  8.637809e+00  4.914617e-01  7.452070e-01  2.237367e-01
 8.460000e-02 -3.677012e-02  8.148925e-02  1.400174e+01  4.521223e+00  5.617950e+00  4.573512e-01  7.979357e-01  5.250138e-02
 6.460000e-02 1.894414e-02  6.582379e-02  1.104686e+01  2.823902e+00  1.347543e+01  4.612427e-01  5.500030e-01  6.512819e-02
 3.780000e-02 3.483489e-02  3.911676e-02  1.684116e+01  3.978001e+00  1.684177e+01  3.848809e-01  7.728934e-01  2.234465e-01
 6.340000e-02 -7.812208e-02  5.844706e-02  9.523736e+00  3.029514e+00  2.000798e+01  4.375960e-01  7.558069e-01  1.931156e-01
 6.180000e-02 -1.806800e-01  5.063398e-02  1.427673e+01  2.024662e+00  7.665203e+00  3.760715e-01  8.497790e-01  1.899822e-01
 8.860000e-02 -2.347426e-02  8.652018e-02  1.655798e+01  4.785476e+00  1.293422e+01  4.392551e-01  9.807651e-01  9.527274e-02
 6.580000e-02 1.351949e-01  7.469583e-02  9.356449e+00  4.811469e+00  3.246063e+00  4.715999e-01  6.247992e-01  1.063113e-01
 6.780000e-02 1.683450e-02  6.894138e-02  8.538244e+00  4.291747e+00  1.365276e+01  3.869090e-01  7.891491e-01  1.808398e-01
 7.380000e-02 -3.962278e-02  7.087584e-02  8.145092e-01  3.493504e+00  7.919847e+00  4.631262e-01  5.446289e-01  1.147207e-01
 8.020000e-02 3.370139e-02  8.290285e-02  1.623508e+01  3.839933e+00  1.562937e+01  4.111592e-01  6.255842e-01  1.623373e-01
 8.220000e-02 -3.497421e-02  7.932512e-02  7.247088e+00  3.827283e+00  1.310279e+01  4.887522e-01  8.127229e-01  1.763440e-01
 8.420000e-02 -8.445771e-02  7.708866e-02  1.089210e+01  2.373196e+00  4.876272e+00  4.014482e-01  8.083647e-01  2.183169e-01
 7.940000e-02 2.252458e-03  7.957885e-02  4.375358e+00  2.964832e+00  4.388325e+00  4.775953e-01  7.074107e-01  2.427319e-01
 3.860000e-02 -9.599376e-02  3.489464e-02  1.715863e+01  4.397530e+00  1.387078e+01  3.558229e-01  6.053228e-01  1.034471e-01
 7.300000e-02 -6.875672e-02  6.798076e-02  1.758387e+01  2.214564e+00  1.317494e+01  3.942506e-01  7.467447e-01  8.812944e-02
 8.740000e-02 -1.007767e-01  7.859212e-02  1.673252e+01  3.225997e+00  3.856399e+00  4.822531e-01  9.585731e-01  1.954065e-01
 1.222000e-01 -6.714560e-02  1.139948e-01  1.944200e+01  2.731602e+00  7.307992e+00  4.033235e-01  5.629925e-01  9.821791e-02
 8.580000e-02 -1.342305e-01  7.428302e-02  4.877944e-01  3.293596e+00  7.583253e+00  3.817584e-01  7.365395e-01  2.122719e-01
 6.460000e-02 1.732394e-01  7.579127e-02  1.233427e+01  4.018557e+00  7.407579e+00  4.757086e-01  9.487049e-01  8.574980e-02
 4.340000e-02 -5.484387e-03  4.316198e-02  9.653795e+00  2.000073e+00  1.213354e+01  4.286740e-01  7.864619e-01  7.036886e-02
 5.780000e-02 -5.844122e-02  5.442210e-02  2.900213e+00  3.379367e+00  6.287553e+00  4.412920e-01  8.078926e-01  1.338839e-01
 6.740000e-02 -5.633053e-02  6.360332e-02  1.278794e+01  4.866363e+00  1.898156e+01  4.198649e-01  7.375939e-01  1.202366e-01
 5.340000e-02 -2.876900e-02  5.186374e-02  1.352786e+01  4.449471e+00  6.172012e+00  4.047324e-01  6.595669e-01  2.306028e-01
 9.020000e-02 1.475011e-01  1.035046e-01  1.704949e+01  2.181904e+00  6.917370e+00  4.406202e-01  6.141256e-01  2.457268e-01
 5.980000e-02 1.836977e-01  7.078512e-02  5.184036e+00  3.022952e+00  1.435505e+01  3.901835e-01  7.168183e-01  5.838507e-02
 1.190000e-01 2.193169e-02  1.216099e-01  1.734637e+01  2.875559e+00  1.955579e+01  4.594227e-01  9.214523e-01  1.257256e-01
 1.046000e-01 -8.281268e-02  9.593779e-02  1.876746e+01  2.997223e+00  1.116884e+01  3.921866e-01  9.932150e-01  1.836163e-01
 1.054000e-01 -2.645566e-01  7.751573e-02  7.425716e+00  2.622873e+00  4.045390e+00  3.794255e-01  6.041635e-01  2.018002e-01
 6.980000e-02 -6.085877e-02  6.555206e-02  3.965480e+00  2.071919e+00  1.741696e+01  4.529704e-01  9.370805e-01  2.268217e-01
 8.340000e-02 5.823391e-02  8.825671e-02  3.859943e+00  2.816860e+00  8.728581e+00  3.682755e-01  7.608340e-01  1.282974e-01
 6.580000e-02 -1.481099e-01  5.605437e-02  9.868685e+00  3.261462e+00  1.162786e+01  4.202877e-01  6.190753e-01  2.080482e-01
 6.420000e-02 -9.313054e-02  5.822102e-02  7.923091e+00  3.308081e+00  1.745396e+01  4.331561e-01  5.793499e-01  9.483209e-02
 6.060000e-02 -1.403958e-02  5.974920e-02  1.185677e+01  4.700185e+00  8.238988e+00  3.831441e-01  5.230908e-01  6.744536e-02
 4.660000e-02 -2.715254e-02  4.533469e-02  9.144555e+00  3.807402e+00  9.879487e+00  3.516062e-01  5.051878e-01  2.277923e-01
 3.900000e-02 2.180533e-01  4.750408e-02  1.324561e+01  3.525242e+00  1.488275e+01  4.462369e-01  6.521404e-01  1.994951e-01
 7.660000e-02 -2.927021e-02  7.435790e-02  1.843070e+01  2.302720e+00  1.904373e+01  3.621235e-01  6.756324e-01  2.113410e-01
 9.980000e-02 -3.760400e-02  9.604712e-02  6.521337e+00  3.593262e+00  1.403178e+01  4.086824e-01  5.460409e-01  2.498139e-01
 4.620000e-02 3.110408e-01  6.057008e-02  1.289276e+01  3.439726e+00  9.961372e+00  4.834493e-01  6.965145e-01  1.389920e-01
 6.620000e-02 4.173891e-03  6.647631e-02  1.927382e+00  4.594383e+00  4.961318e+00  4.863824e-01  5.858385e-01  1.666394e-01
 4.660000e-02 -2.619257e-02  4.537943e-02  3.034285e+00  4.347129e+00  1.841970e+01  4.735532e-01  6.910582e-01  1.829681e-01
 6.700000e-02 7.298826e-02  7.189021e-02  1.307465e+01  3.142744e+00  2.963670e+00  3.880589e-01  8.372577e-01  1.197228e-01
 6.020000e-02 1.902132e-01  7.165083e-02  1.590304e+01  3.078234e+00  1.615619e+01  4.931493e-01  5.191564e-01  2.187276e-01
 7.420000e-02 1.732873e-03  7.432858e-02  3.201464e+00  3.244103e+00  1.254599e+01  4.057609e-01  9.564591e-01  1.068942e-01
 9.380000e-02 2.425108e-02  9.607475e-02  3.531403e+00  3.156699e+00  1.546732e+01  4.800346e-01  6.112367e-01  7.390972e-02
 5.260000e-02 7.549400e-02  5.657098e-02  1.466794e+01  3.943970e+00  1.178495e+01  3.891101e-01  5.976465e-01  1.297888e-01
 9.140000e-02 -5.768812e-02  8.612731e-02  1.282213e+00  3.708020e+00  1.096905e+01  4.581567e-01  7.803198e-01  1.984167e-01
 3.940000e-02 3.843979e-02  4.091453e-02  1.594906e+01  2.504325e+00  9.626213e+00  3.535958e-01  9.395557e-01  1.417477e-01
 5.020000e-02 1.424491e-01  5.735094e-02  1.546244e+01  4.565814e+00  1.993595e+01  4.071811e-01  8.184389e-01  7.518882e-02
 9.740000e-02 1.788349e-02  9.914185e-02  1.777329e+01  4.196866e+00  1.086532e+01  4.966361e-01  5.748737e-01  6.076472e-02
 8.860000e-02 -5.918059e-02  8.335660e-02  1.155391e+01  4.255107e+00  1.968503e+01  4.659402e-01  5.946109e-01  2.367744e-01
 4.660000e-02 -1.336602e-01  4.037144e-02  4.737219e+00  4.880184e+00  1.151863e+01  4.664302e-01  8.506753e-01  6.966896e-02
 1.022000e-01 -1.477719e-02  1.006898e-01  1.003092e+01  3.607333e+00  1.588287e+01  3.651432e-01  7.026261e-01  5.036309e-02
 7.300000e-02 6.085268e-02  7.744225e-02  1.436017e+01  3.699969e+00  1.853573e+01  4.885226e-01  6.356347e-01  8.883567e-02
 4.220000e-02 1.828396e-01  4.991583e-02  1.451648e+01  2.572546e+00  1.046215e+01  4.518285e-01  7.137680e-01  1.702133e-01
 7.700000e-02 -4.627976e-02  7.343646e-02  4.928576e+00  2.102024e+00  1.126664e+01  3.566144e-01  5.903054e-01  1.170085e-01
 6.500000e-02 5.982980e-02  6.888894e-02  1.057073e+01  4.974598e+00  1.414979e+01  4.951597e-01  9.425007e-01  1.566736e-01
 5.380000e-02 -2.436158e-02  5.248935e-02  1.827342e+00  4.365668e+00  1.053479e+01  3.737904e-01  8.388543e-01  9.044507e-02
 5.340000e-02 7.488579e-02  5.739890e-02  9.942541e-01  4.943812e+00  1.717704e+01  4.009146e-01  6.492246e-01  8.239347e-02
 1.042000e-01 2.656586e-02  1.069682e-01  2.000022e+01  3.634439e+00  8.862778e+00  4.318112e-01  8.266161e-01  2.285866e-01
 9.180000e-02 7.784518e-02  9.894619e-02  2.228389e+00  2.346586e+00  9.794827e+00  4.229779e-01  6.680150e-01  5.328048e-02
 9.220000e-02 2.458629e-02  9.446686e-02  1.056395e+00  2.143543e+00  5.754461e+00  4.091449e-01  9.096209e-01  1.602690e-01
 5.940000e-02 -3.017127e-03  5.922078e-02  1.021160e+01  3.884908e+00  5.890358e+00  4.621091e-01  8.593625e-01  2.485193e-01
 9.380000e-02 -5.217846e-02  8.890566e-02  5.659122e+00  2.464802e+00  5.134082e+00  4.502520e-01  5.093284e-01  8.162435e-02
 8.220000e-02 5.837724e-02  8.699861e-02  1.806747e+01  4.724023e+00  1.761079e+01  4.838253e-01  8.417609e-01  2.031951e-01
 8.700000e-02 -3.080237e-02  8.432019e-02  6.780781e+00  4.125001e+00  1.804727e+01  3.772579e-01  8.909770e-01  1.105126e-01
 5.620000e-02 -9.786421e-02  5.070003e-02  1.213926e+01  3.180671e+00  1.779895e+01  3.501584e-01  8.028482e-01  1.540703e-01
 5.940000e-02 -9.933564e-02  5.349946e-02  1.224341e+01  2.774421e+00  1.074355e+01  4.138073e-01  9.013602e-01  2.383671e-01
 6.620000e-02 1.016556e-02  6.687296e-02  1.827488e+01  2.931104e+00  8.432656e+00  4.476189e-01  8.851706e-01  5.609940e-02
 7.660000e-02 -6.535436e-02  7.159386e-02  3.472765e+00  3.993435e+00  6.625676e+00  4.172404e-01  5.299800e-01  1.876380e-01
 5.300000e-02 -6.770545e-02  4.941161e-02  1.538317e+01  4.967036e+00  9.236495e+00  4.538944e-01  5.546763e-01  2.147091e-01
 9.100000e-02 -1.314421e-01  7.903877e-02  1.893586e+01  4.060672e+00  1.792166e+01  4.265286e-01  5.011376e-01  1.400762e-01
 5.940000e-02 -2.681161e-02  5.780739e-02  3.718437e+00  4.828484e+00  3.473757e+00  3.934784e-01  9.183320e-01  2.214099e-01
 5.060000e-02 7.089141e-02  5.418711e-02  6.734401e+00  2.273516e+00  3.743383e+00  4.351503e-01  8.777708e-01  1.024510e-01
 8.140000e-02 4.498182e-03  8.176615e-02  9.794748e+00  4.641685e+00  6.736549e+00  4.238401e-01  9.998600e-01  1.303392e-01
 7.100000e-02 2.029410e-01  8.540881e-02  1.747727e+01  4.481332e+00  7.951660e+00  4.222781e-01  8.997611e-01  1.781195e-01
 9.460000e-02 -9.626500e-02  8.549333e-02  2.583231e+00  3.864582e+00  4.577888e+00  3.584774e-01  9.313073e-01  6.487706e-02
 3.460000e-02 1.609045e-01  4.016730e-02  8.121325e+00  3.418264e+00  1.868380e+01  3.989797e-01  9.507425e-01  2.414595e-01
 7.780000e-02 5.754234e-02  8.227679e-02  2.085236e+00  2.476556e+00  1.578250e+01  4.256422e-01  8.657185e-01  2.046916e-01
 4.380000e-02 -1.415258e-01  3.760117e-02  1.927334e+01  2.433727e+00  1.440636e+01  4.749840e-01  7.921787e-01  2.327839e-01
 6.340000e-02 2.585634e-02  6.503929e-02  8.891977e+00  2.695026e+00  1.468994e+01  3.724817e-01  8.557428e-01  1.355370e-01
 7.700000e-02 -6.649147e-02  7.188016e-02  1.144010e+01  3.753905e+00  1.009494e+01  3.983531e-01  8.699497e-01  1.003032e-01
 3.540000e-02 3.189421e-01  4.669055e-02  1.963853e+01  4.895502e+00  1.208391e+01  3.779113e-01  7.109724e-01  1.698360e-01
 5.420000e-02 9.635888e-02  5.942265e-02  1.260860e+01  2.867232e+00  3.182943e+00  4.305993e-01  5.759831e-01  1.740402e-01
 5.700000e-02 2.566908e-02  5.846314e-02  6.224976e+00  2.698589e+00  1.194487e+01  4.702342e-01  9.767940e-01  2.167530e-01
 7.140000e-02 1.371435e-01  8.119205e-02  1.564814e+01  2.556910e+00  6.035244e+00  4.903560e-01  7.705285e-01  1.096929e-01
 7.300000e-02 2.651358e-02  7.493549e-02  1.500292e+01  4.231318e+00  5.268857e+00  3.671571e-01  9.720767e-01  2.058680e-01
 8.020000e-02 3.749060e-02  8.320675e-02  1.374508e+01  2.061279e+00  1.248511e+01  4.774255e-01  5.350858e-01  1.464016e-01
 6.020000e-02 9.224533e-02  6.575317e-02  1.124030e+01  4.037861e+00  1.231387e+01  4.340327e-01  9.264412e-01  1.916579e-01
 7.500000e-02 -9.200908e-02  6.809932e-02  6.922219e+00  2.760941e+00  1.690677e+01  4.561563e-01  6.665426e-01  1.593854e-01
 6.620000e-02 -2.603080e-02  6.447676e-02  1.571821e+00  2.662007e+00  1.885345e+01  4.946442e-01  8.302453e-01  9.835519e-02
 4.220000e-02 -6.969885e-03  4.190587e-02  1.177288e+01  2.119800e+00  1.668819e+01  4.697608e-01  7.315979e-01  1.324977e-01
 3.700000e-02 2.071172e-01  4.466334e-02  1.978219e+01  3.462019e+00  1.632905e+01  4.181628e-01  9.166657e-01  7.858508e-02
 1.050000e-01 -1.076226e-01  9.369962e-02  1.639795e+01  3.536722e+00  3.585115e+00  3.693931e-01  7.233545e-01  7.238996e-02
 7.820000e-02 -7.105766e-02  7.264329e-02  5.479054e+00  4.747408e+00  1.644898e+01  3.705323e-01  5.670398e-01  1.936403e-01
 1.014000e-01 2.376104e-02  1.038094e-01  7.885254e+00  2.229434e+00  9.211434e+00  4.850493e-01  9.861683e-01  7.672922e-02
];
AA = B(:,1);
BB = B(:,2);
CC = B(:,3);
subplot(1,2,1),plot(AA, BB, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Normalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Normalized Error','FontWeight','bold','FontSize',12)
subplot(1,2,2),plot(AA,BB.*AA, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Unnormalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Error','FontWeight','bold','FontSize',12)
figure(3)
for ii = 1 : 6
  XX = B(:,3+ii);
  plot(XX, BB.*AA, '*','markerSize',12);
  disp(['Error vs Input ' int2str(ii)])
  disp('Press enter to continue')
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
  xlabel(['Input ' int2str(ii)])
ylabel('Error','FontWeight','bold','FontSize',12)
  pause
end;
end;
print -dpng R2_GPM10_120F_RSFA_CV_err
