% This file contains total order Sobol' indices
% with error bars coming from bootstrapping.
% to select the most important ones to display,
% set sortFlag = 1 and set nn to be the number
% of inputs to display.
sortFlag = 1;
nn = 6;
Means = [
  9.6472463413734780e-03
  6.1485792124578746e-03
  8.0693547559271966e-02
  5.7352821966210346e-02
  1.7345403191746353e-01
  8.1644443419798363e-01
];
Stds = [
  3.0970966534595817e-03
  2.5093764647319819e-03
  1.1085410630119624e-02
  8.2362650062641641e-03
  1.5043263088679606e-02
  1.3715187366348245e-02
];
%  Str = {'t1:P_0','t2:beta','t3:StatWeight','t4:ep_gstar','t5:VelfacCoeff','x1:InitConc'};
    Str = {'\theta_1:P_0','\theta_2:\beta','\theta_3:StatWeight','\theta_4:ep_g^*','\theta_5:VelfacCoeff','x_1:InitConc'};
hold off
if (sortFlag == 1)
  [Means, I2] = sort(Means,'descend');
  Stds = Stds(I2);
  I2 = I2(1:nn);
  Means = Means(1:nn);
  Stds = Stds(1:nn);
  Str  = Str(I2);
end
ymin = min(Means-Stds);
if ymin < 0 
    ymin = 0;
end;
ymax = max(Means+Stds);
h2 = 0.05 * (ymax - ymin);
bar(Means,0.8);
for ii = 1:nn
   if (ii == 1)
hold on
   end;
   XX = [ii ii];
   YY = [Means(ii)-Stds(ii) Means(ii)+Stds(ii)];
   if YY(1) < 0 
      YY(1) = 0;
   end;
   plot(XX,YY,'-ko','LineWidth',3.0,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',12)
end;
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
axis([0  nn+1 ymin ymax])
set(gca,'XTickLabel',[]);
th=text(1:nn, repmat(ymin-0.05*(ymax-ymin),nn,1),Str,'HorizontalAlignment','center');
set(th,'rotation',30)
set(th, 'fontsize', 10)
%set(th, 'fontweight', 'bold')
title('Total Order Sobol Indices (with bootstrap)','FontWeight','bold','FontSize',12)
ylabel('Total Order Sobol Index (Normalized)','FontWeight','bold','FontSize',12)
hold off
print -dpdf R2_rssoboltsib