/* ***********************************************/ 
/* GP interpolator from PSUADE.                  */ 
/* To estimate prediction uncertainty uncomment, */ 
/* dgetrs and the corresponding code segment.    */ 
/* ==============================================*/ 
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
/*void dgetrs_(char*,int*,int*,double*,int*,int*,
               double*,int*,int*);*/
int initialize();
int finalize();
int interpolate(int,double*,double*,double*);
/*AIKE added int main to main */
/* main(int argc, char **argv) */
int main(int argc, char **argv)
{
  int    ii, iOne=1, nInps;  /*AIKE 3 replaced i with ii */
  double X[6], Y, Std, finalY;  /*AIKE 4 added finalY declaration */
 /*AIKE Add experimental dataset */
  double Exp[11][4] = {
       {1,  0.25, 0.088980934,  0.001},
       {2,  0.23, 0.088014071,  0.001},
       {3,  0.21, 0.0862336,    0.001},
       {4,  0.19, 0.08354796,   0.001},
       {5,  0.17, 0.079860606,  0.001},
       {6,  0.15, 0.075069909,  0.001},
       {7,  0.13, 0.069069065,  0.001},
       {8,  0.11, 0.061746,     0.001},
       {9,  0.09, 0.052983279,  0.001},
       {10, 0.07, 0.042658011,  0.001},          
       {11, 0.05, 0.03064176,   0.001}
      };
  FILE   *fIn=NULL, *fOut=NULL;
  if (argc < 2) 
  {
    printf("ERROR: not enough argument.\n");
    exit(1);
  }
  fIn = fopen(argv[1], "r");
  if (fIn == NULL)
  {
    printf("ERROR: cannot open input file.\n");
    exit(1);
  }
  fscanf(fIn, "%d", &nInps);
  if (nInps != 5) /*AIKE 6 changed from 6 to 5 */
  {
    printf("ERROR - wrong nInputs.\n");
    exit(1);
  }
/*AIKE 7 changed from i<6 to i<5 and also changed counter from i to ii */
  for (ii=0; ii<5; ii++) fscanf(fIn, "%lg", &X[ii]);
  fclose(fIn);
  initialize();
/*AIKE 8 Add residual calculation based on the difference of (evaluated value - experiment) */
  /* interpolate(iOne, X, &Y, &Std); */
  finalY = 0;
  for (ii = 0; ii < 5; ii++)
  {
    X[5] = Exp[ii][1];
    interpolate(iOne, X, &Y, &Std);
    finalY += (Y - Exp[ii][2]) * (Y - Exp[ii][2]);
  }

  printf("Y = %e (stdev = %e)\n", Y, Std);
  finalize();
  if (argc >= 3) 
  {
    fOut = fopen(argv[2], "w");
    if (fOut == NULL) {
      printf("ERROR: cannot open output file.\n");
      exit(1);
    }
    /*AIKE changed Y to finalY */
    /* fprintf(fOut," %e\n", Y); */
    fprintf(fOut," %e\n", finalY);
    fclose(fOut);
  }
}
/* ==========================================*/
/* Regression interpolation function         */
/* X[0], X[1],   .. X[m-1]   - first point
 * X[m], X[m+1], .. X[2*m-1] - second point
 * ... */
/* ==========================================*/
int    nInps, nSamples, nParams, *pivs=NULL;
double *XMeans=NULL,*XStds=NULL,YMean,YStd,*Thetas=NULL;
double *CMat=NULL,*CInvY=NULL, *XN=NULL; 
int interpolate(int npts,double *X,double *Y,double *YStds) 
{
  int    ss, ii, jj, kk;
  double expn, *xt, *yt, *zt, dist, ddata;
  xt = (double *) malloc(nInps*sizeof(double));
  yt = (double *) malloc(nSamples*sizeof(double));
  zt = (double *) malloc(nSamples*sizeof(double));
  for (ss = 0; ss < npts; ss++)
  {
    for (ii = 0; ii < nInps; ii++)
      xt[ii] = (X[ss*nInps+ii]-XMeans[ii])/XStds[ii];
    for (kk = 0; kk < nSamples; kk++)
    {
      expn = 0.0;
      for (ii = 0; ii < nInps; ii++)
      {
        dist = XN[kk*nInps+ii] - xt[ii];
        expn += pow(dist,2.000000e+00)/exp(2.000000e+00*Thetas[ii]);
      }
      expn *= 0.5;
      yt[kk] = exp(Thetas[nInps]) * exp(-expn);
    }
    Y[ss] = Thetas[nInps+2];
    for (kk = 0; kk < nSamples; kk++)
      Y[ss] += yt[kk] * CInvY[kk];
    Y[ss] = Y[ss] * YStd + YMean;
    YStds[ss] = 0.0;
    /* ==== if need to compute std dev. ===== 
    ddata = exp(Thetas[nInps])+exp(Thetas[nInps+1])+exp(Thetas[nInps+3]);
    LUSolve(yt, zt);
    for (kk = 0; kk < nSamples; kk++)
      ddata -= yt[kk] * zt[kk];
    if (ddata < 0) ddata = - ddata;
    YStds[ss] = sqrt(ddata);
    */
  }
  free(xt); free(yt); free(zt);
}
int initialize()
{
  int    ii, jj;
  double ddata;
  char   line[1001], word[1001];
  FILE *fp = fopen("psuade_rs.info", "r");
  if (fp == NULL)
  {
    printf("Data file (psuade_rs.info) not found.\n");
    exit(1);
  }
  while (1) 
  {
    fgets(line, 500, fp);
    sscanf(line, "%s",word);
    if (!strcmp(word, "PSUADE_BEGIN")) break;
  }
  fscanf(fp, "%d %d", &nSamples, &nInps);
  XMeans = (double *) malloc(nInps*sizeof(double));
  XStds  = (double *) malloc(nInps*sizeof(double));
  for (ii = 0; ii < nInps; ii++) 
  {
    fscanf(fp, "%lg", &ddata);
    XMeans[ii] = ddata;
    fscanf(fp, "%lg", &ddata);
    XStds[ii] = ddata;
  }
  fscanf(fp, "%lg", &YMean);
  fscanf(fp, "%lg", &YStd);
  fscanf(fp, "%d", &nParams);
  Thetas = (double *) malloc(nParams*sizeof(double));
  for (ii = 0; ii < nParams; ii++) 
  {
    fscanf(fp, "%lg", &ddata);
    Thetas[ii] = ddata;
  }
  XN = (double *) malloc(nSamples*nInps*sizeof(double));
  for (jj = 0; jj < nSamples; jj++) 
    for (ii = 0; ii < nInps; ii++) 
      fscanf(fp, "%lg", &XN[jj*nInps+ii]);
  CInvY = (double *) malloc(nSamples*sizeof(double));
  for (ii = 0; ii < nSamples; ii++)
    fscanf(fp, "%lg", &CInvY[ii]);
  CMat=(double*) malloc(nSamples*nSamples*sizeof(double));
  for (jj = 0; jj < nSamples; jj++) 
    for (ii = 0; ii < nSamples; ii++)
      fscanf(fp, "%lg ", &CMat[jj+ii*nSamples]);
  pivs = (int *) malloc(nSamples*sizeof(int));
  for (ii = 0; ii < nSamples; ii++)
    fscanf(fp, "%d", &pivs[ii]);
}
/* ==========================================*/
int finalize()
{
  if (XMeans != NULL) free(XMeans);
  if (XStds  != NULL) free(XStds);
  if (Thetas != NULL) free(Thetas);
  if (CInvY  != NULL) free(CInvY);
  if (CMat   != NULL) free(CMat);
  if (XN     != NULL) free(XN);
  if (pivs   != NULL) free(pivs);
}
