% This file stores CV error for each point
% Column 1: error (true - predicted)
% Column 2: true
% Column 3: predicted
% Column 4: standard deviations
% Set morePlots=1 for normalized residual error plot
% Set errBoundOn=1 for error bars in CV plot
errBoundOn = 1;
morePlots  = 1;
A = [
  1.019993e-03 9.540000e-02 9.641999e-02 2.657797e-03
  9.105371e-03 9.820000e-02 1.073054e-01 2.998522e-03
  2.842872e-03 6.500000e-02 6.784287e-02 1.927797e-03
  -3.263264e-03 4.740000e-02 4.413674e-02 2.708964e-03
  -1.094554e-03 5.420000e-02 5.310545e-02 6.165885e-03
  -7.268126e-04 6.420000e-02 6.347319e-02 3.398894e-03
  8.035637e-04 7.660000e-02 7.740356e-02 5.918101e-03
  1.032001e-03 6.860000e-02 6.963200e-02 3.095500e-03
  3.431687e-03 4.220000e-02 4.563169e-02 3.826580e-03
  4.194890e-03 6.980000e-02 7.399489e-02 4.710735e-03
  3.617928e-03 4.740000e-02 5.101793e-02 4.317102e-03
  1.536479e-03 4.580000e-02 4.733648e-02 2.676843e-03
  -2.320941e-03 7.820000e-02 7.587906e-02 5.129971e-03
  -1.455585e-03 6.020000e-02 5.874442e-02 3.256918e-03
  3.708128e-03 6.820000e-02 7.190813e-02 2.865877e-03
  2.632371e-03 4.060000e-02 4.323237e-02 5.059049e-03
  4.932949e-03 7.060000e-02 7.553295e-02 3.718365e-03
  2.542144e-04 7.100000e-02 7.125421e-02 4.383427e-03
  -4.371805e-03 6.980000e-02 6.542820e-02 2.007866e-03
  -1.216167e-03 8.020000e-02 7.898383e-02 5.733561e-03
  -1.507423e-03 5.420000e-02 5.269258e-02 2.755860e-03
  -6.036169e-03 9.860000e-02 9.256383e-02 3.702016e-03
  1.149429e-02 8.340000e-02 9.489429e-02 3.770274e-03
  -1.296191e-03 5.060000e-02 4.930381e-02 2.481184e-03
  -8.781850e-04 6.580000e-02 6.492182e-02 3.504918e-03
  -7.638534e-03 8.780000e-02 8.016147e-02 1.976169e-03
  -6.687836e-03 7.540000e-02 6.871216e-02 3.500871e-03
  -2.785388e-03 3.580000e-02 3.301461e-02 2.850506e-03
  -1.492408e-03 6.020000e-02 5.870759e-02 2.967152e-03
  5.771007e-03 5.780000e-02 6.357101e-02 3.418258e-03
  -4.752574e-03 8.420000e-02 7.944743e-02 3.211965e-03
  -6.899438e-04 8.020000e-02 7.951006e-02 3.772491e-03
  2.282973e-03 6.660000e-02 6.888297e-02 4.558901e-03
  2.861052e-03 7.900000e-02 8.186105e-02 3.009824e-03
  2.008835e-03 7.860000e-02 8.060883e-02 3.931142e-03
  2.897948e-03 7.860000e-02 8.149795e-02 2.839966e-03
  3.787959e-03 8.340000e-02 8.718796e-02 4.471616e-03
  1.177673e-02 7.580000e-02 8.757673e-02 3.073575e-03
  1.540329e-03 3.540000e-02 3.694033e-02 1.747843e-03
  -3.711955e-03 7.060000e-02 6.688805e-02 4.473149e-03
  4.246097e-03 8.580000e-02 9.004610e-02 3.279312e-03
  -7.138132e-03 1.058000e-01 9.866187e-02 2.832595e-03
  2.736243e-03 8.740000e-02 9.013624e-02 2.697501e-03
  3.844482e-03 7.140000e-02 7.524448e-02 3.339063e-03
  -3.545986e-04 4.780000e-02 4.744540e-02 3.641266e-03
  6.115873e-03 5.580000e-02 6.191587e-02 2.013120e-03
  6.652375e-03 7.420000e-02 8.085237e-02 3.982265e-03
  2.072549e-03 6.140000e-02 6.347255e-02 4.970515e-03
  2.366926e-03 9.340000e-02 9.576693e-02 2.881607e-03
  -3.058673e-03 8.220000e-02 7.914133e-02 5.081360e-03
  1.303469e-02 8.420000e-02 9.723469e-02 5.886318e-03
  -9.745871e-03 9.620000e-02 8.645413e-02 5.324859e-03
  -1.735626e-03 9.740000e-02 9.566437e-02 2.057819e-03
  1.683645e-03 7.060000e-02 7.228364e-02 2.630556e-03
  2.846542e-03 8.220000e-02 8.504654e-02 1.936280e-03
  -9.341245e-03 8.500000e-02 7.565876e-02 4.143586e-03
  4.001891e-03 7.140000e-02 7.540189e-02 4.513590e-03
  -2.955091e-03 6.180000e-02 5.884491e-02 2.756469e-03
  -2.392320e-03 4.340000e-02 4.100768e-02 2.366652e-03
  -3.420913e-04 3.660000e-02 3.625791e-02 3.280032e-03
  5.993295e-03 7.940000e-02 8.539330e-02 2.165440e-03
  3.651087e-03 8.700000e-02 9.065109e-02 4.545843e-03
  -4.614798e-03 6.380000e-02 5.918520e-02 6.719510e-03
  -5.245799e-03 7.980000e-02 7.455420e-02 3.742639e-03
  -3.478093e-03 4.300000e-02 3.952191e-02 2.384060e-03
  -1.171421e-02 7.900000e-02 6.728579e-02 3.526464e-03
  -4.929606e-04 6.500000e-02 6.450704e-02 4.719975e-03
  1.032001e-04 7.060000e-02 7.070320e-02 2.818020e-03
  1.490542e-02 7.500000e-02 8.990542e-02 3.252334e-03
  2.025207e-03 4.860000e-02 5.062521e-02 3.465405e-03
  -5.774528e-03 8.780000e-02 8.202547e-02 3.405421e-03
  4.956496e-04 3.780000e-02 3.829565e-02 4.156833e-03
  -2.894910e-06 5.100000e-02 5.099711e-02 3.380886e-03
  -1.447588e-02 9.620000e-02 8.172412e-02 4.739993e-03
  -7.993217e-03 8.300000e-02 7.500678e-02 2.017008e-03
  -1.550480e-03 4.500000e-02 4.344952e-02 3.959266e-03
  8.208510e-03 8.620000e-02 9.440851e-02 2.914872e-03
  -3.627153e-03 7.580000e-02 7.217285e-02 1.566513e-03
  1.651659e-03 4.220000e-02 4.385166e-02 4.383073e-03
  -3.052011e-03 7.620000e-02 7.314799e-02 1.626256e-03
  -1.802860e-03 6.580000e-02 6.399714e-02 3.737749e-03
  5.496381e-03 6.140000e-02 6.689638e-02 5.069373e-03
  -1.675100e-03 5.220000e-02 5.052490e-02 5.070672e-03
  7.982772e-03 9.740000e-02 1.053828e-01 2.426710e-03
  -3.777109e-03 9.300000e-02 8.922289e-02 2.185962e-03
  -2.426036e-03 9.060000e-02 8.817396e-02 2.659605e-03
  2.509946e-03 5.660000e-02 5.910995e-02 3.347484e-03
  -8.261575e-03 8.780000e-02 7.953843e-02 3.072553e-03
  9.061844e-03 7.660000e-02 8.566184e-02 2.007290e-03
  -3.321662e-03 8.060000e-02 7.727834e-02 4.539146e-03
  9.564740e-04 5.580000e-02 5.675647e-02 2.128894e-03
  -6.399525e-04 5.980000e-02 5.916005e-02 3.521886e-03
  -1.518910e-03 7.540000e-02 7.388109e-02 2.263099e-03
  -4.187682e-03 8.140000e-02 7.721232e-02 2.102974e-03
  -3.400765e-03 5.740000e-02 5.399924e-02 3.914931e-03
  -9.503190e-04 9.220000e-02 9.124968e-02 4.446090e-03
  -8.468717e-04 5.740000e-02 5.655313e-02 4.753681e-03
  3.246936e-03 5.100000e-02 5.424694e-02 2.445148e-03
  1.929164e-03 7.980000e-02 8.172916e-02 2.120694e-03
  5.805061e-03 9.020000e-02 9.600506e-02 2.878030e-03
  -7.832381e-04 7.860000e-02 7.781676e-02 3.411996e-03
  -6.114500e-05 3.180000e-02 3.173886e-02 2.967896e-03
  -4.794355e-03 8.460000e-02 7.980565e-02 3.365581e-03
  -2.452410e-04 4.540000e-02 4.515476e-02 4.361540e-03
  6.770644e-03 6.420000e-02 7.097064e-02 2.290388e-03
  -6.239715e-04 8.020000e-02 7.957603e-02 1.849774e-03
  -9.427460e-03 3.700000e-02 2.757254e-02 2.889035e-03
  -3.449101e-03 5.980000e-02 5.635090e-02 3.704834e-03
  -2.304483e-03 5.460000e-02 5.229552e-02 3.255072e-03
  -1.126272e-03 8.020000e-02 7.907373e-02 3.841926e-03
  -1.150736e-02 8.260000e-02 7.109264e-02 2.950795e-03
  3.250616e-04 8.580000e-02 8.612506e-02 1.504700e-03
  4.177630e-03 6.300000e-02 6.717763e-02 4.370976e-03
  -3.467475e-03 7.180000e-02 6.833253e-02 4.610558e-03
  -1.029186e-02 8.420000e-02 7.390814e-02 3.086598e-03
  -1.741735e-03 4.020000e-02 3.845826e-02 5.624331e-03
  4.408954e-03 3.500000e-02 3.940895e-02 6.029051e-03
  -1.153765e-02 1.026000e-01 9.106235e-02 3.986901e-03
  -9.355045e-04 8.180000e-02 8.086450e-02 4.049305e-03
  -5.761741e-03 9.460000e-02 8.883826e-02 3.445093e-03
  -1.290067e-03 2.900000e-02 2.770993e-02 2.606992e-03
  -1.767016e-03 2.980000e-02 2.803298e-02 2.455860e-03
  4.279920e-03 5.500000e-02 5.927992e-02 2.446297e-03
  -1.333222e-03 3.380000e-02 3.246678e-02 2.479183e-03
  7.581334e-03 7.460000e-02 8.218133e-02 2.106391e-03
  7.163335e-04 3.260000e-02 3.331633e-02 2.518996e-03
  3.836325e-03 9.540000e-02 9.923633e-02 2.454473e-03
  -9.437008e-04 3.420000e-02 3.325630e-02 2.526042e-03
  -2.504768e-03 4.300000e-02 4.049523e-02 2.289053e-03
  3.667886e-03 8.820000e-02 9.186789e-02 2.583870e-03
  -7.369012e-03 7.940000e-02 7.203099e-02 1.562686e-03
  6.108469e-03 8.500000e-02 9.110847e-02 2.663303e-03
  -2.441336e-03 3.180000e-02 2.935866e-02 2.491686e-03
  1.114814e-03 3.700000e-02 3.811481e-02 2.534432e-03
  -1.414646e-03 2.740000e-02 2.598535e-02 2.491063e-03
  2.824148e-03 9.420000e-02 9.702415e-02 2.449412e-03
  2.453010e-03 2.860000e-02 3.105301e-02 2.460223e-03
  6.269172e-03 9.660000e-02 1.028692e-01 2.210617e-03
  3.577996e-04 7.780000e-02 7.815780e-02 2.521346e-03
  -2.810888e-04 3.220000e-02 3.191891e-02 2.545038e-03
  4.720893e-03 4.620000e-02 5.092089e-02 2.265016e-03
  -9.369745e-04 3.660000e-02 3.566303e-02 2.510112e-03
  1.341818e-03 3.500000e-02 3.634182e-02 2.502787e-03
  -5.195779e-04 3.220000e-02 3.168042e-02 2.352583e-03
  1.546076e-03 8.020000e-02 8.174608e-02 2.476754e-03
  5.420749e-03 9.660000e-02 1.020207e-01 2.444875e-03
  -4.783556e-03 1.042000e-01 9.941644e-02 2.310308e-03
  1.356452e-03 3.580000e-02 3.715645e-02 2.530043e-03
  -7.336047e-04 2.940000e-02 2.866640e-02 2.503327e-03
  5.552719e-04 8.700000e-02 8.755527e-02 2.495031e-03
  1.920469e-03 2.860000e-02 3.052047e-02 2.531996e-03
  9.641691e-04 3.260000e-02 3.356417e-02 2.540350e-03
  -1.843842e-03 2.940000e-02 2.755616e-02 2.488308e-03
  -2.520208e-03 8.500000e-02 8.247979e-02 2.036899e-03
  -5.829497e-03 9.900000e-02 9.317050e-02 2.534932e-03
  2.201821e-03 1.074000e-01 1.096018e-01 2.441193e-03
  1.548703e-03 3.300000e-02 3.454870e-02 1.642672e-03
  2.197139e-03 3.140000e-02 3.359714e-02 2.513499e-03
  -5.746436e-03 1.038000e-01 9.805356e-02 2.434920e-03
  -2.814766e-03 9.220000e-02 8.938523e-02 3.715706e-03
  3.495308e-03 2.660000e-02 3.009531e-02 3.348842e-03
  2.285934e-03 3.180000e-02 3.408593e-02 2.488969e-03
  -3.874407e-04 8.340000e-02 8.301256e-02 2.494822e-03
  -8.015170e-04 3.620000e-02 3.539848e-02 2.553661e-03
  -1.463027e-03 3.220000e-02 3.073697e-02 3.219724e-03
  2.021306e-03 6.660000e-02 6.862131e-02 2.546100e-03
  6.399277e-03 8.420000e-02 9.059928e-02 2.336163e-03
  -2.567891e-03 8.780000e-02 8.523211e-02 2.471447e-03
  -6.923708e-03 8.700000e-02 8.007629e-02 2.104903e-03
  2.113747e-03 2.860000e-02 3.071375e-02 2.652163e-03
  -4.106693e-04 3.580000e-02 3.538933e-02 2.521294e-03
  5.624535e-04 3.580000e-02 3.636245e-02 2.513171e-03
  1.506071e-03 3.060000e-02 3.210607e-02 2.888576e-03
  -6.135678e-03 1.018000e-01 9.566432e-02 2.074272e-03
  2.850675e-03 2.940000e-02 3.225068e-02 2.499096e-03
  -1.188603e-03 8.340000e-02 8.221140e-02 2.516502e-03
  1.007125e-03 7.020000e-02 7.120713e-02 2.509205e-03
  -2.911418e-03 8.500000e-02 8.208858e-02 2.540083e-03
  -2.129233e-03 7.820000e-02 7.607077e-02 2.366018e-03
  -8.710234e-04 3.620000e-02 3.532898e-02 2.665861e-03
  1.514770e-03 3.340000e-02 3.491477e-02 2.903923e-03
  -3.871783e-03 6.620000e-02 6.232822e-02 2.388513e-03
  2.991877e-03 8.820000e-02 9.119188e-02 2.442496e-03
  -1.184893e-03 3.060000e-02 2.941511e-02 2.513236e-03
];
hold off
figure(1)
subplot(1,2,1)
[nk, xk] = hist(A(:,1), 10);
bar(xk,nk/sum(nk))
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('CV Error','FontWeight','bold','FontSize',12)
xlabel('Error (unnormalized)','FontWeight','bold','FontSize',12)
ylabel('Probabilities','FontWeight','bold','FontSize',12)
disp(['Error Mean  = ' num2str(mean(A(:,1)))])
disp(['Error stdev = ' num2str(std(A(:,1)))])
subplot(1,2,2)
xmax = max(A(:,2));
xmin = min(A(:,2));
if (xmax == xmin) 
   xmin = 0.9 * xmin; 
   xmax = 1.1 * xmax; 
end;
if (xmax == xmin) 
   xmin = -0.1; 
   xmax = 0.1; 
end;
if errBoundOn == 1
ymax = max(A(:,3)+A(:,4));
ymin = min(A(:,3)-A(:,4));
else
ymax = max(A(:,3));
ymin = min(A(:,3));
end;
if (ymax == ymin) 
   ymin = 0.9 * ymin; 
   ymax = 1.1 * ymax; 
end;
if (ymax == ymin) 
   ymin = -0.1; 
   ymax = 0.1; 
end;
xmin = min(xmin, ymin);
xmax = max(xmax, ymax);
XX = xmin : xmax-xmin : xmax;
plot(A(:,2), A(:,3),'*','MarkerSize',12)
hold on
plot(XX, XX)
axis([xmin xmax xmin xmax])
cnt1 = 0;
cnt2 = 0;
cnt3 = 0;
cnt4 = 0;
if errBoundOn == 1
for ii = 1 : 184
  xx = [A(ii,2) A(ii,2)];
  d1 = A(ii,3)-A(ii,4);
  d2 = A(ii,3)+A(ii,4);
  yy = [d1 d2];
  if (xx(1) < d1 | xx(1) > d2)
    plot(xx, yy, 'r-', 'lineWidth', 1)
    d3 = A(ii,3)-2*A(ii,4);
    d4 = A(ii,3)+2*A(ii,4);
    if (xx(1) < d3 | xx(1) > d4)
      d5 = A(ii,3)-3*A(ii,4);
      d6 = A(ii,3)+3*A(ii,4);
      if (xx(1) > d5 & xx(1) < d6)
        cnt3 = cnt3 + 1;
      else
        d7 = A(ii,3)-4*A(ii,4);
        d8 = A(ii,3)+4*A(ii,4);
        if (xx(1) > d7 & xx(1) < d8)
          cnt4 = cnt4 + 1;
        else
          disp(['Point outside 4-sigma = ',int2str(ii)])
        end;
      end;
    else
      cnt2 = cnt2 + 1;
    end;
  else
    plot(xx, yy, 'g-', 'lineWidth', 1);
    cnt1 = cnt1 + 1;
  end;
%plot(xx(1), yy(1),'rv','markerSize',10);
%plot(xx(2), yy(2),'r^','markerSize',10);
end;
end;
cnt4 = cnt1 + cnt2 + cnt3 + cnt4;
cnt3 = cnt1 + cnt2 + cnt3;
cnt2 = cnt1 + cnt2;
disp('Total sample size = 184')
disp(['Num points inside 1 sigma = ',int2str(cnt1)])
disp(['Num points inside 2 sigma = ',int2str(cnt2)])
disp(['Num points inside 3 sigma = ',int2str(cnt3)])
disp(['Num points inside 4 sigma = ',int2str(cnt4)])
text(0.1,0.9,'RED: prediction outside +/- 1 std dev','sc','fontSize',11,'fontweight','bold')
hold off
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Parity Plot (scaled rmse=   6.52e-02, R2=   9.58e-01)','FontWeight','bold','FontSize',12)
xlabel('Sample Output','FontWeight','bold','FontSize',12)
ylabel('Predicted Output','FontWeight','bold','FontSize',12)
rsme_unscaled = 4.606817e-03;
rsme_scaled   = 6.518722e-02;
R2 = 9.583869e-01;
if morePlots == 1
%  For the following B matrix
% Column 1: true values
% Column 2: normalized residual
% Column 3: predicted values
% Column 4-(m+3): inputs
figure(2)
B = [
 9.540000e-02 1.069175e-02  9.641999e-02  4.375360e+00  2.964830e+00  3.953700e+00  4.225300e-01  6.659300e-01  2.427300e-01 
 9.820000e-02 9.272272e-02  1.073054e-01  1.704949e+01  2.181900e+00  5.744190e+00  4.102100e-01  5.913000e-01  2.457300e-01 
 6.500000e-02 4.373649e-02  6.784287e-02  3.859940e+00  2.816860e+00  7.026480e+00  3.860900e-01  7.086700e-01  1.283000e-01 
 4.740000e-02 -6.884522e-02  4.413674e-02  1.978219e+01  3.462020e+00  1.240739e+01  4.027200e-01  8.333300e-01  7.859000e-02 
 5.420000e-02 -2.019473e-02  5.310545e-02  1.571820e+00  2.662010e+00  1.419460e+01  4.282100e-01  7.642000e-01  9.836000e-02 
 6.420000e-02 -1.132107e-02  6.347319e-02  9.356450e+00  4.811470e+00  3.145020e+00  4.205300e-01  5.998400e-01  1.063100e-01 
 7.660000e-02 1.049039e-02  7.740356e-02  4.612860e+00  3.656390e+00  1.455375e+01  3.842400e-01  8.916300e-01  1.728600e-01 
 6.860000e-02 1.504374e-02  6.963200e-02  8.891980e+00  2.695030e+00  1.124695e+01  3.874900e-01  7.845900e-01  1.355400e-01 
 4.220000e-02 8.131959e-02  4.563169e-02  1.546244e+01  4.565810e+00  1.496098e+01  3.990600e-01  7.547500e-01  7.519000e-02 
 6.980000e-02 6.009870e-02  7.399489e-02  9.794750e+00  4.641680e+00  5.616180e+00  4.046100e-01  8.998900e-01  1.303400e-01 
 4.740000e-02 7.632760e-02  5.101793e-02  1.436017e+01  3.699970e+00  1.396966e+01  4.261700e-01  6.085100e-01  8.884000e-02 
 4.580000e-02 3.354758e-02  4.733648e-02  3.531400e+00  3.156700e+00  1.179732e+01  4.233400e-01  5.889900e-01  7.391000e-02 
 7.820000e-02 -2.967956e-02  7.587906e-02  1.801631e+01  3.374340e+00  4.715980e+00  3.878200e-01  5.324800e-01  1.567900e-01 
 6.020000e-02 -2.417915e-02  5.874442e-02  3.201460e+00  3.244100e+00  9.729100e+00  3.985900e-01  8.651700e-01  1.068900e-01 
 6.820000e-02 5.437138e-02  7.190813e-02  1.177288e+01  2.119800e+00  1.266166e+01  4.199200e-01  6.852800e-01  1.325000e-01 
 4.060000e-02 6.483671e-02  4.323237e-02  1.777329e+01  4.196870e+00  8.539230e+00  4.288800e-01  5.599000e-01  6.076000e-02 
 7.060000e-02 6.987181e-02  7.553295e-02  1.213926e+01  3.180670e+00  1.344804e+01  3.800500e-01  7.422800e-01  1.540700e-01 
 7.100000e-02 3.580484e-03  7.125421e-02  1.038615e+01  2.243130e+00  1.371583e+01  3.956600e-01  5.216300e-01  1.789200e-01 
 6.980000e-02 -6.263330e-02  6.542820e-02  6.360520e+00  4.267260e+00  7.213220e+00  3.951600e-01  6.118900e-01  1.369100e-01 
 8.020000e-02 -1.516417e-02  7.898383e-02  1.927380e+00  4.594380e+00  4.359370e+00  4.254600e-01  5.686700e-01  1.666400e-01 
 5.420000e-02 -2.781224e-02  5.269258e-02  7.923090e+00  3.308080e+00  1.320380e+01  4.077200e-01  5.634800e-01  9.483000e-02 
 9.860000e-02 -6.121876e-02  9.256383e-02  1.392801e+01  4.624710e+00  1.169867e+01  3.829300e-01  8.059000e-01  2.442200e-01 
 8.340000e-02 1.378213e-01  9.489429e-02  2.432120e+00  4.553520e+00  1.029733e+01  4.064600e-01  6.827400e-01  2.387400e-01 
 5.060000e-02 -2.561642e-02  4.930381e-02  1.071613e+01  3.062480e+00  5.441730e+00  3.833700e-01  6.240000e-01  8.398000e-02 
 6.580000e-02 -1.334628e-02  6.492182e-02  1.564814e+01  2.556910e+00  5.119670e+00  4.267900e-01  7.164200e-01  1.096900e-01 
 8.780000e-02 -8.699925e-02  8.016147e-02  1.282210e+00  3.708020e+00  8.612670e+00  4.160500e-01  7.242600e-01  1.984200e-01 
 7.540000e-02 -8.869810e-02  6.871216e-02  3.034280e+00  4.347130e+00  1.388751e+01  4.211800e-01  6.528500e-01  1.829700e-01 
 3.580000e-02 -7.780415e-02  3.301461e-02  1.400174e+01  4.521220e+00  4.824240e+00  4.157800e-01  7.383500e-01  5.250000e-02 
 6.020000e-02 -2.479083e-02  5.870759e-02  6.734400e+00  2.273520e+00  3.497100e+00  4.083800e-01  8.022200e-01  1.024500e-01 
 5.780000e-02 9.984440e-02  6.357101e-02  6.780780e+00  4.125000e+00  1.362384e+01  3.890900e-01  8.127800e-01  1.105100e-01 
 8.420000e-02 -5.644387e-02  7.944743e-02  1.427673e+01  2.024660e+00  6.273640e+00  3.886900e-01  7.798200e-01  1.899800e-01 
 8.020000e-02 -8.602790e-03  7.951006e-02  1.590304e+01  3.078230e+00  1.228502e+01  4.277200e-01  5.153300e-01  2.187300e-01 
 6.660000e-02 3.427887e-02  6.888297e-02  1.734637e+01  2.875560e+00  1.469184e+01  4.164700e-01  8.371600e-01  1.257300e-01 
 7.900000e-02 3.621585e-02  8.186105e-02  1.963853e+01  4.895500e+00  9.401960e+00  3.893000e-01  6.687800e-01  1.698400e-01 
 7.860000e-02 2.555769e-02  8.060883e-02  1.860037e+01  4.321550e+00  3.806650e+00  4.114600e-01  7.008900e-01  1.519700e-01 
 7.860000e-02 3.686957e-02  8.149795e-02  1.057073e+01  4.974600e+00  1.086454e+01  4.283900e-01  8.540000e-01  1.566700e-01 
 8.340000e-02 4.541917e-02  8.718796e-02  1.260860e+01  2.867230e+00  3.100330e+00  4.068700e-01  5.607900e-01  1.740400e-01 
 7.580000e-02 1.553658e-01  8.757673e-02  4.877900e-01  3.293600e+00  6.215620e+00  3.905900e-01  6.892300e-01  2.122700e-01 
 3.540000e-02 4.351213e-02  3.694033e-02  5.184040e+00  3.022950e+00  1.100986e+01  3.933900e-01  6.734500e-01  5.839000e-02 
 7.060000e-02 -5.257726e-02  6.688805e-02  5.627100e-01  4.171320e+00  1.153063e+01  4.133100e-01  8.734500e-01  1.437200e-01 
 8.580000e-02 4.948831e-02  9.004610e-02  2.085240e+00  2.476560e+00  1.202045e+01  4.052100e-01  7.925700e-01  2.046900e-01 
 1.058000e-01 -6.746816e-02  9.866187e-02  1.021160e+01  3.884910e+00  5.017100e+00  4.173700e-01  7.874900e-01  2.485200e-01 
 8.740000e-02 3.130712e-02  9.013624e-02  1.352786e+01  4.449470e+00  5.216500e+00  3.982400e-01  6.276500e-01  2.306000e-01 
 7.140000e-02 5.384429e-02  7.524448e-02  7.214230e+00  5.000000e+00  5.891880e+00  3.815000e-01  7.213200e-01  1.479900e-01 
 4.780000e-02 -7.418380e-03  4.744540e-02  9.942500e-01  4.943810e+00  1.300774e+01  3.969700e-01  6.193800e-01  8.239000e-02 
 5.580000e-02 1.096035e-01  6.191587e-02  1.144010e+01  3.753910e+00  7.993820e+00  3.961200e-01  7.959600e-01  1.003000e-01 
 7.420000e-02 8.965464e-02  8.085237e-02  9.144560e+00  3.807400e+00  7.841290e+00  3.805400e-01  5.041500e-01  2.277900e-01 
 6.140000e-02 3.375488e-02  6.347255e-02  4.149750e+00  4.510980e+00  1.115187e+01  4.091400e-01  5.112400e-01  1.239800e-01 
 9.340000e-02 2.534182e-02  9.576693e-02  3.965480e+00  2.071920e+00  1.317761e+01  4.143200e-01  8.496600e-01  2.268200e-01 
 8.220000e-02 -3.721013e-02  7.914133e-02  6.521340e+00  3.593260e+00  1.078099e+01  3.995600e-01  5.368300e-01  2.498100e-01 
 8.420000e-02 1.548063e-01  9.723469e-02  1.673252e+01  3.226000e+00  3.577120e+00  4.240800e-01  8.668600e-01  1.954100e-01 
 9.620000e-02 -1.013084e-01  8.645413e-02  1.927334e+01  2.433730e+00  1.104618e+01  4.216600e-01  7.337400e-01  2.327800e-01 
 9.740000e-02 -1.781957e-02  9.566437e-02  8.121330e+00  3.418260e+00  1.407449e+01  3.963300e-01  8.605900e-01  2.414600e-01 
 7.060000e-02 2.384766e-02  7.228364e-02  6.922220e+00  2.760940e+00  1.281640e+01  4.153900e-01  6.332300e-01  1.593900e-01 
 8.220000e-02 3.462947e-02  8.504654e-02  1.451648e+01  2.572550e+00  8.253800e+00  4.139400e-01  6.710100e-01  1.702100e-01 
 8.500000e-02 -1.098970e-01  7.565876e-02  1.843070e+01  2.302720e+00  1.432931e+01  3.840400e-01  6.405100e-01  2.113400e-01 
 7.140000e-02 5.604890e-02  7.540189e-02  5.479050e+00  4.747410e+00  1.249230e+01  3.868400e-01  5.536300e-01  1.936400e-01 
 6.180000e-02 -4.781701e-02  5.884491e-02  1.524148e+01  2.596810e+00  1.158658e+01  4.018800e-01  6.499400e-01  1.119100e-01 
 4.340000e-02 -5.512257e-02  4.100768e-02  9.653790e+00  2.000070e+00  9.437090e+00  4.062200e-01  7.291700e-01  7.037000e-02 
 3.660000e-02 -9.346756e-03  3.625791e-02  1.333593e+01  2.398630e+00  1.295898e+01  3.903300e-01  8.721000e-01  6.273000e-02 
 7.940000e-02 7.548231e-02  8.539330e-02  1.324561e+01  3.525240e+00  1.138346e+01  4.120800e-01  6.217100e-01  1.995000e-01 
 8.700000e-02 4.196652e-02  9.065109e-02  1.500292e+01  4.231320e+00  4.577100e+00  3.857200e-01  8.776600e-01  2.058700e-01 
 6.380000e-02 -7.233226e-02  5.918520e-02  2.730280e+00  2.539160e+00  1.481507e+01  3.920300e-01  5.485400e-01  1.502400e-01 
 7.980000e-02 -6.573683e-02  7.455420e-02  1.155391e+01  4.255110e+00  1.478333e+01  4.186500e-01  5.756900e-01  2.367700e-01 
 4.300000e-02 -8.088588e-02  3.952191e-02  1.104686e+01  2.823900e+00  1.038711e+01  4.170800e-01  5.400000e-01  6.513000e-02 
 7.900000e-02 -1.482811e-01  6.728579e-02  1.374508e+01  2.061280e+00  9.686000e+00  4.224800e-01  5.280700e-01  1.464000e-01 
 6.500000e-02 -7.584009e-03  6.450704e-02  1.307465e+01  3.142740e+00  2.945090e+00  3.926900e-01  7.698100e-01  1.197200e-01 
 7.060000e-02 1.461757e-03  7.070320e-02  1.918745e+01  3.770260e+00  4.187520e+00  4.194800e-01  6.395500e-01  1.231400e-01 
 7.500000e-02 1.987389e-01  8.990542e-02  1.876746e+01  2.997220e+00  8.754110e+00  3.940600e-01  8.945700e-01  1.836200e-01 
 4.860000e-02 4.167092e-02  5.062521e-02  7.885250e+00  2.229430e+00  7.368330e+00  4.250200e-01  8.889300e-01  7.673000e-02 
 8.780000e-02 -6.576911e-02  8.202547e-02  8.713140e+00  2.328680e+00  6.637590e+00  4.291700e-01  6.136700e-01  1.865000e-01 
 3.780000e-02 1.311242e-02  3.829565e-02  1.827488e+01  2.931100e+00  6.816970e+00  4.125400e-01  8.081400e-01  5.610000e-02 
 5.100000e-02 -5.676294e-05  5.099711e-02  1.827340e+00  4.365670e+00  8.305230e+00  3.879300e-01  7.710800e-01  9.045000e-02 
 9.620000e-02 -1.504770e-01  8.172412e-02  3.718440e+00  4.828480e+00  3.306220e+00  3.944900e-01  8.346700e-01  2.214100e-01 
 8.300000e-02 -9.630382e-02  7.500678e-02  1.489744e+01  3.345950e+00  1.057415e+01  4.182300e-01  7.995700e-01  1.646500e-01 
 4.500000e-02 -3.445512e-02  4.344952e-02  4.737220e+00  4.880180e+00  9.001750e+00  4.188100e-01  7.805400e-01  6.967000e-02 
 8.620000e-02 9.522634e-02  9.440851e-02  5.020020e+00  4.095250e+00  6.962220e+00  4.271500e-01  6.961700e-01  2.237400e-01 
 7.580000e-02 -4.785162e-02  7.217285e-02  2.900210e+00  3.379370e+00  5.298300e+00  4.104300e-01  7.463100e-01  1.338800e-01 
 4.220000e-02 3.913883e-02  4.385166e-02  1.185677e+01  4.700180e+00  6.679860e+00  3.910500e-01  5.184700e-01  6.745000e-02 
 7.620000e-02 -4.005264e-02  7.314799e-02  1.289276e+01  3.439730e+00  7.899260e+00  4.244800e-01  6.572100e-01  1.389900e-01 
 6.580000e-02 -2.739909e-02  6.399714e-02  8.833830e+00  4.427100e+00  1.226102e+01  4.231300e-01  8.259300e-01  1.161600e-01 
 6.140000e-02 8.951761e-02  6.689638e-02  1.893586e+01  4.060670e+00  1.353491e+01  4.055100e-01  5.009100e-01  1.400800e-01 
 5.220000e-02 -3.209003e-02  5.052490e-02  5.659120e+00  2.464800e+00  4.481680e+00  4.134200e-01  5.074600e-01  8.162000e-02 
 9.740000e-02 8.195864e-02  1.053828e-01  1.224341e+01  2.774420e+00  8.453020e+00  4.012700e-01  8.210900e-01  2.383700e-01 
 9.300000e-02 -4.061408e-02  8.922289e-02  1.124030e+01  4.037860e+00  9.564760e+00  4.080100e-01  8.411500e-01  1.916600e-01 
 9.060000e-02 -2.677744e-02  8.817396e-02  1.089210e+01  2.373200e+00  4.299160e+00  3.971500e-01  7.466900e-01  2.183200e-01 
 5.660000e-02 4.434534e-02  5.910995e-02  1.655798e+01  4.785480e+00  1.000395e+01  4.097500e-01  8.846100e-01  9.527000e-02 
 8.780000e-02 -9.409539e-02  7.953843e-02  1.747727e+01  4.481330e+00  6.476440e+00  4.040900e-01  8.198100e-01  1.781200e-01 
 7.660000e-02 1.183008e-01  8.566184e-02  7.247090e+00  3.827280e+00  1.012329e+01  4.262500e-01  7.501800e-01  1.763400e-01 
 8.060000e-02 -4.121169e-02  7.727834e-02  1.056390e+00  2.143540e+00  4.920890e+00  3.997100e-01  8.277000e-01  1.602700e-01 
 5.580000e-02 1.714111e-02  5.675647e-02  8.265780e+00  4.150980e+00  3.881450e+00  4.011900e-01  6.566300e-01  9.308000e-02 
 5.980000e-02 -1.070155e-02  5.916005e-02  4.928580e+00  2.102020e+00  8.823350e+00  3.822000e-01  5.722400e-01  1.170100e-01 
 7.540000e-02 -2.014470e-02  7.388109e-02  1.623508e+01  3.839930e+00  1.191204e+01  4.003900e-01  6.004700e-01  1.623400e-01 
 8.140000e-02 -5.144572e-02  7.721232e-02  8.538240e+00  4.291750e+00  1.051266e+01  3.923000e-01  7.313200e-01  1.808400e-01 
 5.740000e-02 -5.924678e-02  5.399924e-02  1.715863e+01  4.397530e+00  1.066701e+01  3.819400e-01  5.842600e-01  1.034500e-01 
 9.220000e-02 -1.030715e-02  9.124968e-02  1.806747e+01  4.724020e+00  1.331483e+01  4.246100e-01  7.734100e-01  2.032000e-01 
 5.740000e-02 -1.475386e-02  5.655313e-02  1.944200e+01  2.731600e+00  6.020740e+00  3.977700e-01  5.503900e-01  9.822000e-02 
 5.100000e-02 6.366540e-02  5.424694e-02  1.758387e+01  2.214560e+00  1.017438e+01  3.947500e-01  6.974000e-01  8.813000e-02 
 7.980000e-02 2.417499e-02  8.172916e-02  5.883870e+00  3.111340e+00  7.566230e+00  4.006600e-01  7.596100e-01  1.681500e-01 
 9.020000e-02 6.435766e-02  9.600506e-02  1.684116e+01  3.978000e+00  1.277038e+01  3.916300e-01  7.183100e-01  2.234500e-01 
 7.860000e-02 -9.964862e-03  7.781676e-02  5.354390e+00  3.573640e+00  5.759960e+00  4.299200e-01  8.133400e-01  1.484900e-01 
 3.180000e-02 -1.922799e-03  3.173886e-02  1.003092e+01  3.607330e+00  1.209151e+01  3.850500e-01  6.621000e-01  5.036000e-02 
 8.460000e-02 -5.667086e-02  7.980565e-02  1.538317e+01  4.967040e+00  7.386070e+00  4.146300e-01  5.437400e-01  2.147100e-01 
 4.540000e-02 -5.401784e-03  4.515476e-02  1.639795e+01  3.536720e+00  3.385050e+00  3.864600e-01  6.786800e-01  7.239000e-02 
 6.420000e-02 1.054617e-01  7.097064e-02  1.466794e+01  3.943970e+00  9.190300e+00  3.930400e-01  5.781200e-01  1.297900e-01 
 8.020000e-02 -7.780193e-03  7.957603e-02  9.868680e+00  3.261460e+00  9.079090e+00  4.034300e-01  5.952600e-01  2.080500e-01 
 3.700000e-02 -2.547962e-01  2.757254e-02  6.063230e+00  3.916170e+00  1.447544e+01  4.112300e-01  7.115700e-01  5.721000e-02 
 5.980000e-02 -5.767727e-02  5.635090e-02  1.278794e+01  4.866360e+00  1.428530e+01  4.032900e-01  6.900800e-01  1.202400e-01 
 5.460000e-02 -4.220664e-02  5.229552e-02  1.233427e+01  4.018560e+00  6.091250e+00  4.219000e-01  8.589600e-01  8.575000e-02 
 8.020000e-02 -1.404330e-02  7.907373e-02  7.425720e+00  2.622870e+00  3.710920e+00  3.898100e-01  5.833300e-01  2.018000e-01 
 8.260000e-02 -1.393142e-01  7.109264e-02  9.523740e+00  3.029510e+00  1.501197e+01  4.092000e-01  7.046500e-01  1.931200e-01 
 8.580000e-02 3.788597e-03  8.612506e-02  7.654890e+00  4.682250e+00  8.185930e+00  4.121800e-01  6.441100e-01  2.087700e-01 
 6.300000e-02 6.631159e-02  6.717763e-02  8.145100e-01  3.493500e+00  6.453920e+00  4.177100e-01  5.357000e-01  1.147200e-01 
 7.180000e-02 -4.829352e-02  6.833253e-02  1.594906e+01  2.504320e+00  7.661980e+00  3.812000e-01  8.516400e-01  1.417500e-01 
 8.420000e-02 -1.222311e-01  7.390814e-02  1.360910e+00  2.899270e+00  9.897660e+00  3.849000e-01  6.040700e-01  2.337700e-01 
 4.020000e-02 -4.332675e-02  3.845826e-02  2.583230e+00  3.864580e+00  4.087910e+00  3.828300e-01  8.450500e-01  6.488000e-02 
 3.500000e-02 1.259701e-01  3.940895e-02  2.228390e+00  2.346590e+00  7.781350e+00  4.043300e-01  6.344100e-01  5.328000e-02 
 1.026000e-01 -1.124527e-01  9.106235e-02  6.224980e+00  2.698590e+00  9.303520e+00  4.200800e-01  8.814400e-01  2.167500e-01 
 8.180000e-02 -1.143649e-02  8.086450e-02  3.472770e+00  3.993430e+00  5.537680e+00  4.024100e-01  5.239800e-01  1.876400e-01 
 9.460000e-02 -6.090635e-02  8.883826e-02  2.000022e+01  3.634440e+00  7.121490e+00  4.072700e-01  7.612900e-01  2.285900e-01 
 2.900000e-02 -4.448507e-02  2.770993e-02  4.878000e-01  2.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  5.040000e-02 
 2.980000e-02 -5.929584e-02  2.803298e-02  2.000020e+01  5.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  5.040000e-02 
 5.500000e-02 7.781672e-02  5.927992e-02  4.878000e-01  5.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  2.498000e-01 
 3.380000e-02 -3.944445e-02  3.246678e-02  4.878000e-01  5.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  5.040000e-02 
 7.460000e-02 1.016265e-01  8.218133e-02  4.878000e-01  5.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  2.498000e-01 
 3.260000e-02 2.197342e-02  3.331633e-02  2.000020e+01  2.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  5.040000e-02 
 9.540000e-02 4.021305e-02  9.923633e-02  2.000020e+01  5.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  2.498000e-01 
 3.420000e-02 -2.759359e-02  3.325630e-02  2.000020e+01  2.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  5.040000e-02 
 4.300000e-02 -5.825041e-02  4.049523e-02  4.878000e-01  5.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  2.498000e-01 
 8.820000e-02 4.158601e-02  9.186789e-02  2.000020e+01  2.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  2.498000e-01 
 7.940000e-02 -9.280872e-02  7.203099e-02  4.878000e-01  5.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  2.498000e-01 
 8.500000e-02 7.186434e-02  9.110847e-02  2.000020e+01  5.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  2.498000e-01 
 3.180000e-02 -7.677156e-02  2.935866e-02  4.878000e-01  2.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  5.040000e-02 
 3.700000e-02 3.013012e-02  3.811481e-02  2.000020e+01  2.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  5.040000e-02 
 2.740000e-02 -5.162940e-02  2.598535e-02  4.878000e-01  5.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  5.040000e-02 
 9.420000e-02 2.998034e-02  9.702415e-02  4.878000e-01  5.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  2.498000e-01 
 2.860000e-02 8.576960e-02  3.105301e-02  2.000020e+01  2.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  5.040000e-02 
 9.660000e-02 6.489826e-02  1.028692e-01  4.878000e-01  2.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  2.498000e-01 
 7.780000e-02 4.598966e-03  7.815780e-02  2.000020e+01  2.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  2.498000e-01 
 3.220000e-02 -8.729465e-03  3.191891e-02  2.000020e+01  5.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  5.040000e-02 
 4.620000e-02 1.021838e-01  5.092089e-02  4.878000e-01  2.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  2.498000e-01 
 3.660000e-02 -2.560040e-02  3.566303e-02  4.878000e-01  2.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  5.040000e-02 
 3.500000e-02 3.833766e-02  3.634182e-02  2.000020e+01  5.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  5.040000e-02 
 3.220000e-02 -1.613596e-02  3.168042e-02  4.878000e-01  2.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  5.040000e-02 
 8.020000e-02 1.927776e-02  8.174608e-02  4.878000e-01  5.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  2.498000e-01 
 9.660000e-02 5.611541e-02  1.020207e-01  2.000020e+01  5.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  2.498000e-01 
 1.042000e-01 -4.590745e-02  9.941644e-02  2.000020e+01  2.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  2.498000e-01 
 3.580000e-02 3.788971e-02  3.715645e-02  4.878000e-01  5.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  5.040000e-02 
 2.940000e-02 -2.495254e-02  2.866640e-02  4.878000e-01  5.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  5.040000e-02 
 8.700000e-02 6.382435e-03  8.755527e-02  4.878000e-01  2.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  2.498000e-01 
 2.860000e-02 6.714927e-02  3.052047e-02  4.878000e-01  5.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  5.040000e-02 
 3.260000e-02 2.957574e-02  3.356417e-02  4.878000e-01  5.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  5.040000e-02 
 2.940000e-02 -6.271570e-02  2.755616e-02  2.000020e+01  5.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  5.040000e-02 
 8.500000e-02 -2.964951e-02  8.247979e-02  2.000020e+01  5.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  2.498000e-01 
 9.900000e-02 -5.888381e-02  9.317050e-02  2.000020e+01  2.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  2.498000e-01 
 1.074000e-01 2.050113e-02  1.096018e-01  2.000020e+01  2.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  2.498000e-01 
 3.300000e-02 4.693040e-02  3.454870e-02  4.878000e-01  2.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  5.040000e-02 
 3.140000e-02 6.997260e-02  3.359714e-02  4.878000e-01  2.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  5.040000e-02 
 1.038000e-01 -5.536066e-02  9.805356e-02  2.000020e+01  2.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  2.498000e-01 
 9.220000e-02 -3.052891e-02  8.938523e-02  2.000020e+01  5.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  2.498000e-01 
 2.660000e-02 1.314026e-01  3.009531e-02  4.878000e-01  5.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  5.040000e-02 
 3.180000e-02 7.188471e-02  3.408593e-02  2.000020e+01  2.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  5.040000e-02 
 8.340000e-02 -4.645572e-03  8.301256e-02  4.878000e-01  2.000000e+00  1.501200e+01  3.801000e-01  8.999000e-01  2.498000e-01 
 3.620000e-02 -2.214135e-02  3.539848e-02  2.000020e+01  5.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  5.040000e-02 
 3.220000e-02 -4.543563e-02  3.073697e-02  2.000020e+01  2.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  5.040000e-02 
 6.660000e-02 3.034994e-02  6.862131e-02  2.000020e+01  5.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  2.498000e-01 
 8.420000e-02 7.600092e-02  9.059928e-02  4.878000e-01  2.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  2.498000e-01 
 8.780000e-02 -2.924705e-02  8.523211e-02  4.878000e-01  2.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  2.498000e-01 
 8.700000e-02 -7.958286e-02  8.007629e-02  4.878000e-01  2.000000e+00  2.945100e+00  4.299000e-01  5.009000e-01  2.498000e-01 
 2.860000e-02 7.390724e-02  3.071375e-02  4.878000e-01  2.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  5.040000e-02 
 3.580000e-02 -1.147121e-02  3.538933e-02  4.878000e-01  5.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  5.040000e-02 
 3.580000e-02 1.571099e-02  3.636245e-02  4.878000e-01  2.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  5.040000e-02 
 3.060000e-02 4.921801e-02  3.210607e-02  2.000020e+01  5.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  5.040000e-02 
 1.018000e-01 -6.027189e-02  9.566432e-02  4.878000e-01  5.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  2.498000e-01 
 2.940000e-02 9.696175e-02  3.225068e-02  2.000020e+01  5.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  5.040000e-02 
 8.340000e-02 -1.425183e-02  8.221140e-02  4.878000e-01  5.000000e+00  1.501200e+01  4.299000e-01  8.999000e-01  2.498000e-01 
 7.020000e-02 1.434651e-02  7.120713e-02  2.000020e+01  5.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  2.498000e-01 
 8.500000e-02 -3.425198e-02  8.208858e-02  2.000020e+01  5.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  2.498000e-01 
 7.820000e-02 -2.722804e-02  7.607077e-02  2.000020e+01  2.000000e+00  1.501200e+01  4.299000e-01  5.009000e-01  2.498000e-01 
 3.620000e-02 -2.406142e-02  3.532898e-02  2.000020e+01  2.000000e+00  2.945100e+00  4.299000e-01  8.999000e-01  5.040000e-02 
 3.340000e-02 4.535240e-02  3.491477e-02  2.000020e+01  5.000000e+00  2.945100e+00  3.801000e-01  5.009000e-01  5.040000e-02 
 6.620000e-02 -5.848614e-02  6.232822e-02  4.878000e-01  2.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  2.498000e-01 
 8.820000e-02 3.392151e-02  9.119188e-02  2.000020e+01  2.000000e+00  2.945100e+00  3.801000e-01  8.999000e-01  2.498000e-01 
 3.060000e-02 -3.872198e-02  2.941511e-02  2.000020e+01  2.000000e+00  1.501200e+01  3.801000e-01  5.009000e-01  5.040000e-02 
];
AA = B(:,1);
BB = B(:,2);
CC = B(:,3);
subplot(1,2,1),plot(AA, BB, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Normalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Normalized Error','FontWeight','bold','FontSize',12)
subplot(1,2,2),plot(AA,BB.*AA, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Unnormalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Error','FontWeight','bold','FontSize',12)
figure(3)
for ii = 1 : 6
  XX = B(:,3+ii);
  plot(XX, BB.*AA, '*','markerSize',12);
  disp(['Error vs Input ' int2str(ii)])
  disp('Press enter to continue')
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
  xlabel(['Input ' int2str(ii)])
ylabel('Error','FontWeight','bold','FontSize',12)
  pause
end;
end;
print -dpng R2_GPM10_184F_RSFA_CV_err
