% This file contains total order Sobol' indices
% with error bars coming from bootstrapping.
% to select the most important ones to display,
% set sortFlag = 1 and set nn to be the number
% of inputs to display.
sortFlag = 0;
nn = 6;
Means = [
  1.5794846448076320e-02
  6.4653198143395704e-03
  2.6574227265898410e-02
  1.8567679906782156e-02
  4.8209734080710644e-02
  9.3791789323028563e-01
];
Stds = [
  7.1169553996481014e-03
  5.5558263793413446e-03
  8.9121938307062231e-03
  9.4909574446616109e-03
  1.1372238912996293e-02
  1.3435554885050963e-01
];
  Str = {'t1:P0','t2:beta','t3:StatWeight','t4:ep_g','t5:VelfacCoeff','x1:InitConc'};
hold off
if (sortFlag == 1)
  [Means, I2] = sort(Means,'descend');
  Stds = Stds(I2);
  I2 = I2(1:nn);
  Means = Means(1:nn);
  Stds = Stds(1:nn);
  Str  = Str(I2);
end
ymin = min(Means-Stds);
if ymin < 0 
    ymin = 0;
end;
ymax = max(Means+Stds);
h2 = 0.05 * (ymax - ymin);
bar(Means,0.8);
for ii = 1:nn
   if (ii == 1)
hold on
   end;
   XX = [ii ii];
   YY = [Means(ii)-Stds(ii) Means(ii)+Stds(ii)];
   if YY(1) < 0 
      YY(1) = 0;
   end;
   plot(XX,YY,'-ko','LineWidth',3.0,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',12)
end;
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
axis([0  nn+1 ymin ymax])
set(gca,'XTickLabel',[]);
th=text(1:nn, repmat(ymin-0.05*(ymax-ymin),nn,1),Str,'HorizontalAlignment','left','rotation',90);
set(th, 'fontsize', 12)
set(th, 'fontweight', 'bold')
title('Total Order Sobol Indices (with bootstrap)','FontWeight','bold','FontSize',12)
ylabel('Total Order Sobol Index (Normalized)','FontWeight','bold','FontSize',12)
hold off
