% This file stores CV error for each point
% Column 1: error (true - predicted)
% Column 2: true
% Column 3: predicted
% Column 4: standard deviations
% Set morePlots=1 for normalized residual error plot
% Set errBoundOn=1 for error bars in CV plot
errBoundOn = 0;
morePlots  = 0;
A = [
  -1.669350e-03 7.900000e-02 7.733065e-02 4.328189e-03
  1.726412e-03 9.600000e-02 9.772641e-02 4.907121e-03
  -4.890667e-03 6.100000e-02 5.610933e-02 1.820177e-03
  9.269359e-03 8.900000e-02 9.826936e-02 4.263299e-03
  3.616069e-03 8.900000e-02 9.261607e-02 4.572241e-03
  8.510130e-03 5.600000e-02 6.451013e-02 3.113596e-03
  -1.425185e-03 7.000000e-02 6.857481e-02 4.705836e-03
  -1.328977e-02 9.700000e-02 8.371023e-02 3.694482e-03
  -5.843091e-03 7.100000e-02 6.515691e-02 4.141689e-03
  8.645001e-03 8.400000e-02 9.264500e-02 3.377643e-03
  -1.454291e-02 1.050000e-01 9.045709e-02 4.997452e-03
  -7.909979e-03 8.500000e-02 7.709002e-02 3.961287e-03
  6.489771e-03 7.000000e-02 7.648977e-02 3.206206e-03
  -3.696677e-03 6.000000e-02 5.630332e-02 1.958004e-03
  4.552572e-03 4.500000e-02 4.955257e-02 4.629103e-03
  1.238482e-03 7.700000e-02 7.823848e-02 3.135877e-03
  -2.953514e-03 3.900000e-02 3.604649e-02 4.683034e-03
  2.294977e-03 3.600000e-02 3.829498e-02 3.361132e-03
  4.860314e-03 3.600000e-02 4.086031e-02 5.356061e-03
  -2.121421e-03 6.600000e-02 6.387858e-02 3.954628e-03
  1.113696e-03 9.100000e-02 9.211370e-02 3.183956e-03
  -1.702613e-03 5.600000e-02 5.429739e-02 4.967735e-03
  2.512703e-03 7.200000e-02 7.451270e-02 3.394525e-03
  2.622566e-03 5.100000e-02 5.362257e-02 5.132307e-03
  8.401592e-04 5.100000e-02 5.184016e-02 4.644573e-03
  9.543060e-04 4.900000e-02 4.995431e-02 2.725661e-03
  -8.072780e-03 9.000000e-02 8.192722e-02 3.656069e-03
  -1.308705e-03 7.100000e-02 6.969130e-02 2.988345e-03
  6.532438e-04 8.100000e-02 8.165324e-02 3.371573e-03
  -5.767143e-04 6.300000e-02 6.242329e-02 3.013708e-03
  3.392580e-04 7.200000e-02 7.233926e-02 3.741914e-03
  2.461045e-03 8.500000e-02 8.746105e-02 3.000448e-03
  -4.301890e-03 7.000000e-02 6.569811e-02 2.595198e-03
  4.596931e-05 6.600000e-02 6.604597e-02 6.001479e-03
  4.970176e-03 6.600000e-02 7.097018e-02 5.414733e-03
  1.854982e-03 3.200000e-02 3.385498e-02 4.106972e-03
  3.326614e-03 7.500000e-02 7.832661e-02 4.399718e-03
  -9.851124e-04 7.300000e-02 7.201489e-02 4.336238e-03
  -1.978734e-03 6.300000e-02 6.102127e-02 4.216872e-03
  -1.305001e-03 5.100000e-02 4.969500e-02 4.057988e-03
  -2.028335e-03 4.800000e-02 4.597167e-02 3.966196e-03
  -2.112710e-03 4.500000e-02 4.288729e-02 4.135200e-03
  7.630767e-05 8.300000e-02 8.307631e-02 3.572305e-03
  -1.030580e-02 1.030000e-01 9.269420e-02 3.976330e-03
  4.979795e-03 5.400000e-02 5.897980e-02 2.772844e-03
  1.289923e-02 9.100000e-02 1.038992e-01 5.204313e-03
  -4.714571e-03 9.800000e-02 9.328543e-02 4.180457e-03
  1.650220e-03 8.900000e-02 9.065022e-02 2.895516e-03
  7.623596e-04 7.900000e-02 7.976236e-02 5.574301e-03
  -2.552967e-04 8.100000e-02 8.074470e-02 3.080596e-03
  5.415333e-03 6.000000e-02 6.541533e-02 1.250935e-03
  -1.238741e-03 9.400000e-02 9.276126e-02 5.024478e-03
  2.851758e-03 7.600000e-02 7.885176e-02 2.622919e-03
  1.244795e-02 8.400000e-02 9.644795e-02 5.523249e-03
  -3.387047e-03 4.400000e-02 4.061295e-02 3.581928e-03
  4.310080e-04 9.100000e-02 9.143101e-02 3.892395e-03
  7.633327e-04 6.900000e-02 6.976333e-02 3.641424e-03
  -3.592582e-03 6.600000e-02 6.240742e-02 4.249923e-03
  -1.728260e-03 4.100000e-02 3.927174e-02 5.800789e-03
  -4.669686e-03 8.600000e-02 8.133031e-02 3.292243e-03
];
hold off
figure(1)
subplot(1,2,1)
[nk, xk] = hist(A(:,1), 10);
bar(xk,nk/sum(nk))
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('CV Error','FontWeight','bold','FontSize',12)
xlabel('Error (unnormalized)','FontWeight','bold','FontSize',12)
ylabel('Probabilities','FontWeight','bold','FontSize',12)
disp(['Error Mean  = ' num2str(mean(A(:,1)))])
disp(['Error stdev = ' num2str(std(A(:,1)))])
subplot(1,2,2)
xmax = max(A(:,2));
xmin = min(A(:,2));
if (xmax == xmin) 
   xmin = 0.9 * xmin; 
   xmax = 1.1 * xmax; 
end;
if (xmax == xmin) 
   xmin = -0.1; 
   xmax = 0.1; 
end;
if errBoundOn == 1
ymax = max(A(:,3)+A(:,4));
ymin = min(A(:,3)-A(:,4));
else
ymax = max(A(:,3));
ymin = min(A(:,3));
end;
if (ymax == ymin) 
   ymin = 0.9 * ymin; 
   ymax = 1.1 * ymax; 
end;
if (ymax == ymin) 
   ymin = -0.1; 
   ymax = 0.1; 
end;
xmin = min(xmin, ymin);
xmax = max(xmax, ymax);
XX = xmin : xmax-xmin : xmax;
plot(A(:,2), A(:,3),'*','MarkerSize',12)
hold on
plot(XX, XX)
axis([xmin xmax xmin xmax])
cnt1 = 0;
cnt2 = 0;
cnt3 = 0;
cnt4 = 0;
if errBoundOn == 1
for ii = 1 : 60
  xx = [A(ii,2) A(ii,2)];
  d1 = A(ii,3)-A(ii,4);
  d2 = A(ii,3)+A(ii,4);
  yy = [d1 d2];
  if (xx(1) < d1 | xx(1) > d2)
    plot(xx, yy, 'r-', 'lineWidth', 1)
    d3 = A(ii,3)-2*A(ii,4);
    d4 = A(ii,3)+2*A(ii,4);
    if (xx(1) < d3 | xx(1) > d4)
      d5 = A(ii,3)-3*A(ii,4);
      d6 = A(ii,3)+3*A(ii,4);
      if (xx(1) > d5 & xx(1) < d6)
        cnt3 = cnt3 + 1;
      else
        d7 = A(ii,3)-4*A(ii,4);
        d8 = A(ii,3)+4*A(ii,4);
        if (xx(1) > d7 & xx(1) < d8)
          cnt4 = cnt4 + 1;
        else
          disp(['Point outside 4-sigma = ',int2str(ii)])
        end;
      end;
    else
      cnt2 = cnt2 + 1;
    end;
  else
    plot(xx, yy, 'g-', 'lineWidth', 1);
    cnt1 = cnt1 + 1;
  end;
%plot(xx(1), yy(1),'rv','markerSize',10);
%plot(xx(2), yy(2),'r^','markerSize',10);
end;
end;
cnt4 = cnt1 + cnt2 + cnt3 + cnt4;
cnt3 = cnt1 + cnt2 + cnt3;
cnt2 = cnt1 + cnt2;
disp('Total sample size = 60')
disp(['Num points inside 1 sigma = ',int2str(cnt1)])
disp(['Num points inside 2 sigma = ',int2str(cnt2)])
disp(['Num points inside 3 sigma = ',int2str(cnt3)])
disp(['Num points inside 4 sigma = ',int2str(cnt4)])
%text(0.1,0.9,'RED: prediction outside +/- 1 std dev','sc','fontSize',11,'fontweight','bold')
hold off
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Parity Plot (scaled rmse=   6.85e-02, R2=   9.20e-01)','FontWeight','bold','FontSize',12)
xlabel('Sample Output','FontWeight','bold','FontSize',12)
ylabel('Predicted Output','FontWeight','bold','FontSize',12)
rsme_unscaled = 5.188742e-03;
rsme_scaled   = 6.849772e-02;
R2 = 9.202739e-01;
if morePlots == 1
%  For the following B matrix
% Column 1: true values
% Column 2: normalized residual
% Column 3: predicted values
% Column 4-(m+3): inputs
figure(2)
B = [
 7.900000e-02 -2.113101e-02  7.733065e-02  7.168000e+00  2.866000e+00  3.928000e+00  4.280000e-01  8.350000e-01  1.500000e-01 
 9.600000e-02 1.798346e-02  9.772641e-02  1.710100e+01  3.420000e+00  4.523000e+00  4.150000e-01  8.870000e-01  2.040000e-01 
 6.100000e-02 -8.017487e-02  5.610933e-02  1.325100e+01  2.975000e+00  9.372000e+00  4.300000e-01  6.670000e-01  1.030000e-01 
 8.900000e-02 1.041501e-01  9.826936e-02  9.840000e-01  3.532000e+00  1.073500e+01  4.260000e-01  7.890000e-01  2.450000e-01 
 8.900000e-02 4.062998e-02  9.261607e-02  8.488000e+00  3.187000e+00  1.479800e+01  3.920000e-01  8.120000e-01  2.240000e-01 
 5.600000e-02 1.519666e-01  6.451013e-02  1.140500e+01  4.135000e+00  5.448000e+00  4.180000e-01  8.540000e-01  9.800000e-02 
 7.000000e-02 -2.035979e-02  6.857481e-02  1.723700e+01  4.320000e+00  1.045500e+01  3.830000e-01  5.390000e-01  1.460000e-01 
 9.700000e-02 -1.370080e-01  8.371023e-02  7.907000e+00  2.613000e+00  8.150000e+00  4.090000e-01  6.350000e-01  2.500000e-01 
 7.100000e-02 -8.229705e-02  6.515691e-02  4.045000e+00  4.756000e+00  1.250900e+01  4.210000e-01  8.220000e-01  1.410000e-01 
 8.400000e-02 1.029167e-01  9.264500e-02  3.369000e+00  2.910000e+00  6.001000e+00  3.860000e-01  5.470000e-01  2.330000e-01 
 1.050000e-01 -1.385039e-01  9.045709e-02  1.887800e+01  4.709000e+00  1.003100e+01  4.020000e-01  8.420000e-01  2.390000e-01 
 8.500000e-02 -9.305858e-02  7.709002e-02  3.085000e+00  2.415000e+00  1.432900e+01  4.170000e-01  7.570000e-01  1.800000e-01 
 7.000000e-02 9.271102e-02  7.648977e-02  1.000000e+01  4.210000e+00  1.168100e+01  3.990000e-01  8.940000e-01  1.770000e-01 
 6.000000e-02 -6.161128e-02  5.630332e-02  3.673000e+00  3.243000e+00  7.848000e+00  4.010000e-01  7.380000e-01  1.000000e-01 
 4.500000e-02 1.011683e-01  4.955257e-02  9.761000e+00  2.284000e+00  1.294000e+01  4.250000e-01  5.530000e-01  7.400000e-02 
 7.700000e-02 1.608419e-02  7.823848e-02  1.191600e+01  4.047000e+00  1.500000e+01  4.090000e-01  6.550000e-01  1.940000e-01 
 3.900000e-02 -7.573114e-02  3.604649e-02  1.437900e+01  3.985000e+00  8.480000e+00  4.000000e-01  5.070000e-01  6.100000e-02 
 3.600000e-02 6.374937e-02  3.829498e-02  1.676500e+01  2.824000e+00  1.109100e+01  3.960000e-01  8.090000e-01  5.500000e-02 
 3.600000e-02 1.350087e-01  4.086031e-02  6.325000e+00  4.627000e+00  4.891000e+00  4.150000e-01  5.670000e-01  5.200000e-02 
 6.600000e-02 -3.214274e-02  6.387858e-02  1.826000e+01  3.590000e+00  5.835000e+00  3.850000e-01  8.300000e-01  1.190000e-01 
 9.100000e-02 1.223841e-02  9.211370e-02  6.629000e+00  3.954000e+00  9.204000e+00  3.820000e-01  7.650000e-01  2.020000e-01 
 5.600000e-02 -3.040381e-02  5.429739e-02  4.740000e+00  2.209000e+00  1.326500e+01  3.880000e-01  8.500000e-01  1.080000e-01 
 7.200000e-02 3.489866e-02  7.451270e-02  1.526100e+01  2.000000e+00  8.978000e+00  4.160000e-01  7.710000e-01  1.380000e-01 
 5.100000e-02 5.142286e-02  5.362257e-02  1.455500e+01  3.687000e+00  1.398400e+01  4.270000e-01  8.750000e-01  8.800000e-02 
 5.100000e-02 1.647371e-02  5.184016e-02  2.801000e+00  3.857000e+00  3.462000e+00  4.240000e-01  7.290000e-01  7.800000e-02 
 4.900000e-02 1.947563e-02  4.995431e-02  1.239000e+00  3.388000e+00  1.191400e+01  3.960000e-01  6.490000e-01  8.300000e-02 
 9.000000e-02 -8.969756e-02  8.192722e-02  1.085500e+01  3.299000e+00  7.070000e+00  4.180000e-01  5.020000e-01  2.260000e-01 
 7.100000e-02 -1.843246e-02  6.969130e-02  6.044000e+00  3.071000e+00  9.549000e+00  4.040000e-01  9.000000e-01  1.640000e-01 
 8.100000e-02 8.064738e-03  8.165324e-02  1.390700e+01  2.335000e+00  8.320000e+00  3.840000e-01  8.670000e-01  1.850000e-01 
 6.300000e-02 -9.154195e-03  6.242329e-02  1.251800e+01  4.217000e+00  1.163600e+01  4.200000e-01  5.820000e-01  1.210000e-01 
 7.200000e-02 4.711916e-03  7.233926e-02  4.880000e-01  2.759000e+00  9.986000e+00  4.130000e-01  5.900000e-01  1.510000e-01 
 8.500000e-02 2.895347e-02  8.746105e-02  9.048000e+00  4.936000e+00  8.652000e+00  4.280000e-01  6.120000e-01  2.090000e-01 
 7.000000e-02 -6.145558e-02  6.569811e-02  8.465000e+00  5.000000e+00  6.484000e+00  4.080000e-01  8.010000e-01  1.240000e-01 
 6.600000e-02 6.965047e-04  6.604597e-02  1.553500e+01  3.102000e+00  3.604000e+00  4.110000e-01  5.280000e-01  1.110000e-01 
 6.600000e-02 7.530570e-02  7.097018e-02  2.054000e+00  4.867000e+00  1.358200e+01  4.040000e-01  5.260000e-01  1.730000e-01 
 3.200000e-02 5.796820e-02  3.385498e-02  1.060200e+01  3.459000e+00  9.715000e+00  3.890000e-01  7.010000e-01  5.100000e-02 
 7.500000e-02 4.435486e-02  7.832661e-02  1.360500e+01  2.576000e+00  1.390000e+01  3.980000e-01  5.710000e-01  2.060000e-01 
 7.300000e-02 -1.349469e-02  7.201489e-02  1.160900e+01  3.016000e+00  1.231200e+01  3.800000e-01  7.210000e-01  1.580000e-01 
 6.300000e-02 -3.140848e-02  6.102127e-02  7.037000e+00  2.023000e+00  1.095300e+01  3.930000e-01  5.180000e-01  1.270000e-01 
 5.100000e-02 -2.558826e-02  4.969500e-02  5.675000e+00  4.590000e+00  1.442900e+01  3.850000e-01  6.160000e-01  9.500000e-02 
 4.800000e-02 -4.225698e-02  4.597167e-02  1.304300e+01  4.896000e+00  7.428000e+00  3.910000e-01  7.830000e-01  8.100000e-02 
 4.500000e-02 -4.694911e-02  4.288729e-02  9.145000e+00  2.669000e+00  4.143000e+00  3.820000e-01  6.280000e-01  7.100000e-02 
 8.300000e-02 9.193695e-04  8.307631e-02  1.962300e+01  3.709000e+00  7.666000e+00  4.220000e-01  5.570000e-01  1.830000e-01 
 1.030000e-01 -1.000563e-01  9.269420e-02  2.471000e+00  4.382000e+00  6.845000e+00  3.940000e-01  8.650000e-01  2.130000e-01 
 5.400000e-02 9.221843e-02  5.897980e-02  1.789100e+01  2.141000e+00  6.725000e+00  4.030000e-01  6.070000e-01  9.200000e-02 
 9.100000e-02 1.417498e-01  1.038992e-01  1.242500e+01  2.239000e+00  3.184000e+00  4.050000e-01  7.970000e-01  2.400000e-01 
 9.800000e-02 -4.810786e-02  9.328543e-02  1.753900e+01  2.721000e+00  1.213800e+01  4.230000e-01  7.310000e-01  2.180000e-01 
 8.900000e-02 1.854180e-02  9.065022e-02  4.842000e+00  4.283000e+00  1.126100e+01  4.120000e-01  6.770000e-01  2.310000e-01 
 7.900000e-02 9.650122e-03  7.976236e-02  4.442000e+00  3.630000e+00  3.001000e+00  3.990000e-01  5.790000e-01  1.910000e-01 
 8.100000e-02 -3.151811e-03  8.074470e-02  1.641500e+01  4.548000e+00  6.214000e+00  4.250000e-01  6.390000e-01  1.650000e-01 
 6.000000e-02 9.025554e-02  6.541533e-02  7.702000e+00  3.801000e+00  1.024400e+01  4.060000e-01  7.150000e-01  1.160000e-01 
 9.400000e-02 -1.317810e-02  9.276126e-02  1.508500e+01  4.812000e+00  3.750000e+00  3.870000e-01  7.100000e-01  2.220000e-01 
 7.600000e-02 3.752313e-02  7.885176e-02  1.030400e+01  4.494000e+00  4.357000e+00  3.970000e-01  7.450000e-01  1.560000e-01 
 8.400000e-02 1.481898e-01  9.644795e-02  1.586100e+01  3.824000e+00  1.286300e+01  3.900000e-01  6.010000e-01  2.490000e-01 
 4.400000e-02 -7.697835e-02  4.061295e-02  1.844900e+01  4.450000e+00  1.332700e+01  4.130000e-01  7.590000e-01  6.700000e-02 
 9.100000e-02 4.736352e-03  9.143101e-02  5.284000e+00  2.075000e+00  5.654000e+00  4.210000e-01  6.900000e-01  1.960000e-01 
 6.900000e-02 1.106279e-02  6.976333e-02  5.800000e-01  4.081000e+00  5.259000e+00  3.890000e-01  6.630000e-01  1.330000e-01 
 6.600000e-02 -5.443307e-02  6.240742e-02  1.999800e+01  3.268000e+00  1.472500e+01  4.070000e-01  6.890000e-01  1.330000e-01 
 4.100000e-02 -4.215267e-02  3.927174e-02  1.759000e+00  2.531000e+00  7.351000e+00  4.100000e-01  8.850000e-01  6.100000e-02 
 8.600000e-02 -5.429867e-02  8.133031e-02  1.930200e+01  2.481000e+00  4.941000e+00  3.940000e-01  6.760000e-01  1.700000e-01 
];
AA = B(:,1);
BB = B(:,2);
CC = B(:,3);
subplot(1,2,1),plot(AA, BB, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Normalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Normalized Error','FontWeight','bold','FontSize',12)
subplot(1,2,2),plot(AA,BB.*AA, '*','markerSize',12);
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
title('Unnormalized Error Analysis','FontWeight','bold','FontSize',12)
xlabel('Actual Data','FontWeight','bold','FontSize',12)
ylabel('Error','FontWeight','bold','FontSize',12)
figure(3)
for ii = 1 : 6
  XX = B(:,3+ii);
  plot(XX, BB.*AA, '*','markerSize',12);
  disp(['Error vs Input ' int2str(ii)])
  disp('Press enter to continue')
set(gca,'linewidth',2)
set(gca,'fontweight','bold')
set(gca,'fontsize',12)
grid on
box on
  xlabel(['Input ' int2str(ii)])
ylabel('Error','FontWeight','bold','FontSize',12)
  pause
end;
end;
%print -djpeg R42_mcmc2.jpg
h4=gcf;
set(h4, 'Position', [10 10 1400 900]) %900 600])
Grapfilname='R2_GPM10_60F_RSFA_CV_err.pdf';
set(h4,'PaperSize',[18.5 12.25]); %set the paper size to what you want  
print(h4,Grapfilname,'-dpdf','-fillpage') % then print it   '-bestfit'