{
  "response surface": {
    "type": "Node",
    "name": "Response Surface",
    "uniquename": "response surface",
    "pos": [
      4453.0,
      4721.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 1e-10,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "DP2",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            61.21880634,
            4.262878501,
            60.81054431,
            0.499348062,
            0.909726256
          ],
          [
            53.34763364,
            4.931477888,
            72.77874051,
            0.409211076,
            0.918145286
          ],
          [
            5.102686031,
            3.4398486,
            93.35037663,
            0.462908833,
            0.851539131
          ],
          [
            33.70707689,
            2.819421215,
            37.58707601,
            0.479431133,
            0.969992997
          ],
          [
            78.08006601,
            3.656785791,
            84.69799328,
            0.430834558,
            0.873881682
          ],
          [
            32.43023978,
            4.704924664,
            64.48838734,
            0.492986787,
            0.939338369
          ],
          [
            23.2093467,
            3.518447135,
            94.55723957,
            0.418258617,
            0.930479239
          ],
          [
            70.94454478,
            4.619135147,
            46.8785792,
            0.415037206,
            0.913484793
          ],
          [
            99.8311867,
            4.448630455,
            87.86291569,
            0.440843112,
            0.941049886
          ],
          [
            76.65922655,
            2.915134034,
            50.49046706,
            0.447855924,
            0.925542137
          ],
          [
            62.71676835,
            3.133976077,
            83.991381,
            0.434715069,
            0.922026751
          ],
          [
            98.59184662,
            4.212352394,
            46.25009075,
            0.474253819,
            0.963656646
          ],
          [
            14.62568546,
            2.71492271,
            32.42302105,
            0.453197495,
            0.943424892
          ],
          [
            3.877362564,
            2.99661721,
            67.00241906,
            0.484354692,
            0.913909144
          ],
          [
            70.05595611,
            3.352659997,
            27.32534869,
            0.487058262,
            0.965582943
          ],
          [
            17.36440685,
            2.929067762,
            12.61316337,
            0.412457359,
            0.867236988
          ],
          [
            40.47507954,
            2.362965774,
            45.16373767,
            0.487734543,
            0.926916091
          ],
          [
            19.95830274,
            4.289271126,
            17.03937601,
            0.444349288,
            0.920627189
          ],
          [
            13.53759665,
            3.301314215,
            18.90895094,
            0.498474244,
            0.877812106
          ],
          [
            10.50921564,
            4.791995856,
            49.9082724,
            0.407143493,
            0.974857375
          ],
          [
            37.73489649,
            4.976989873,
            96.64999579,
            0.485929347,
            0.85516888
          ],
          [
            14.18935204,
            4.113317145,
            69.1288039,
            0.419830257,
            0.893579811
          ],
          [
            66.87664981,
            2.069260922,
            94.26373231,
            0.443474457,
            0.878680137
          ],
          [
            86.996885,
            2.250854203,
            35.04201095,
            0.498058143,
            0.977642382
          ],
          [
            52.72592183,
            3.813968264,
            81.4600772,
            0.446088462,
            0.956025751
          ],
          [
            51.32769905,
            4.004029483,
            54.28798174,
            0.433602346,
            0.969227511
          ],
          [
            57.04304776,
            3.532902387,
            63.69520567,
            0.423857397,
            0.880069118
          ],
          [
            82.3906655,
            3.273833241,
            75.17729197,
            0.460220375,
            0.951808325
          ],
          [
            87.75644195,
            3.561471042,
            15.13399255,
            0.48233004,
            0.940007252
          ],
          [
            21.72888171,
            3.252789924,
            43.03239405,
            0.43720469,
            0.858746117
          ],
          [
            25.18845912,
            4.836982355,
            83.4992026,
            0.400256146,
            0.859910971
          ],
          [
            6.608334644,
            3.890709242,
            36.35965228,
            0.417190418,
            0.953538315
          ],
          [
            32.77445723,
            2.232685742,
            14.67819122,
            0.434009466,
            0.892421092
          ],
          [
            26.32309421,
            4.084416941,
            26.26558503,
            0.485198793,
            0.901439246
          ],
          [
            85.13941839,
            3.083279177,
            90.74637004,
            0.425110351,
            0.97122607
          ],
          [
            84.19555048,
            3.838844326,
            53.57879084,
            0.488890217,
            0.919355423
          ],
          [
            55.28236953,
            4.135607911,
            13.90179607,
            0.465899719,
            0.860791333
          ],
          [
            11.4838616,
            3.737969367,
            48.06343754,
            0.449500675,
            0.904152492
          ],
          [
            15.97031566,
            4.346232721,
            58.62551175,
            0.481407645,
            0.979909193
          ],
          [
            94.04615889,
            3.948270081,
            33.72215299,
            0.492173394,
            0.871097122
          ],
          [
            96.19004642,
            3.749371582,
            11.36309691,
            0.435500179,
            0.975824308
          ],
          [
            29.35775317,
            3.0157794,
            23.84495987,
            0.407899178,
            0.956977833
          ],
          [
            49.76091425,
            4.567552226,
            22.42156083,
            0.496406428,
            0.925741448
          ],
          [
            73.95808097,
            2.333362996,
            18.15585485,
            0.458527809,
            0.968027679
          ],
          [
            81.95320227,
            4.37487997,
            29.72628243,
            0.421686632,
            0.86406645
          ],
          [
            79.0809101,
            2.037578253,
            42.48098119,
            0.400946368,
            0.942293915
          ],
          [
            91.12207426,
            4.540533211,
            41.16099369,
            0.459596973,
            0.894900724
          ],
          [
            24.15970508,
            2.777853171,
            64.84615141,
            0.462305693,
            0.896120069
          ],
          [
            30.28649217,
            4.458262093,
            51.77921064,
            0.455050754,
            0.87329627
          ],
          [
            3.365043799,
            4.041614995,
            98.12293161,
            0.40374506,
            0.928623373
          ],
          [
            71.63257962,
            2.738978065,
            87.56616436,
            0.494707362,
            0.862793109
          ],
          [
            63.10700067,
            4.499191919,
            68.10931761,
            0.490098729,
            0.972422692
          ],
          [
            75.66498466,
            2.658416988,
            70.20967576,
            0.404742279,
            0.960377955
          ],
          [
            9.333128233,
            2.395337083,
            86.04736497,
            0.489371835,
            0.95441348
          ],
          [
            44.81111083,
            2.507687854,
            67.2953895,
            0.438311914,
            0.947223351
          ],
          [
            31.03747767,
            3.398102063,
            31.46848032,
            0.426589288,
            0.915069031
          ],
          [
            38.09103413,
            3.321065433,
            57.80031591,
            0.442121479,
            0.935107776
          ],
          [
            39.57050736,
            3.585908895,
            21.54398288,
            0.45173729,
            0.86874655
          ],
          [
            92.40683208,
            4.886788622,
            19.79847377,
            0.429868807,
            0.957635267
          ],
          [
            64.80775472,
            3.048416148,
            35.65879182,
            0.464534859,
            0.907328376
          ],
          [
            65.82037812,
            3.924224018,
            95.76731423,
            0.471005896,
            0.946761985
          ],
          [
            79.54523309,
            4.0637586,
            65.92532027,
            0.450208933,
            0.85685082
          ],
          [
            59.68805826,
            2.800278388,
            15.91446678,
            0.420033959,
            0.938160689
          ],
          [
            26.15060383,
            2.106067358,
            60.66298971,
            0.426158336,
            0.962886282
          ],
          [
            96.81070638,
            3.460008032,
            79.20528559,
            0.4939135,
            0.899547226
          ],
          [
            47.2215095,
            4.327887169,
            28.55812488,
            0.461430933,
            0.936684687
          ],
          [
            27.95531719,
            2.490514073,
            98.92017949,
            0.448725209,
            0.973821936
          ],
          [
            97.40890642,
            2.444626801,
            26.60360589,
            0.411391801,
            0.922385495
          ],
          [
            54.38874185,
            2.553988224,
            40.31855016,
            0.428426637,
            0.903003977
          ],
          [
            46.49973228,
            2.958472785,
            79.66223689,
            0.470082938,
            0.977103144
          ],
          [
            48.73490918,
            3.15523774,
            48.60827305,
            0.478007072,
            0.865731035
          ],
          [
            1.048717394,
            2.695975992,
            45.7302038,
            0.421979464,
            0.887374104
          ],
          [
            41.7450197,
            3.87122224,
            70.87790691,
            0.467934303,
            0.885279436
          ],
          [
            59.34477438,
            3.49951044,
            44.21477236,
            0.456258633,
            0.958790766
          ],
          [
            6.282984691,
            4.607761099,
            73.83084385,
            0.427629674,
            0.869180508
          ],
          [
            65.71352522,
            2.433910575,
            52.59469807,
            0.418104873,
            0.858163313
          ],
          [
            35.09786259,
            3.978209694,
            86.71560699,
            0.457453568,
            0.912630873
          ],
          [
            68.23387506,
            3.775980076,
            19.959749,
            0.406033367,
            0.895006337
          ],
          [
            12.62657793,
            2.57856187,
            82.37514895,
            0.476934557,
            0.934249859
          ],
          [
            85.98685994,
            4.953819828,
            57.2310843,
            0.438133743,
            0.900335824
          ],
          [
            88.48079365,
            4.298344127,
            80.43898657,
            0.408272548,
            0.882043568
          ],
          [
            21.09345376,
            4.891515959,
            38.8928683,
            0.471899249,
            0.88076735
          ],
          [
            28.31575285,
            3.67719602,
            73.81781755,
            0.474665639,
            0.923559774
          ],
          [
            19.70434601,
            3.625325706,
            51.2797987,
            0.495902602,
            0.949237456
          ],
          [
            40.66580343,
            4.516102241,
            10.61443607,
            0.423119701,
            0.94929826
          ],
          [
            89.8171221,
            2.645436262,
            96.80315357,
            0.454380257,
            0.910291353
          ],
          [
            56.00329188,
            2.131693766,
            31.20578257,
            0.475644881,
            0.950967033
          ],
          [
            35.22777832,
            2.614151254,
            56.51128401,
            0.403615878,
            0.876736518
          ],
          [
            93.52522508,
            2.856151176,
            71.45807517,
            0.445414182,
            0.854243539
          ],
          [
            69.2525305,
            4.834687505,
            78.55581938,
            0.452233315,
            0.929667066
          ],
          [
            7.327706725,
            2.010938158,
            20.87033273,
            0.469680214,
            0.91720859
          ],
          [
            18.44863893,
            4.65193354,
            89.98742569,
            0.465113842,
            0.962186779
          ],
          [
            45.21129545,
            3.710736761,
            39.51867624,
            0.410287725,
            0.8530919
          ],
          [
            90.81448374,
            3.197731707,
            61.71620543,
            0.413096195,
            0.945625494
          ],
          [
            42.86379467,
            3.219203426,
            92.51970374,
            0.402258249,
            0.906000696
          ],
          [
            57.8759597,
            2.277643024,
            75.46874375,
            0.483159345,
            0.872417018
          ],
          [
            17.15824056,
            2.32335941,
            76.52178744,
            0.432190098,
            0.908980324
          ],
          [
            2.73762426,
            2.148345147,
            62.74639872,
            0.456576092,
            0.864883475
          ],
          [
            94.73970703,
            2.205012856,
            55.61336736,
            0.466458088,
            0.93205323
          ],
          [
            8.442301598,
            3.093211926,
            28.84001308,
            0.440957025,
            0.883578881
          ],
          [
            83.7924221,
            2.531070507,
            23.99523305,
            0.46871849,
            0.875288232
          ],
          [
            43.58022484,
            4.765031996,
            34.53194921,
            0.446439536,
            0.888967251
          ],
          [
            36.59381966,
            4.195619154,
            77.80961188,
            0.413780682,
            0.966487323
          ],
          [
            80.57112614,
            4.730390366,
            12.11768373,
            0.478312984,
            0.904647955
          ],
          [
            72.35653028,
            3.387894714,
            59.11914031,
            0.473083649,
            0.891133202
          ],
          [
            73.0529704,
            4.175050313,
            38.3620959,
            0.431538681,
            0.933795272
          ],
          [
            62.05828347,
            4.699308952,
            25.44084878,
            0.439358871,
            0.851047798
          ],
          [
            47.83156185,
            2.180044477,
            89.01146673,
            0.416248644,
            0.898052733
          ],
          [
            51.54817238,
            2.877536102,
            99.78503607,
            0.491311468,
            0.889347856
          ],
          [
            75.95991457,
            4.422615552,
            91.66911956,
            0.480188932,
            0.885591267
          ]
        ],
        [
          529.266324,
          782.174704,
          723.197424,
          572.729328,
          735.053356,
          545.34572,
          768.459432,
          772.202764,
          731.79602,
          719.749644,
          735.788036,
          594.517744,
          695.422384,
          589.907192,
          548.697992,
          765.63538,
          564.200928,
          729.534736,
          557.300108,
          785.39612,
          590.431972,
          763.888672,
          730.937676,
          499.058284,
          718.085976,
          739.58918,
          742.061472,
          657.268028,
          583.409208,
          732.050044,
          788.067844,
          773.109316,
          734.785696,
          599.59636,
          749.813608,
          565.356876,
          698.394052,
          725.094968,
          563.67498,
          563.730364,
          731.167412,
          788.572756,
          547.585172,
          658.604408,
          742.171104,
          772.18748,
          701.498036,
          670.898668,
          718.146168,
          800.082836,
          527.95548,
          531.985964,
          780.435784,
          544.958768,
          734.002324,
          747.593636,
          733.9474,
          720.4414,
          744.703576,
          654.88506,
          616.319148,
          724.1387,
          755.678256,
          749.072832,
          543.20162,
          659.6107,
          693.617864,
          762.034728,
          739.84428,
          613.44152,
          616.466228,
          764.80182,
          658.002664,
          675.497768,
          749.485924,
          739.241112,
          688.325268,
          772.753372,
          604.168408,
          733.93656,
          758.26494,
          650.19998,
          621.82724,
          528.786384,
          757.106728,
          693.716252,
          595.974292,
          766.062444,
          729.986464,
          700.207168,
          642.772732,
          635.689352,
          752.445592,
          766.268432,
          785.408016,
          577.57348,
          736.698588,
          725.12668,
          631.879384,
          732.232312,
          648.748244,
          725.812396,
          777.305616,
          620.304056,
          622.691224,
          739.876544,
          731.701216,
          751.652,
          547.736476,
          601.783188
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "/Users/esma/ALPEMI/UQ_Study/COMPTOOLKITS_SA/Nodeworks/C2",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 282,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "sensitivity analysis": {
    "type": "Node",
    "name": "Sensitivity Analysis",
    "uniquename": "sensitivity analysis",
    "pos": [
      5078.0,
      5128.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.008165925269167037,
          0.002495647173578846,
          0.0012665916888516978,
          0.9557264524512551,
          0.0093450389083189
        ],
        "S1_conf": [
          0.0030074354807515173,
          0.0028299869074040213,
          0.002300460101142992,
          0.019241841211386522,
          0.004929523471414216
        ],
        "ST": [
          0.013156463845976286,
          0.011910268087898204,
          0.008298372952107282,
          0.9781409577451154,
          0.031033127563720942
        ],
        "ST_conf": [
          0.0007650302538073853,
          0.0006777012278800316,
          0.00036169966995047606,
          0.01820429513574361,
          0.0013431511080638425
        ],
        "S2": [
          [
            NaN,
            -0.0045935881318641715,
            -0.005206809169427085,
            -0.0047766067724428485,
            -0.004023058137673372
          ],
          [
            NaN,
            NaN,
            -0.00022871876406266116,
            0.0011249204568766213,
            0.0006977928187861613
          ],
          [
            NaN,
            NaN,
            NaN,
            9.746169541513527e-05,
            0.00044876436473669304
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.012534092995972905
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.0045633429149917705,
            0.00454396191809874,
            0.005679509162261855,
            0.004539288386991407
          ],
          [
            NaN,
            NaN,
            0.0039731540981344906,
            0.005073478365091874,
            0.003988672098865856
          ],
          [
            NaN,
            NaN,
            NaN,
            0.0037524507905323553,
            0.0035788206455100477
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.026509855698831197
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 2,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 283,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "parallel coordinates plot": {
    "type": "Node",
    "name": "Parallel Coordinates Plot",
    "uniquename": "parallel coordinates plot",
    "pos": [
      5077.0,
      4687.0
    ],
    "path": [
      "matplotlib",
      "Parallel Coordinates Plot"
    ],
    "terminals": {
      "table": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "value": [],
          "name": "table"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "bezier": true,
      "color": "Kmeans",
      "alpha": 0.5,
      "clusters": 2,
      "labels": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5",
        "DP2"
      ]
    },
    "layer": 70,
    "geometry": [
      505.0,
      406.0
    ]
  },
  "code": {
    "type": "Node",
    "name": "Write sensitivities",
    "uniquename": "code",
    "pos": [
      5632.0,
      5236.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "sens1, sens2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "name": "returnOut"
        }
      },
      "sens1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens1"
        }
      },
      "sens2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens2"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "import os\n\nSAVE_DIR = r'C:\\Users\\onlyj\\Documents\\nodeworks_projects\\C2'\nFNAME = 'C2_Nodeworks_SA_y1dP2.csv'\n\nT1 = sens1.get('ST')\nS1 = sens1.get('ST_conf')\n\nT2 = sens2.get('ST')\nS2 = sens2.get('ST_conf')\n\nvar_list = [\n    \"t1:P_0\", \"t2:beta\", \"t3:StatWeight\", \"t4:ep_g\", \"t5:VelfacCoeff\"\n    ]\n\nwith open(os.path.join(SAVE_DIR, FNAME), 'w') as f:\n    f.write(\"UQTool,Params,Sobol_mean,Sobol_std\\n\")\n    \n    for v, t, s in zip(var_list, T1, S1):\n        f.write(f\"Nodeworks (GPM),{v},{t},{s}\\n\")\n\n    for v, t, s in zip(var_list, T2, S2):\n        f.write(f\"Nodeworks (GPM Tuned),{v},{t},{s}\\n\")\n\n\nreturnOut = None"
    },
    "layer": 265,
    "geometry": [
      574.0,
      401.0
    ]
  },
  "response surface.0": {
    "type": "Node",
    "name": "Response Surface Tuned",
    "uniquename": "response surface.0",
    "pos": [
      4456.0,
      5368.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 0.01,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": false,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 2,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "DP2",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            61.21880634,
            4.262878501,
            60.81054431,
            0.499348062,
            0.909726256
          ],
          [
            53.34763364,
            4.931477888,
            72.77874051,
            0.409211076,
            0.918145286
          ],
          [
            5.102686031,
            3.4398486,
            93.35037663,
            0.462908833,
            0.851539131
          ],
          [
            33.70707689,
            2.819421215,
            37.58707601,
            0.479431133,
            0.969992997
          ],
          [
            78.08006601,
            3.656785791,
            84.69799328,
            0.430834558,
            0.873881682
          ],
          [
            32.43023978,
            4.704924664,
            64.48838734,
            0.492986787,
            0.939338369
          ],
          [
            23.2093467,
            3.518447135,
            94.55723957,
            0.418258617,
            0.930479239
          ],
          [
            70.94454478,
            4.619135147,
            46.8785792,
            0.415037206,
            0.913484793
          ],
          [
            99.8311867,
            4.448630455,
            87.86291569,
            0.440843112,
            0.941049886
          ],
          [
            76.65922655,
            2.915134034,
            50.49046706,
            0.447855924,
            0.925542137
          ],
          [
            62.71676835,
            3.133976077,
            83.991381,
            0.434715069,
            0.922026751
          ],
          [
            98.59184662,
            4.212352394,
            46.25009075,
            0.474253819,
            0.963656646
          ],
          [
            14.62568546,
            2.71492271,
            32.42302105,
            0.453197495,
            0.943424892
          ],
          [
            3.877362564,
            2.99661721,
            67.00241906,
            0.484354692,
            0.913909144
          ],
          [
            70.05595611,
            3.352659997,
            27.32534869,
            0.487058262,
            0.965582943
          ],
          [
            17.36440685,
            2.929067762,
            12.61316337,
            0.412457359,
            0.867236988
          ],
          [
            40.47507954,
            2.362965774,
            45.16373767,
            0.487734543,
            0.926916091
          ],
          [
            19.95830274,
            4.289271126,
            17.03937601,
            0.444349288,
            0.920627189
          ],
          [
            13.53759665,
            3.301314215,
            18.90895094,
            0.498474244,
            0.877812106
          ],
          [
            10.50921564,
            4.791995856,
            49.9082724,
            0.407143493,
            0.974857375
          ],
          [
            37.73489649,
            4.976989873,
            96.64999579,
            0.485929347,
            0.85516888
          ],
          [
            14.18935204,
            4.113317145,
            69.1288039,
            0.419830257,
            0.893579811
          ],
          [
            66.87664981,
            2.069260922,
            94.26373231,
            0.443474457,
            0.878680137
          ],
          [
            86.996885,
            2.250854203,
            35.04201095,
            0.498058143,
            0.977642382
          ],
          [
            52.72592183,
            3.813968264,
            81.4600772,
            0.446088462,
            0.956025751
          ],
          [
            51.32769905,
            4.004029483,
            54.28798174,
            0.433602346,
            0.969227511
          ],
          [
            57.04304776,
            3.532902387,
            63.69520567,
            0.423857397,
            0.880069118
          ],
          [
            82.3906655,
            3.273833241,
            75.17729197,
            0.460220375,
            0.951808325
          ],
          [
            87.75644195,
            3.561471042,
            15.13399255,
            0.48233004,
            0.940007252
          ],
          [
            21.72888171,
            3.252789924,
            43.03239405,
            0.43720469,
            0.858746117
          ],
          [
            25.18845912,
            4.836982355,
            83.4992026,
            0.400256146,
            0.859910971
          ],
          [
            6.608334644,
            3.890709242,
            36.35965228,
            0.417190418,
            0.953538315
          ],
          [
            32.77445723,
            2.232685742,
            14.67819122,
            0.434009466,
            0.892421092
          ],
          [
            26.32309421,
            4.084416941,
            26.26558503,
            0.485198793,
            0.901439246
          ],
          [
            85.13941839,
            3.083279177,
            90.74637004,
            0.425110351,
            0.97122607
          ],
          [
            84.19555048,
            3.838844326,
            53.57879084,
            0.488890217,
            0.919355423
          ],
          [
            55.28236953,
            4.135607911,
            13.90179607,
            0.465899719,
            0.860791333
          ],
          [
            11.4838616,
            3.737969367,
            48.06343754,
            0.449500675,
            0.904152492
          ],
          [
            15.97031566,
            4.346232721,
            58.62551175,
            0.481407645,
            0.979909193
          ],
          [
            94.04615889,
            3.948270081,
            33.72215299,
            0.492173394,
            0.871097122
          ],
          [
            96.19004642,
            3.749371582,
            11.36309691,
            0.435500179,
            0.975824308
          ],
          [
            29.35775317,
            3.0157794,
            23.84495987,
            0.407899178,
            0.956977833
          ],
          [
            49.76091425,
            4.567552226,
            22.42156083,
            0.496406428,
            0.925741448
          ],
          [
            73.95808097,
            2.333362996,
            18.15585485,
            0.458527809,
            0.968027679
          ],
          [
            81.95320227,
            4.37487997,
            29.72628243,
            0.421686632,
            0.86406645
          ],
          [
            79.0809101,
            2.037578253,
            42.48098119,
            0.400946368,
            0.942293915
          ],
          [
            91.12207426,
            4.540533211,
            41.16099369,
            0.459596973,
            0.894900724
          ],
          [
            24.15970508,
            2.777853171,
            64.84615141,
            0.462305693,
            0.896120069
          ],
          [
            30.28649217,
            4.458262093,
            51.77921064,
            0.455050754,
            0.87329627
          ],
          [
            3.365043799,
            4.041614995,
            98.12293161,
            0.40374506,
            0.928623373
          ],
          [
            71.63257962,
            2.738978065,
            87.56616436,
            0.494707362,
            0.862793109
          ],
          [
            63.10700067,
            4.499191919,
            68.10931761,
            0.490098729,
            0.972422692
          ],
          [
            75.66498466,
            2.658416988,
            70.20967576,
            0.404742279,
            0.960377955
          ],
          [
            9.333128233,
            2.395337083,
            86.04736497,
            0.489371835,
            0.95441348
          ],
          [
            44.81111083,
            2.507687854,
            67.2953895,
            0.438311914,
            0.947223351
          ],
          [
            31.03747767,
            3.398102063,
            31.46848032,
            0.426589288,
            0.915069031
          ],
          [
            38.09103413,
            3.321065433,
            57.80031591,
            0.442121479,
            0.935107776
          ],
          [
            39.57050736,
            3.585908895,
            21.54398288,
            0.45173729,
            0.86874655
          ],
          [
            92.40683208,
            4.886788622,
            19.79847377,
            0.429868807,
            0.957635267
          ],
          [
            64.80775472,
            3.048416148,
            35.65879182,
            0.464534859,
            0.907328376
          ],
          [
            65.82037812,
            3.924224018,
            95.76731423,
            0.471005896,
            0.946761985
          ],
          [
            79.54523309,
            4.0637586,
            65.92532027,
            0.450208933,
            0.85685082
          ],
          [
            59.68805826,
            2.800278388,
            15.91446678,
            0.420033959,
            0.938160689
          ],
          [
            26.15060383,
            2.106067358,
            60.66298971,
            0.426158336,
            0.962886282
          ],
          [
            96.81070638,
            3.460008032,
            79.20528559,
            0.4939135,
            0.899547226
          ],
          [
            47.2215095,
            4.327887169,
            28.55812488,
            0.461430933,
            0.936684687
          ],
          [
            27.95531719,
            2.490514073,
            98.92017949,
            0.448725209,
            0.973821936
          ],
          [
            97.40890642,
            2.444626801,
            26.60360589,
            0.411391801,
            0.922385495
          ],
          [
            54.38874185,
            2.553988224,
            40.31855016,
            0.428426637,
            0.903003977
          ],
          [
            46.49973228,
            2.958472785,
            79.66223689,
            0.470082938,
            0.977103144
          ],
          [
            48.73490918,
            3.15523774,
            48.60827305,
            0.478007072,
            0.865731035
          ],
          [
            1.048717394,
            2.695975992,
            45.7302038,
            0.421979464,
            0.887374104
          ],
          [
            41.7450197,
            3.87122224,
            70.87790691,
            0.467934303,
            0.885279436
          ],
          [
            59.34477438,
            3.49951044,
            44.21477236,
            0.456258633,
            0.958790766
          ],
          [
            6.282984691,
            4.607761099,
            73.83084385,
            0.427629674,
            0.869180508
          ],
          [
            65.71352522,
            2.433910575,
            52.59469807,
            0.418104873,
            0.858163313
          ],
          [
            35.09786259,
            3.978209694,
            86.71560699,
            0.457453568,
            0.912630873
          ],
          [
            68.23387506,
            3.775980076,
            19.959749,
            0.406033367,
            0.895006337
          ],
          [
            12.62657793,
            2.57856187,
            82.37514895,
            0.476934557,
            0.934249859
          ],
          [
            85.98685994,
            4.953819828,
            57.2310843,
            0.438133743,
            0.900335824
          ],
          [
            88.48079365,
            4.298344127,
            80.43898657,
            0.408272548,
            0.882043568
          ],
          [
            21.09345376,
            4.891515959,
            38.8928683,
            0.471899249,
            0.88076735
          ],
          [
            28.31575285,
            3.67719602,
            73.81781755,
            0.474665639,
            0.923559774
          ],
          [
            19.70434601,
            3.625325706,
            51.2797987,
            0.495902602,
            0.949237456
          ],
          [
            40.66580343,
            4.516102241,
            10.61443607,
            0.423119701,
            0.94929826
          ],
          [
            89.8171221,
            2.645436262,
            96.80315357,
            0.454380257,
            0.910291353
          ],
          [
            56.00329188,
            2.131693766,
            31.20578257,
            0.475644881,
            0.950967033
          ],
          [
            35.22777832,
            2.614151254,
            56.51128401,
            0.403615878,
            0.876736518
          ],
          [
            93.52522508,
            2.856151176,
            71.45807517,
            0.445414182,
            0.854243539
          ],
          [
            69.2525305,
            4.834687505,
            78.55581938,
            0.452233315,
            0.929667066
          ],
          [
            7.327706725,
            2.010938158,
            20.87033273,
            0.469680214,
            0.91720859
          ],
          [
            18.44863893,
            4.65193354,
            89.98742569,
            0.465113842,
            0.962186779
          ],
          [
            45.21129545,
            3.710736761,
            39.51867624,
            0.410287725,
            0.8530919
          ],
          [
            90.81448374,
            3.197731707,
            61.71620543,
            0.413096195,
            0.945625494
          ],
          [
            42.86379467,
            3.219203426,
            92.51970374,
            0.402258249,
            0.906000696
          ],
          [
            57.8759597,
            2.277643024,
            75.46874375,
            0.483159345,
            0.872417018
          ],
          [
            17.15824056,
            2.32335941,
            76.52178744,
            0.432190098,
            0.908980324
          ],
          [
            2.73762426,
            2.148345147,
            62.74639872,
            0.456576092,
            0.864883475
          ],
          [
            94.73970703,
            2.205012856,
            55.61336736,
            0.466458088,
            0.93205323
          ],
          [
            8.442301598,
            3.093211926,
            28.84001308,
            0.440957025,
            0.883578881
          ],
          [
            83.7924221,
            2.531070507,
            23.99523305,
            0.46871849,
            0.875288232
          ],
          [
            43.58022484,
            4.765031996,
            34.53194921,
            0.446439536,
            0.888967251
          ],
          [
            36.59381966,
            4.195619154,
            77.80961188,
            0.413780682,
            0.966487323
          ],
          [
            80.57112614,
            4.730390366,
            12.11768373,
            0.478312984,
            0.904647955
          ],
          [
            72.35653028,
            3.387894714,
            59.11914031,
            0.473083649,
            0.891133202
          ],
          [
            73.0529704,
            4.175050313,
            38.3620959,
            0.431538681,
            0.933795272
          ],
          [
            62.05828347,
            4.699308952,
            25.44084878,
            0.439358871,
            0.851047798
          ],
          [
            47.83156185,
            2.180044477,
            89.01146673,
            0.416248644,
            0.898052733
          ],
          [
            51.54817238,
            2.877536102,
            99.78503607,
            0.491311468,
            0.889347856
          ],
          [
            75.95991457,
            4.422615552,
            91.66911956,
            0.480188932,
            0.885591267
          ]
        ],
        [
          529.266324,
          782.174704,
          723.197424,
          572.729328,
          735.053356,
          545.34572,
          768.459432,
          772.202764,
          731.79602,
          719.749644,
          735.788036,
          594.517744,
          695.422384,
          589.907192,
          548.697992,
          765.63538,
          564.200928,
          729.534736,
          557.300108,
          785.39612,
          590.431972,
          763.888672,
          730.937676,
          499.058284,
          718.085976,
          739.58918,
          742.061472,
          657.268028,
          583.409208,
          732.050044,
          788.067844,
          773.109316,
          734.785696,
          599.59636,
          749.813608,
          565.356876,
          698.394052,
          725.094968,
          563.67498,
          563.730364,
          731.167412,
          788.572756,
          547.585172,
          658.604408,
          742.171104,
          772.18748,
          701.498036,
          670.898668,
          718.146168,
          800.082836,
          527.95548,
          531.985964,
          780.435784,
          544.958768,
          734.002324,
          747.593636,
          733.9474,
          720.4414,
          744.703576,
          654.88506,
          616.319148,
          724.1387,
          755.678256,
          749.072832,
          543.20162,
          659.6107,
          693.617864,
          762.034728,
          739.84428,
          613.44152,
          616.466228,
          764.80182,
          658.002664,
          675.497768,
          749.485924,
          739.241112,
          688.325268,
          772.753372,
          604.168408,
          733.93656,
          758.26494,
          650.19998,
          621.82724,
          528.786384,
          757.106728,
          693.716252,
          595.974292,
          766.062444,
          729.986464,
          700.207168,
          642.772732,
          635.689352,
          752.445592,
          766.268432,
          785.408016,
          577.57348,
          736.698588,
          725.12668,
          631.879384,
          732.232312,
          648.748244,
          725.812396,
          777.305616,
          620.304056,
          622.691224,
          739.876544,
          731.701216,
          751.652,
          547.736476,
          601.783188
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "/Users/esma/ALPEMI/UQ_Study/COMPTOOLKITS_SA/Nodeworks/C2",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 72,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "sensitivity analysis.0": {
    "type": "Node",
    "name": "Sensitivity Analysis Tuned",
    "uniquename": "sensitivity analysis.0",
    "pos": [
      5078.0,
      5523.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.00747960906769268,
          0.002785880342737006,
          0.0013045950414379993,
          0.9381094582062991,
          0.0110438523977008
        ],
        "S1_conf": [
          0.00426661559332458,
          0.004005877861608815,
          0.0034027902463533203,
          0.02397534097513857,
          0.005992554480249528
        ],
        "ST": [
          0.021544035732851366,
          0.018210339849743268,
          0.016251448628670596,
          0.9680151422164397,
          0.04307139703592104
        ],
        "ST_conf": [
          0.0010343109054272287,
          0.0010465137529563626,
          0.0007851631544807819,
          0.02142704853379132,
          0.00211907428818243
        ],
        "S2": [
          [
            NaN,
            -0.004393006225756826,
            -0.006222748175946759,
            -0.004246170763446133,
            -0.004148721417382764
          ],
          [
            NaN,
            NaN,
            0.0003975542791289691,
            0.0013246185209023764,
            0.002252748837456523
          ],
          [
            NaN,
            NaN,
            NaN,
            0.0026810724118556672,
            0.0009818669288025016
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.015195430860290609
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.006382709645114825,
            0.006467587426501717,
            0.006754785070215604,
            0.006416157712846439
          ],
          [
            NaN,
            NaN,
            0.004761678098485734,
            0.005931980324105788,
            0.004673966299574328
          ],
          [
            NaN,
            NaN,
            NaN,
            0.005612298999480943,
            0.005278437086389779
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.024851562232385577
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 2,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 280,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "read csv": {
    "type": "Node",
    "name": "Test Samples",
    "uniquename": "read csv",
    "pos": [
      4708.0,
      6048.0
    ],
    "path": [
      "pandas",
      "Read CSV"
    ],
    "terminals": {
      "file": {
        "value": "C:/Users/onlyj/Documents/nodeworks_projects/C2/C2_10new_samples.csv",
        "flipped": false,
        "opts": {
          "widget": "browse",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "file"
        }
      },
      "sep": {
        "value": ",",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "value": ",",
          "name": "sep"
        }
      },
      "parse dates": {
        "value": false,
        "flipped": false,
        "opts": {
          "widget": "checkbox",
          "in": true,
          "dtype": "<class 'bool'>",
          "name": "parse dates"
        }
      },
      "index column": {
        "value": "",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "index column"
        }
      },
      "dataframe": {
        "value": {
          "__nw_type__": "pd_frame",
          "data": "{}"
        },
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'pandas.core.frame.DataFrame'>",
          "name": "dataframe"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 255,
    "geometry": [
      193.0,
      168.0
    ]
  },
  "emulator": {
    "type": "Node",
    "name": "Emulator",
    "uniquename": "emulator",
    "pos": [
      5056.0,
      6034.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 6.92735924e-315,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 239,
    "geometry": [
      220.0,
      95.0
    ]
  },
  "emulator.0": {
    "type": "Node",
    "name": "Emulator Tuned",
    "uniquename": "emulator.0",
    "pos": [
      5058.0,
      6137.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 8.077626696367e-312,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 248,
    "geometry": [
      217.0,
      97.0
    ]
  },
  "code.0": {
    "type": "Node",
    "name": "Code",
    "uniquename": "code.0",
    "pos": [
      5345.0,
      5918.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "r1, r2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": "None",
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'str'>",
          "name": "returnOut"
        }
      },
      "r2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r2"
        }
      },
      "r1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r1"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "s_list = []\n\nfor p1, p2 in zip(r1, r2):\n    s_list.append(f'{p1},{p2}')\n    \nreturnOut = '\\n'.join(s_list)"
    },
    "layer": 253,
    "geometry": [
      400.0,
      400.0
    ]
  },
  "display": {
    "type": "Node",
    "name": "Test Sample Results",
    "uniquename": "display",
    "pos": [
      5789.0,
      5946.0
    ],
    "path": [
      "general",
      "Display"
    ],
    "terminals": {
      "input": {
        "value": null,
        "flipped": false,
        "opts": {
          "widget": "textedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "input"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 256,
    "geometry": [
      382.0,
      359.0
    ]
  },
  "connection": {
    "type": "Connection",
    "name": "connection",
    "line": "cubic",
    "uniquename": "connection",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "sensitivity analysis",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.0": {
    "type": "Connection",
    "name": "connection.0",
    "line": "cubic",
    "uniquename": "connection.0",
    "input": [
      "response surface",
      "Response matrix"
    ],
    "output": [
      "parallel coordinates plot",
      "table"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.1": {
    "type": "Connection",
    "name": "connection.1",
    "line": "cubic",
    "uniquename": "connection.1",
    "input": [
      "sensitivity analysis",
      "sensitivities"
    ],
    "output": [
      "code",
      "sens1"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.2": {
    "type": "Connection",
    "name": "connection.2",
    "line": "cubic",
    "uniquename": "connection.2",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "sensitivity analysis.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.3": {
    "type": "Connection",
    "name": "connection.3",
    "line": "cubic",
    "uniquename": "connection.3",
    "input": [
      "sensitivity analysis.0",
      "sensitivities"
    ],
    "output": [
      "code",
      "sens2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.4": {
    "type": "Connection",
    "name": "connection.4",
    "line": "cubic",
    "uniquename": "connection.4",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "emulator.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.5": {
    "type": "Connection",
    "name": "connection.5",
    "line": "cubic",
    "uniquename": "connection.5",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "emulator",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.6": {
    "type": "Connection",
    "name": "connection.6",
    "line": "cubic",
    "uniquename": "connection.6",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.7": {
    "type": "Connection",
    "name": "connection.7",
    "line": "cubic",
    "uniquename": "connection.7",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator.0",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.8": {
    "type": "Connection",
    "name": "connection.8",
    "line": "cubic",
    "uniquename": "connection.8",
    "input": [
      "emulator",
      "result"
    ],
    "output": [
      "code.0",
      "r1"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.9": {
    "type": "Connection",
    "name": "connection.9",
    "line": "cubic",
    "uniquename": "connection.9",
    "input": [
      "emulator.0",
      "result"
    ],
    "output": [
      "code.0",
      "r2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.10": {
    "type": "Connection",
    "name": "connection.10",
    "line": "cubic",
    "uniquename": "connection.10",
    "input": [
      "code.0",
      "returnOut"
    ],
    "output": [
      "display",
      "input"
    ],
    "controlpoints": [],
    "feedback": false
  }
}