{
  "response surface": {
    "type": "Node",
    "name": "Response Surface",
    "uniquename": "response surface",
    "pos": [
      4600.0,
      4651.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 2,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 0.05,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 100,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": null,
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 10,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": false,
        "decision tree": false,
        "random forest": false,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "y2:LocFilling",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            9.788549447,
            2.016938596,
            6.632494682,
            0.393087851,
            0.623419744
          ],
          [
            18.34804289,
            3.700574341,
            4.777920996,
            0.490664307,
            0.535690839
          ],
          [
            4.654472166,
            1.479137211,
            4.730038766,
            0.396241588,
            0.780810937
          ],
          [
            19.56763668,
            3.104585571,
            5.2849473,
            0.49650639,
            0.762353759
          ],
          [
            11.00681813,
            1.785904122,
            5.847412783,
            0.403769366,
            0.530548967
          ],
          [
            18.19800023,
            1.921641582,
            4.208995156,
            0.411655251,
            0.715635778
          ],
          [
            13.36849886,
            4.491557973,
            6.783561404,
            0.351197802,
            0.547891276
          ],
          [
            3.451960298,
            2.895677229,
            4.6061727,
            0.387841772,
            0.856625469
          ],
          [
            14.80515013,
            4.860848339,
            6.911705496,
            0.460418721,
            0.782912131
          ],
          [
            7.05833616,
            1.836670461,
            7.664113193,
            0.377375062,
            0.746764995
          ],
          [
            11.68848669,
            2.136690131,
            7.966364685,
            0.390446617,
            0.874525544
          ],
          [
            6.03404163,
            4.352487204,
            5.888565561,
            0.429514081,
            0.899091844
          ],
          [
            10.53319327,
            2.887233097,
            3.312531136,
            0.458494413,
            0.605396246
          ],
          [
            6.864863285,
            3.892492454,
            5.073076224,
            0.408089473,
            0.613583231
          ],
          [
            11.06387747,
            3.686758877,
            3.0712554,
            0.422213583,
            0.734611008
          ],
          [
            18.74997677,
            1.550790962,
            3.952716282,
            0.475479527,
            0.86381576
          ],
          [
            4.582175997,
            3.362273936,
            6.902265781,
            0.433099764,
            0.968719299
          ],
          [
            1.04077751,
            4.290534758,
            4.453128408,
            0.456444073,
            0.66578816
          ],
          [
            6.494932616,
            1.261724393,
            3.471443844,
            0.483195568,
            0.573714154
          ],
          [
            1.473268074,
            2.692816617,
            3.780868973,
            0.374492578,
            0.54384187
          ],
          [
            11.90846086,
            4.431493261,
            5.374209231,
            0.372151677,
            0.833679469
          ],
          [
            1.823868041,
            3.013687383,
            7.117587458,
            0.450643475,
            0.703534744
          ],
          [
            12.09188339,
            2.543505034,
            4.67288613,
            0.494124197,
            0.636241564
          ],
          [
            9.853837051,
            1.01114767,
            3.64428155,
            0.495513309,
            0.984817861
          ],
          [
            2.854003865,
            2.450924542,
            3.373957953,
            0.360504301,
            0.724284627
          ],
          [
            12.97045954,
            2.105182508,
            7.226270596,
            0.473357378,
            0.593110559
          ],
          [
            3.716034876,
            4.995558608,
            6.540902101,
            0.478820143,
            0.7377045
          ],
          [
            14.46836583,
            2.247226817,
            4.359837153,
            0.363935631,
            0.770230715
          ],
          [
            11.74995063,
            3.947615206,
            3.862920224,
            0.426411443,
            0.507651469
          ],
          [
            15.68812806,
            3.259309469,
            3.764045538,
            0.465086293,
            0.839282735
          ],
          [
            4.155986289,
            1.898178218,
            5.446616293,
            0.461787457,
            0.551535996
          ],
          [
            19.76707396,
            2.297001045,
            3.135108398,
            0.479700944,
            0.51407531
          ],
          [
            4.865288537,
            2.840958145,
            5.01882725,
            0.470718746,
            0.744291158
          ],
          [
            8.030146184,
            1.46097977,
            7.070121854,
            0.361932337,
            0.890420869
          ],
          [
            15.49388281,
            2.756082891,
            7.779576078,
            0.423746315,
            0.654265624
          ],
          [
            18.99604094,
            3.580096231,
            7.245130906,
            0.368950145,
            0.789298544
          ],
          [
            12.83681669,
            2.992390327,
            3.50576868,
            0.409697291,
            0.902295136
          ],
          [
            5.273630291,
            1.146457379,
            5.778637807,
            0.356502211,
            0.648684711
          ],
          [
            17.08938033,
            2.942575742,
            7.340287597,
            0.359411172,
            0.6170918
          ],
          [
            15.2537905,
            1.428396376,
            4.921443632,
            0.484934869,
            0.686046786
          ],
          [
            2.495138591,
            1.746804418,
            6.823096634,
            0.492965359,
            0.830951361
          ],
          [
            5.516233525,
            4.575204995,
            7.175857468,
            0.413236384,
            0.537486382
          ],
          [
            17.6798013,
            4.397514035,
            7.951631131,
            0.471509947,
            0.693155155
          ],
          [
            1.912741248,
            1.389622788,
            7.424503869,
            0.385059017,
            0.500946323
          ],
          [
            19.46010703,
            1.331334971,
            3.707400173,
            0.431548676,
            0.63013649
          ],
          [
            15.5719344,
            4.166343756,
            6.049012732,
            0.362281301,
            0.99238443
          ],
          [
            3.217810879,
            2.207471171,
            6.039766888,
            0.410214821,
            0.660652605
          ],
          [
            14.09463294,
            3.507343846,
            7.753089795,
            0.468687459,
            0.8924901
          ],
          [
            17.26886899,
            3.992278095,
            4.567357015,
            0.433790924,
            0.750889064
          ],
          [
            14.59515865,
            3.789932884,
            3.420807039,
            0.386448541,
            0.640932958
          ],
          [
            8.343289482,
            3.250689232,
            7.83739182,
            0.497818361,
            0.580677012
          ],
          [
            7.703976506,
            2.311813606,
            7.372080035,
            0.427986671,
            0.681778992
          ],
          [
            17.85517707,
            1.211330842,
            5.157192317,
            0.374712779,
            0.905299267
          ],
          [
            2.556942564,
            3.524073228,
            5.564654826,
            0.39191169,
            0.588959206
          ],
          [
            8.507327459,
            2.465090452,
            5.479569893,
            0.38337,
            0.961092008
          ],
          [
            1.61658386,
            2.059119004,
            4.958783736,
            0.425286302,
            0.945267143
          ],
          [
            18.96353436,
            2.493255477,
            6.334633235,
            0.437940296,
            0.568485585
          ],
          [
            13.65830091,
            3.128003054,
            6.210555852,
            0.377215263,
            0.690832599
          ],
          [
            5.786540137,
            2.799520585,
            6.452926788,
            0.370796963,
            0.510665236
          ],
          [
            17.97581945,
            3.164441381,
            5.738418184,
            0.454535588,
            0.986652064
          ],
          [
            17.01354641,
            4.944184098,
            3.318446931,
            0.445553211,
            0.935707734
          ],
          [
            4.083751138,
            3.590073323,
            4.230917974,
            0.444743698,
            0.637234055
          ],
          [
            9.504721436,
            3.829704145,
            5.714217637,
            0.48117961,
            0.775695248
          ],
          [
            16.73024719,
            2.020170199,
            5.622408006,
            0.499759591,
            0.850261487
          ],
          [
            10.39578685,
            1.592461928,
            6.388538385,
            0.463438042,
            0.709919277
          ],
          [
            6.99487011,
            2.185892831,
            4.531598622,
            0.466056374,
            0.978847178
          ],
          [
            3.798959544,
            1.647016359,
            7.870855459,
            0.416884646,
            0.915209169
          ],
          [
            13.55235709,
            2.381508139,
            5.109085045,
            0.448136508,
            0.82496484
          ],
          [
            4.291268118,
            4.822956688,
            3.044493931,
            0.367650335,
            0.59941045
          ],
          [
            16.48792596,
            4.612006745,
            5.921760394,
            0.388469928,
            0.731701683
          ],
          [
            3.288315364,
            3.847643424,
            7.476189882,
            0.462216109,
            0.951872284
          ],
          [
            17.47872115,
            2.408086223,
            6.977707764,
            0.402410502,
            0.927135772
          ],
          [
            15.08449179,
            3.759663672,
            6.48598094,
            0.414735381,
            0.861874257
          ],
          [
            14.8929519,
            1.834441998,
            3.225276574,
            0.353192276,
            0.965380491
          ],
          [
            8.215704235,
            4.488966256,
            3.230814253,
            0.438798577,
            0.767253998
          ],
          [
            8.790557478,
            2.659103967,
            6.162095789,
            0.419706069,
            0.796049226
          ],
          [
            14.26844018,
            1.720827049,
            5.336879498,
            0.434647683,
            0.603390071
          ],
          [
            18.55200481,
            4.114328055,
            6.720663546,
            0.38160502,
            0.673692819
          ],
          [
            3.056621249,
            4.547801603,
            4.287856489,
            0.488979751,
            0.919790719
          ],
          [
            19.2116042,
            4.708538973,
            7.684065169,
            0.397448875,
            0.973976579
          ],
          [
            6.592554184,
            3.213163022,
            6.766386076,
            0.398161838,
            0.820658967
          ],
          [
            2.139761705,
            4.715251246,
            6.098799606,
            0.467863025,
            0.621233672
          ],
          [
            10.15626788,
            3.381946684,
            4.887568721,
            0.366248617,
            0.930998286
          ],
          [
            10.00913305,
            1.111204906,
            7.274818288,
            0.436417312,
            0.846817191
          ],
          [
            10.83245742,
            4.756277632,
            4.171106188,
            0.357445107,
            0.809492039
          ],
          [
            19.99935929,
            1.044965141,
            5.681437304,
            0.423548391,
            0.815571385
          ],
          [
            11.25112533,
            2.729402724,
            5.979502568,
            0.477832384,
            0.913023656
          ],
          [
            7.819845636,
            4.130013387,
            5.199727496,
            0.474494595,
            0.522276445
          ],
          [
            12.29201989,
            1.321742975,
            6.235830371,
            0.451577397,
            0.954667435
          ],
          [
            16.18265444,
            1.524806097,
            6.653669989,
            0.443315897,
            0.525285263
          ],
          [
            5.073122719,
            4.018268373,
            3.170141475,
            0.378673898,
            0.84137414
          ],
          [
            8.624603852,
            4.658683844,
            4.683588798,
            0.455950249,
            0.871763154
          ],
          [
            13.12602955,
            1.218484414,
            7.517141925,
            0.406826692,
            0.756364996
          ],
          [
            7.488309811,
            4.91260246,
            5.244758405,
            0.401240459,
            0.695965003
          ],
          [
            5.963905057,
            1.962659305,
            3.593106339,
            0.453415695,
            0.791434492
          ],
          [
            8.967606043,
            1.664146913,
            4.041901138,
            0.369704149,
            0.669675738
          ],
          [
            2.245578588,
            4.208890791,
            3.554803437,
            0.404933483,
            0.801372123
          ],
          [
            11.3766819,
            4.249563083,
            7.042739201,
            0.489650881,
            0.657176598
          ],
          [
            15.87222728,
            4.795531254,
            4.828815218,
            0.418529136,
            0.583910764
          ],
          [
            9.162272388,
            4.079026537,
            7.594343833,
            0.449285252,
            0.562263061
          ],
          [
            9.396766336,
            3.067464518,
            4.364764796,
            0.416132625,
            0.997925471
          ],
          [
            13.92572748,
            4.339708403,
            3.97900118,
            0.39452212,
            0.949698034
          ],
          [
            12.61723455,
            3.415906428,
            5.529968312,
            0.441848902,
            0.720461724
          ],
          [
            6.198767388,
            3.470271313,
            3.899154451,
            0.352263323,
            0.707951905
          ],
          [
            5.403586229,
            2.571534762,
            4.048675668,
            0.440116164,
            0.882974696
          ],
          [
            16.33912676,
            2.610479893,
            7.583326895,
            0.48687255,
            0.805676008
          ],
          [
            1.283653606,
            3.924359259,
            6.30186782,
            0.354894391,
            0.878121766
          ],
          [
            7.282551011,
            3.632296353,
            6.558463687,
            0.485758821,
            0.938204107
          ],
          [
            12.52622456,
            1.106377039,
            4.467195687,
            0.380829971,
            0.566573465
          ],
          [
            16.69253866,
            3.325312538,
            4.095967735,
            0.399889608,
            0.555219597
          ]
        ],
        [
          0.0612,
          0.0582,
          0.0686,
          0.0772,
          0.0466,
          0.0724,
          0.054,
          0.0774,
          0.062,
          0.0578,
          0.0616,
          0.0768,
          0.0804,
          0.0636,
          0.0818,
          0.0876,
          0.0722,
          0.0618,
          0.08,
          0.0676,
          0.0686,
          0.0456,
          0.071,
          0.0902,
          0.0748,
          0.0418,
          0.0494,
          0.0686,
          0.0672,
          0.0862,
          0.0578,
          0.0834,
          0.0736,
          0.0634,
          0.0456,
          0.0622,
          0.0772,
          0.068,
          0.0516,
          0.0766,
          0.069,
          0.0436,
          0.0358,
          0.0346,
          0.0818,
          0.0792,
          0.062,
          0.0666,
          0.0758,
          0.074,
          0.025,
          0.0464,
          0.0702,
          0.0546,
          0.0776,
          0.081,
          0.0536,
          0.064,
          0.0542,
          0.0806,
          0.0914,
          0.0658,
          0.0666,
          0.0838,
          0.0646,
          0.0852,
          0.0626,
          0.0722,
          0.075,
          0.0654,
          0.067,
          0.0662,
          0.07,
          0.074,
          0.081,
          0.0674,
          0.068,
          0.059,
          0.079,
          0.0744,
          0.0678,
          0.0486,
          0.071,
          0.0652,
          0.0764,
          0.0618,
          0.0732,
          0.0528,
          0.0754,
          0.0452,
          0.0802,
          0.081,
          0.058,
          0.064,
          0.081,
          0.0716,
          0.0772,
          0.0334,
          0.0628,
          0.0292,
          0.0878,
          0.083,
          0.0668,
          0.0724,
          0.0804,
          0.051,
          0.0704,
          0.0704,
          0.0716,
          0.0688
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "/Users/esma/ALPEMI/UQ_Study/COMPTOOLKITS_SA/Nodeworks/C1",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 213,
    "geometry": [
      565.0,
      469.0
    ]
  },
  "read csv": {
    "type": "Node",
    "name": "Read CSV",
    "uniquename": "read csv",
    "pos": [
      4785.0,
      5171.0
    ],
    "path": [
      "pandas",
      "Read CSV"
    ],
    "terminals": {
      "file": {
        "value": "C:/Users/onlyj/Downloads/COMP_SurrogateModel_Evals_n10.csv",
        "flipped": false,
        "opts": {
          "widget": "browse",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "file"
        }
      },
      "sep": {
        "value": ",",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "value": ",",
          "name": "sep"
        }
      },
      "parse dates": {
        "value": false,
        "flipped": false,
        "opts": {
          "widget": "checkbox",
          "in": true,
          "dtype": "<class 'bool'>",
          "name": "parse dates"
        }
      },
      "index column": {
        "value": "",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "index column"
        }
      },
      "dataframe": {
        "value": {
          "__nw_type__": "pd_frame",
          "data": "{}"
        },
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'pandas.core.frame.DataFrame'>",
          "name": "dataframe"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 226,
    "geometry": [
      193.0,
      168.0
    ]
  },
  "emulator": {
    "type": "Node",
    "name": "Emulator",
    "uniquename": "emulator",
    "pos": [
      5010.0,
      5185.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'float'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 225,
    "geometry": [
      184.0,
      97.0
    ]
  },
  "plot": {
    "type": "Node",
    "name": "Plot",
    "uniquename": "plot",
    "pos": [
      5395.0,
      4698.0
    ],
    "path": [
      "matplotlib",
      "Plot"
    ],
    "terminals": {
      "x": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "value": [],
          "multiinput": true,
          "name": "x"
        }
      },
      "y": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "value": [],
          "multiinput": true,
          "name": "y"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "plot_type": "scatter"
    },
    "layer": 211,
    "geometry": [
      420.0,
      485.0
    ]
  },
  "display": {
    "type": "Node",
    "name": "Display",
    "uniquename": "display",
    "pos": [
      5396.0,
      5199.0
    ],
    "path": [
      "general",
      "Display"
    ],
    "terminals": {
      "input": {
        "value": null,
        "flipped": false,
        "opts": {
          "widget": "textedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "input"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 209,
    "geometry": [
      572.0,
      135.0
    ]
  },
  "code": {
    "type": "Node",
    "name": "PSUADE",
    "uniquename": "code",
    "pos": [
      4693.0,
      4389.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "returnOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "returnOut"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "code": "returnOut = [0.068215, 0.066127, 0.061553, 0.063218, 0.058710, 0.077511, 0.086308, 0.049749, 0.074961, 0.067576]"
    },
    "layer": 212,
    "geometry": [
      471.0,
      252.0
    ]
  },
  "response surface.1": {
    "type": "Node",
    "name": "Response Surface",
    "uniquename": "response surface.1",
    "pos": [
      4600.0,
      5353.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 2,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 1e-10,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 0,
        "gp_normalize": false,
        "mlp_hidden_layer_sizes": null,
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 10,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": false,
        "multilayer perceptron": false,
        "support vector machine": false,
        "decision tree": false,
        "random forest": false,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "y2:LocFilling",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            9.788549447,
            2.016938596,
            6.632494682,
            0.393087851,
            0.623419744
          ],
          [
            18.34804289,
            3.700574341,
            4.777920996,
            0.490664307,
            0.535690839
          ],
          [
            4.654472166,
            1.479137211,
            4.730038766,
            0.396241588,
            0.780810937
          ],
          [
            19.56763668,
            3.104585571,
            5.2849473,
            0.49650639,
            0.762353759
          ],
          [
            11.00681813,
            1.785904122,
            5.847412783,
            0.403769366,
            0.530548967
          ],
          [
            18.19800023,
            1.921641582,
            4.208995156,
            0.411655251,
            0.715635778
          ],
          [
            13.36849886,
            4.491557973,
            6.783561404,
            0.351197802,
            0.547891276
          ],
          [
            3.451960298,
            2.895677229,
            4.6061727,
            0.387841772,
            0.856625469
          ],
          [
            14.80515013,
            4.860848339,
            6.911705496,
            0.460418721,
            0.782912131
          ],
          [
            7.05833616,
            1.836670461,
            7.664113193,
            0.377375062,
            0.746764995
          ],
          [
            11.68848669,
            2.136690131,
            7.966364685,
            0.390446617,
            0.874525544
          ],
          [
            6.03404163,
            4.352487204,
            5.888565561,
            0.429514081,
            0.899091844
          ],
          [
            10.53319327,
            2.887233097,
            3.312531136,
            0.458494413,
            0.605396246
          ],
          [
            6.864863285,
            3.892492454,
            5.073076224,
            0.408089473,
            0.613583231
          ],
          [
            11.06387747,
            3.686758877,
            3.0712554,
            0.422213583,
            0.734611008
          ],
          [
            18.74997677,
            1.550790962,
            3.952716282,
            0.475479527,
            0.86381576
          ],
          [
            4.582175997,
            3.362273936,
            6.902265781,
            0.433099764,
            0.968719299
          ],
          [
            1.04077751,
            4.290534758,
            4.453128408,
            0.456444073,
            0.66578816
          ],
          [
            6.494932616,
            1.261724393,
            3.471443844,
            0.483195568,
            0.573714154
          ],
          [
            1.473268074,
            2.692816617,
            3.780868973,
            0.374492578,
            0.54384187
          ],
          [
            11.90846086,
            4.431493261,
            5.374209231,
            0.372151677,
            0.833679469
          ],
          [
            1.823868041,
            3.013687383,
            7.117587458,
            0.450643475,
            0.703534744
          ],
          [
            12.09188339,
            2.543505034,
            4.67288613,
            0.494124197,
            0.636241564
          ],
          [
            9.853837051,
            1.01114767,
            3.64428155,
            0.495513309,
            0.984817861
          ],
          [
            2.854003865,
            2.450924542,
            3.373957953,
            0.360504301,
            0.724284627
          ],
          [
            12.97045954,
            2.105182508,
            7.226270596,
            0.473357378,
            0.593110559
          ],
          [
            3.716034876,
            4.995558608,
            6.540902101,
            0.478820143,
            0.7377045
          ],
          [
            14.46836583,
            2.247226817,
            4.359837153,
            0.363935631,
            0.770230715
          ],
          [
            11.74995063,
            3.947615206,
            3.862920224,
            0.426411443,
            0.507651469
          ],
          [
            15.68812806,
            3.259309469,
            3.764045538,
            0.465086293,
            0.839282735
          ],
          [
            4.155986289,
            1.898178218,
            5.446616293,
            0.461787457,
            0.551535996
          ],
          [
            19.76707396,
            2.297001045,
            3.135108398,
            0.479700944,
            0.51407531
          ],
          [
            4.865288537,
            2.840958145,
            5.01882725,
            0.470718746,
            0.744291158
          ],
          [
            8.030146184,
            1.46097977,
            7.070121854,
            0.361932337,
            0.890420869
          ],
          [
            15.49388281,
            2.756082891,
            7.779576078,
            0.423746315,
            0.654265624
          ],
          [
            18.99604094,
            3.580096231,
            7.245130906,
            0.368950145,
            0.789298544
          ],
          [
            12.83681669,
            2.992390327,
            3.50576868,
            0.409697291,
            0.902295136
          ],
          [
            5.273630291,
            1.146457379,
            5.778637807,
            0.356502211,
            0.648684711
          ],
          [
            17.08938033,
            2.942575742,
            7.340287597,
            0.359411172,
            0.6170918
          ],
          [
            15.2537905,
            1.428396376,
            4.921443632,
            0.484934869,
            0.686046786
          ],
          [
            2.495138591,
            1.746804418,
            6.823096634,
            0.492965359,
            0.830951361
          ],
          [
            5.516233525,
            4.575204995,
            7.175857468,
            0.413236384,
            0.537486382
          ],
          [
            17.6798013,
            4.397514035,
            7.951631131,
            0.471509947,
            0.693155155
          ],
          [
            1.912741248,
            1.389622788,
            7.424503869,
            0.385059017,
            0.500946323
          ],
          [
            19.46010703,
            1.331334971,
            3.707400173,
            0.431548676,
            0.63013649
          ],
          [
            15.5719344,
            4.166343756,
            6.049012732,
            0.362281301,
            0.99238443
          ],
          [
            3.217810879,
            2.207471171,
            6.039766888,
            0.410214821,
            0.660652605
          ],
          [
            14.09463294,
            3.507343846,
            7.753089795,
            0.468687459,
            0.8924901
          ],
          [
            17.26886899,
            3.992278095,
            4.567357015,
            0.433790924,
            0.750889064
          ],
          [
            14.59515865,
            3.789932884,
            3.420807039,
            0.386448541,
            0.640932958
          ],
          [
            8.343289482,
            3.250689232,
            7.83739182,
            0.497818361,
            0.580677012
          ],
          [
            7.703976506,
            2.311813606,
            7.372080035,
            0.427986671,
            0.681778992
          ],
          [
            17.85517707,
            1.211330842,
            5.157192317,
            0.374712779,
            0.905299267
          ],
          [
            2.556942564,
            3.524073228,
            5.564654826,
            0.39191169,
            0.588959206
          ],
          [
            8.507327459,
            2.465090452,
            5.479569893,
            0.38337,
            0.961092008
          ],
          [
            1.61658386,
            2.059119004,
            4.958783736,
            0.425286302,
            0.945267143
          ],
          [
            18.96353436,
            2.493255477,
            6.334633235,
            0.437940296,
            0.568485585
          ],
          [
            13.65830091,
            3.128003054,
            6.210555852,
            0.377215263,
            0.690832599
          ],
          [
            5.786540137,
            2.799520585,
            6.452926788,
            0.370796963,
            0.510665236
          ],
          [
            17.97581945,
            3.164441381,
            5.738418184,
            0.454535588,
            0.986652064
          ],
          [
            17.01354641,
            4.944184098,
            3.318446931,
            0.445553211,
            0.935707734
          ],
          [
            4.083751138,
            3.590073323,
            4.230917974,
            0.444743698,
            0.637234055
          ],
          [
            9.504721436,
            3.829704145,
            5.714217637,
            0.48117961,
            0.775695248
          ],
          [
            16.73024719,
            2.020170199,
            5.622408006,
            0.499759591,
            0.850261487
          ],
          [
            10.39578685,
            1.592461928,
            6.388538385,
            0.463438042,
            0.709919277
          ],
          [
            6.99487011,
            2.185892831,
            4.531598622,
            0.466056374,
            0.978847178
          ],
          [
            3.798959544,
            1.647016359,
            7.870855459,
            0.416884646,
            0.915209169
          ],
          [
            13.55235709,
            2.381508139,
            5.109085045,
            0.448136508,
            0.82496484
          ],
          [
            4.291268118,
            4.822956688,
            3.044493931,
            0.367650335,
            0.59941045
          ],
          [
            16.48792596,
            4.612006745,
            5.921760394,
            0.388469928,
            0.731701683
          ],
          [
            3.288315364,
            3.847643424,
            7.476189882,
            0.462216109,
            0.951872284
          ],
          [
            17.47872115,
            2.408086223,
            6.977707764,
            0.402410502,
            0.927135772
          ],
          [
            15.08449179,
            3.759663672,
            6.48598094,
            0.414735381,
            0.861874257
          ],
          [
            14.8929519,
            1.834441998,
            3.225276574,
            0.353192276,
            0.965380491
          ],
          [
            8.215704235,
            4.488966256,
            3.230814253,
            0.438798577,
            0.767253998
          ],
          [
            8.790557478,
            2.659103967,
            6.162095789,
            0.419706069,
            0.796049226
          ],
          [
            14.26844018,
            1.720827049,
            5.336879498,
            0.434647683,
            0.603390071
          ],
          [
            18.55200481,
            4.114328055,
            6.720663546,
            0.38160502,
            0.673692819
          ],
          [
            3.056621249,
            4.547801603,
            4.287856489,
            0.488979751,
            0.919790719
          ],
          [
            19.2116042,
            4.708538973,
            7.684065169,
            0.397448875,
            0.973976579
          ],
          [
            6.592554184,
            3.213163022,
            6.766386076,
            0.398161838,
            0.820658967
          ],
          [
            2.139761705,
            4.715251246,
            6.098799606,
            0.467863025,
            0.621233672
          ],
          [
            10.15626788,
            3.381946684,
            4.887568721,
            0.366248617,
            0.930998286
          ],
          [
            10.00913305,
            1.111204906,
            7.274818288,
            0.436417312,
            0.846817191
          ],
          [
            10.83245742,
            4.756277632,
            4.171106188,
            0.357445107,
            0.809492039
          ],
          [
            19.99935929,
            1.044965141,
            5.681437304,
            0.423548391,
            0.815571385
          ],
          [
            11.25112533,
            2.729402724,
            5.979502568,
            0.477832384,
            0.913023656
          ],
          [
            7.819845636,
            4.130013387,
            5.199727496,
            0.474494595,
            0.522276445
          ],
          [
            12.29201989,
            1.321742975,
            6.235830371,
            0.451577397,
            0.954667435
          ],
          [
            16.18265444,
            1.524806097,
            6.653669989,
            0.443315897,
            0.525285263
          ],
          [
            5.073122719,
            4.018268373,
            3.170141475,
            0.378673898,
            0.84137414
          ],
          [
            8.624603852,
            4.658683844,
            4.683588798,
            0.455950249,
            0.871763154
          ],
          [
            13.12602955,
            1.218484414,
            7.517141925,
            0.406826692,
            0.756364996
          ],
          [
            7.488309811,
            4.91260246,
            5.244758405,
            0.401240459,
            0.695965003
          ],
          [
            5.963905057,
            1.962659305,
            3.593106339,
            0.453415695,
            0.791434492
          ],
          [
            8.967606043,
            1.664146913,
            4.041901138,
            0.369704149,
            0.669675738
          ],
          [
            2.245578588,
            4.208890791,
            3.554803437,
            0.404933483,
            0.801372123
          ],
          [
            11.3766819,
            4.249563083,
            7.042739201,
            0.489650881,
            0.657176598
          ],
          [
            15.87222728,
            4.795531254,
            4.828815218,
            0.418529136,
            0.583910764
          ],
          [
            9.162272388,
            4.079026537,
            7.594343833,
            0.449285252,
            0.562263061
          ],
          [
            9.396766336,
            3.067464518,
            4.364764796,
            0.416132625,
            0.997925471
          ],
          [
            13.92572748,
            4.339708403,
            3.97900118,
            0.39452212,
            0.949698034
          ],
          [
            12.61723455,
            3.415906428,
            5.529968312,
            0.441848902,
            0.720461724
          ],
          [
            6.198767388,
            3.470271313,
            3.899154451,
            0.352263323,
            0.707951905
          ],
          [
            5.403586229,
            2.571534762,
            4.048675668,
            0.440116164,
            0.882974696
          ],
          [
            16.33912676,
            2.610479893,
            7.583326895,
            0.48687255,
            0.805676008
          ],
          [
            1.283653606,
            3.924359259,
            6.30186782,
            0.354894391,
            0.878121766
          ],
          [
            7.282551011,
            3.632296353,
            6.558463687,
            0.485758821,
            0.938204107
          ],
          [
            12.52622456,
            1.106377039,
            4.467195687,
            0.380829971,
            0.566573465
          ],
          [
            16.69253866,
            3.325312538,
            4.095967735,
            0.399889608,
            0.555219597
          ]
        ],
        [
          0.0612,
          0.0582,
          0.0686,
          0.0772,
          0.0466,
          0.0724,
          0.054,
          0.0774,
          0.062,
          0.0578,
          0.0616,
          0.0768,
          0.0804,
          0.0636,
          0.0818,
          0.0876,
          0.0722,
          0.0618,
          0.08,
          0.0676,
          0.0686,
          0.0456,
          0.071,
          0.0902,
          0.0748,
          0.0418,
          0.0494,
          0.0686,
          0.0672,
          0.0862,
          0.0578,
          0.0834,
          0.0736,
          0.0634,
          0.0456,
          0.0622,
          0.0772,
          0.068,
          0.0516,
          0.0766,
          0.069,
          0.0436,
          0.0358,
          0.0346,
          0.0818,
          0.0792,
          0.062,
          0.0666,
          0.0758,
          0.074,
          0.025,
          0.0464,
          0.0702,
          0.0546,
          0.0776,
          0.081,
          0.0536,
          0.064,
          0.0542,
          0.0806,
          0.0914,
          0.0658,
          0.0666,
          0.0838,
          0.0646,
          0.0852,
          0.0626,
          0.0722,
          0.075,
          0.0654,
          0.067,
          0.0662,
          0.07,
          0.074,
          0.081,
          0.0674,
          0.068,
          0.059,
          0.079,
          0.0744,
          0.0678,
          0.0486,
          0.071,
          0.0652,
          0.0764,
          0.0618,
          0.0732,
          0.0528,
          0.0754,
          0.0452,
          0.0802,
          0.081,
          0.058,
          0.064,
          0.081,
          0.0716,
          0.0772,
          0.0334,
          0.0628,
          0.0292,
          0.0878,
          0.083,
          0.0668,
          0.0724,
          0.0804,
          0.051,
          0.0704,
          0.0704,
          0.0716,
          0.0688
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "/Users/esma/ALPEMI/UQ_Study/COMPTOOLKITS_SA/Nodeworks/C1",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 200,
    "geometry": [
      565.0,
      469.0
    ]
  },
  "emulator.0": {
    "type": "Node",
    "name": "Emulator",
    "uniquename": "emulator.0",
    "pos": [
      5208.0,
      5435.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'float'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 208,
    "geometry": [
      184.0,
      97.0
    ]
  },
  "display.0": {
    "type": "Node",
    "name": "Display",
    "uniquename": "display.0",
    "pos": [
      5437.0,
      5457.0
    ],
    "path": [
      "general",
      "Display"
    ],
    "terminals": {
      "input": {
        "value": null,
        "flipped": false,
        "opts": {
          "widget": "textedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "input"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 210,
    "geometry": [
      572.0,
      135.0
    ]
  },
  "connection": {
    "type": "Connection",
    "name": "connection",
    "line": "cubic",
    "uniquename": "connection",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "emulator",
      "model"
    ],
    "controlpoints": [
      [
        5162.0,
        5141.0,
        true
      ],
      [
        5013.0,
        5142.0,
        true
      ]
    ],
    "feedback": false
  },
  "connection.0": {
    "type": "Connection",
    "name": "connection.0",
    "line": "cubic",
    "uniquename": "connection.0",
    "input": [
      "emulator",
      "result"
    ],
    "output": [
      "plot",
      "y"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.1": {
    "type": "Connection",
    "name": "connection.1",
    "line": "cubic",
    "uniquename": "connection.1",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.2": {
    "type": "Connection",
    "name": "connection.2",
    "line": "cubic",
    "uniquename": "connection.2",
    "input": [
      "emulator",
      "result"
    ],
    "output": [
      "display",
      "input"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.3": {
    "type": "Connection",
    "name": "connection.3",
    "line": "cubic",
    "uniquename": "connection.3",
    "input": [
      "code",
      "returnOut"
    ],
    "output": [
      "plot",
      "x"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.4": {
    "type": "Connection",
    "name": "connection.4",
    "line": "cubic",
    "uniquename": "connection.4",
    "input": [
      "code",
      "returnOut"
    ],
    "output": [
      "plot",
      "y"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.5": {
    "type": "Connection",
    "name": "connection.5",
    "line": "cubic",
    "uniquename": "connection.5",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator.0",
      "points"
    ],
    "controlpoints": [
      [
        5163.0,
        5324.0,
        false
      ]
    ],
    "feedback": false
  },
  "connection.6": {
    "type": "Connection",
    "name": "connection.6",
    "line": "cubic",
    "uniquename": "connection.6",
    "input": [
      "response surface.1",
      "Model"
    ],
    "output": [
      "emulator.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.7": {
    "type": "Connection",
    "name": "connection.7",
    "line": "cubic",
    "uniquename": "connection.7",
    "input": [
      "emulator.0",
      "result"
    ],
    "output": [
      "display.0",
      "input"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.8": {
    "type": "Connection",
    "name": "connection.8",
    "line": "cubic",
    "uniquename": "connection.8",
    "input": [
      "emulator.0",
      "result"
    ],
    "output": [
      "plot",
      "y"
    ],
    "controlpoints": [
      [
        5382.0,
        5410.0,
        true
      ]
    ],
    "feedback": false
  }
}