{
  "read csv": {
    "type": "Node",
    "name": "Test Samples",
    "uniquename": "read csv",
    "pos": [
      4785.0,
      6184.0
    ],
    "path": [
      "pandas",
      "Read CSV"
    ],
    "terminals": {
      "file": {
        "value": "C:/Users/onlyj/Documents/nodeworks_projects/C2/C2_10new_samples.csv",
        "flipped": false,
        "opts": {
          "widget": "browse",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "file"
        }
      },
      "sep": {
        "value": ",",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "value": ",",
          "name": "sep"
        }
      },
      "parse dates": {
        "value": false,
        "flipped": false,
        "opts": {
          "widget": "checkbox",
          "in": true,
          "dtype": "<class 'bool'>",
          "name": "parse dates"
        }
      },
      "index column": {
        "value": "",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "index column"
        }
      },
      "dataframe": {
        "value": {
          "__nw_type__": "pd_frame",
          "data": "{}"
        },
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'pandas.core.frame.DataFrame'>",
          "name": "dataframe"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 255,
    "geometry": [
      193.0,
      168.0
    ]
  },
  "code": {
    "type": "Node",
    "name": "Code",
    "uniquename": "code",
    "pos": [
      5422.0,
      6054.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "r1, r2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": "None",
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'str'>",
          "name": "returnOut"
        }
      },
      "r1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r1"
        }
      },
      "r2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r2"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "s_list = []\n\nfor p1, p2 in zip(r1, r2):\n    s_list.append(f'{p1},{p2}')\n    \nreturnOut = '\\n'.join(s_list)"
    },
    "layer": 253,
    "geometry": [
      400.0,
      400.0
    ]
  },
  "code.0": {
    "type": "Node",
    "name": "Write sensitivities",
    "uniquename": "code.0",
    "pos": [
      5709.0,
      5372.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "sens1, sens2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "name": "returnOut"
        }
      },
      "sens1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens1"
        }
      },
      "sens2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens2"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "import os\n\nSAVE_DIR = r'C:\\Users\\onlyj\\Documents\\nodeworks_projects\\C2'\nFNAME = 'C2_Nodeworks_SA_y2dP3.csv'\n\nT1 = sens1.get('ST')\nS1 = sens1.get('ST_conf')\n\nT2 = sens2.get('ST')\nS2 = sens2.get('ST_conf')\n\nvar_list = [\n    \"t1:P_0\", \"t2:beta\", \"t3:StatWeight\", \"t4:ep_g\", \"t5:VelfacCoeff\"\n    ]\n\nwith open(os.path.join(SAVE_DIR, FNAME), 'w') as f:\n    f.write(\"UQTool,Params,Sobol_mean,Sobol_std\\n\")\n    \n    for v, t, s in zip(var_list, T1, S1):\n        f.write(f\"Nodeworks (GPM),{v},{t},{s}\\n\")\n\n    for v, t, s in zip(var_list, T2, S2):\n        f.write(f\"Nodeworks (GPM Tuned),{v},{t},{s}\\n\")\n\n\nreturnOut = None"
    },
    "layer": 278,
    "geometry": [
      574.0,
      401.0
    ]
  },
  "response surface": {
    "type": "Node",
    "name": "Response Surface",
    "uniquename": "response surface",
    "pos": [
      4530.0,
      4857.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 1e-10,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "DP3",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            61.21880634,
            4.262878501,
            60.81054431,
            0.499348062,
            0.909726256
          ],
          [
            53.34763364,
            4.931477888,
            72.77874051,
            0.409211076,
            0.918145286
          ],
          [
            5.102686031,
            3.4398486,
            93.35037663,
            0.462908833,
            0.851539131
          ],
          [
            33.70707689,
            2.819421215,
            37.58707601,
            0.479431133,
            0.969992997
          ],
          [
            78.08006601,
            3.656785791,
            84.69799328,
            0.430834558,
            0.873881682
          ],
          [
            32.43023978,
            4.704924664,
            64.48838734,
            0.492986787,
            0.939338369
          ],
          [
            23.2093467,
            3.518447135,
            94.55723957,
            0.418258617,
            0.930479239
          ],
          [
            70.94454478,
            4.619135147,
            46.8785792,
            0.415037206,
            0.913484793
          ],
          [
            99.8311867,
            4.448630455,
            87.86291569,
            0.440843112,
            0.941049886
          ],
          [
            76.65922655,
            2.915134034,
            50.49046706,
            0.447855924,
            0.925542137
          ],
          [
            62.71676835,
            3.133976077,
            83.991381,
            0.434715069,
            0.922026751
          ],
          [
            98.59184662,
            4.212352394,
            46.25009075,
            0.474253819,
            0.963656646
          ],
          [
            14.62568546,
            2.71492271,
            32.42302105,
            0.453197495,
            0.943424892
          ],
          [
            3.877362564,
            2.99661721,
            67.00241906,
            0.484354692,
            0.913909144
          ],
          [
            70.05595611,
            3.352659997,
            27.32534869,
            0.487058262,
            0.965582943
          ],
          [
            17.36440685,
            2.929067762,
            12.61316337,
            0.412457359,
            0.867236988
          ],
          [
            40.47507954,
            2.362965774,
            45.16373767,
            0.487734543,
            0.926916091
          ],
          [
            19.95830274,
            4.289271126,
            17.03937601,
            0.444349288,
            0.920627189
          ],
          [
            13.53759665,
            3.301314215,
            18.90895094,
            0.498474244,
            0.877812106
          ],
          [
            10.50921564,
            4.791995856,
            49.9082724,
            0.407143493,
            0.974857375
          ],
          [
            37.73489649,
            4.976989873,
            96.64999579,
            0.485929347,
            0.85516888
          ],
          [
            14.18935204,
            4.113317145,
            69.1288039,
            0.419830257,
            0.893579811
          ],
          [
            66.87664981,
            2.069260922,
            94.26373231,
            0.443474457,
            0.878680137
          ],
          [
            86.996885,
            2.250854203,
            35.04201095,
            0.498058143,
            0.977642382
          ],
          [
            52.72592183,
            3.813968264,
            81.4600772,
            0.446088462,
            0.956025751
          ],
          [
            51.32769905,
            4.004029483,
            54.28798174,
            0.433602346,
            0.969227511
          ],
          [
            57.04304776,
            3.532902387,
            63.69520567,
            0.423857397,
            0.880069118
          ],
          [
            82.3906655,
            3.273833241,
            75.17729197,
            0.460220375,
            0.951808325
          ],
          [
            87.75644195,
            3.561471042,
            15.13399255,
            0.48233004,
            0.940007252
          ],
          [
            21.72888171,
            3.252789924,
            43.03239405,
            0.43720469,
            0.858746117
          ],
          [
            25.18845912,
            4.836982355,
            83.4992026,
            0.400256146,
            0.859910971
          ],
          [
            6.608334644,
            3.890709242,
            36.35965228,
            0.417190418,
            0.953538315
          ],
          [
            32.77445723,
            2.232685742,
            14.67819122,
            0.434009466,
            0.892421092
          ],
          [
            26.32309421,
            4.084416941,
            26.26558503,
            0.485198793,
            0.901439246
          ],
          [
            85.13941839,
            3.083279177,
            90.74637004,
            0.425110351,
            0.97122607
          ],
          [
            84.19555048,
            3.838844326,
            53.57879084,
            0.488890217,
            0.919355423
          ],
          [
            55.28236953,
            4.135607911,
            13.90179607,
            0.465899719,
            0.860791333
          ],
          [
            11.4838616,
            3.737969367,
            48.06343754,
            0.449500675,
            0.904152492
          ],
          [
            15.97031566,
            4.346232721,
            58.62551175,
            0.481407645,
            0.979909193
          ],
          [
            94.04615889,
            3.948270081,
            33.72215299,
            0.492173394,
            0.871097122
          ],
          [
            96.19004642,
            3.749371582,
            11.36309691,
            0.435500179,
            0.975824308
          ],
          [
            29.35775317,
            3.0157794,
            23.84495987,
            0.407899178,
            0.956977833
          ],
          [
            49.76091425,
            4.567552226,
            22.42156083,
            0.496406428,
            0.925741448
          ],
          [
            73.95808097,
            2.333362996,
            18.15585485,
            0.458527809,
            0.968027679
          ],
          [
            81.95320227,
            4.37487997,
            29.72628243,
            0.421686632,
            0.86406645
          ],
          [
            79.0809101,
            2.037578253,
            42.48098119,
            0.400946368,
            0.942293915
          ],
          [
            91.12207426,
            4.540533211,
            41.16099369,
            0.459596973,
            0.894900724
          ],
          [
            24.15970508,
            2.777853171,
            64.84615141,
            0.462305693,
            0.896120069
          ],
          [
            30.28649217,
            4.458262093,
            51.77921064,
            0.455050754,
            0.87329627
          ],
          [
            3.365043799,
            4.041614995,
            98.12293161,
            0.40374506,
            0.928623373
          ],
          [
            71.63257962,
            2.738978065,
            87.56616436,
            0.494707362,
            0.862793109
          ],
          [
            63.10700067,
            4.499191919,
            68.10931761,
            0.490098729,
            0.972422692
          ],
          [
            75.66498466,
            2.658416988,
            70.20967576,
            0.404742279,
            0.960377955
          ],
          [
            9.333128233,
            2.395337083,
            86.04736497,
            0.489371835,
            0.95441348
          ],
          [
            44.81111083,
            2.507687854,
            67.2953895,
            0.438311914,
            0.947223351
          ],
          [
            31.03747767,
            3.398102063,
            31.46848032,
            0.426589288,
            0.915069031
          ],
          [
            38.09103413,
            3.321065433,
            57.80031591,
            0.442121479,
            0.935107776
          ],
          [
            39.57050736,
            3.585908895,
            21.54398288,
            0.45173729,
            0.86874655
          ],
          [
            92.40683208,
            4.886788622,
            19.79847377,
            0.429868807,
            0.957635267
          ],
          [
            64.80775472,
            3.048416148,
            35.65879182,
            0.464534859,
            0.907328376
          ],
          [
            65.82037812,
            3.924224018,
            95.76731423,
            0.471005896,
            0.946761985
          ],
          [
            79.54523309,
            4.0637586,
            65.92532027,
            0.450208933,
            0.85685082
          ],
          [
            59.68805826,
            2.800278388,
            15.91446678,
            0.420033959,
            0.938160689
          ],
          [
            26.15060383,
            2.106067358,
            60.66298971,
            0.426158336,
            0.962886282
          ],
          [
            96.81070638,
            3.460008032,
            79.20528559,
            0.4939135,
            0.899547226
          ],
          [
            47.2215095,
            4.327887169,
            28.55812488,
            0.461430933,
            0.936684687
          ],
          [
            27.95531719,
            2.490514073,
            98.92017949,
            0.448725209,
            0.973821936
          ],
          [
            97.40890642,
            2.444626801,
            26.60360589,
            0.411391801,
            0.922385495
          ],
          [
            54.38874185,
            2.553988224,
            40.31855016,
            0.428426637,
            0.903003977
          ],
          [
            46.49973228,
            2.958472785,
            79.66223689,
            0.470082938,
            0.977103144
          ],
          [
            48.73490918,
            3.15523774,
            48.60827305,
            0.478007072,
            0.865731035
          ],
          [
            1.048717394,
            2.695975992,
            45.7302038,
            0.421979464,
            0.887374104
          ],
          [
            41.7450197,
            3.87122224,
            70.87790691,
            0.467934303,
            0.885279436
          ],
          [
            59.34477438,
            3.49951044,
            44.21477236,
            0.456258633,
            0.958790766
          ],
          [
            6.282984691,
            4.607761099,
            73.83084385,
            0.427629674,
            0.869180508
          ],
          [
            65.71352522,
            2.433910575,
            52.59469807,
            0.418104873,
            0.858163313
          ],
          [
            35.09786259,
            3.978209694,
            86.71560699,
            0.457453568,
            0.912630873
          ],
          [
            68.23387506,
            3.775980076,
            19.959749,
            0.406033367,
            0.895006337
          ],
          [
            12.62657793,
            2.57856187,
            82.37514895,
            0.476934557,
            0.934249859
          ],
          [
            85.98685994,
            4.953819828,
            57.2310843,
            0.438133743,
            0.900335824
          ],
          [
            88.48079365,
            4.298344127,
            80.43898657,
            0.408272548,
            0.882043568
          ],
          [
            21.09345376,
            4.891515959,
            38.8928683,
            0.471899249,
            0.88076735
          ],
          [
            28.31575285,
            3.67719602,
            73.81781755,
            0.474665639,
            0.923559774
          ],
          [
            19.70434601,
            3.625325706,
            51.2797987,
            0.495902602,
            0.949237456
          ],
          [
            40.66580343,
            4.516102241,
            10.61443607,
            0.423119701,
            0.94929826
          ],
          [
            89.8171221,
            2.645436262,
            96.80315357,
            0.454380257,
            0.910291353
          ],
          [
            56.00329188,
            2.131693766,
            31.20578257,
            0.475644881,
            0.950967033
          ],
          [
            35.22777832,
            2.614151254,
            56.51128401,
            0.403615878,
            0.876736518
          ],
          [
            93.52522508,
            2.856151176,
            71.45807517,
            0.445414182,
            0.854243539
          ],
          [
            69.2525305,
            4.834687505,
            78.55581938,
            0.452233315,
            0.929667066
          ],
          [
            7.327706725,
            2.010938158,
            20.87033273,
            0.469680214,
            0.91720859
          ],
          [
            18.44863893,
            4.65193354,
            89.98742569,
            0.465113842,
            0.962186779
          ],
          [
            45.21129545,
            3.710736761,
            39.51867624,
            0.410287725,
            0.8530919
          ],
          [
            90.81448374,
            3.197731707,
            61.71620543,
            0.413096195,
            0.945625494
          ],
          [
            42.86379467,
            3.219203426,
            92.51970374,
            0.402258249,
            0.906000696
          ],
          [
            57.8759597,
            2.277643024,
            75.46874375,
            0.483159345,
            0.872417018
          ],
          [
            17.15824056,
            2.32335941,
            76.52178744,
            0.432190098,
            0.908980324
          ],
          [
            2.73762426,
            2.148345147,
            62.74639872,
            0.456576092,
            0.864883475
          ],
          [
            94.73970703,
            2.205012856,
            55.61336736,
            0.466458088,
            0.93205323
          ],
          [
            8.442301598,
            3.093211926,
            28.84001308,
            0.440957025,
            0.883578881
          ],
          [
            83.7924221,
            2.531070507,
            23.99523305,
            0.46871849,
            0.875288232
          ],
          [
            43.58022484,
            4.765031996,
            34.53194921,
            0.446439536,
            0.888967251
          ],
          [
            36.59381966,
            4.195619154,
            77.80961188,
            0.413780682,
            0.966487323
          ],
          [
            80.57112614,
            4.730390366,
            12.11768373,
            0.478312984,
            0.904647955
          ],
          [
            72.35653028,
            3.387894714,
            59.11914031,
            0.473083649,
            0.891133202
          ],
          [
            73.0529704,
            4.175050313,
            38.3620959,
            0.431538681,
            0.933795272
          ],
          [
            62.05828347,
            4.699308952,
            25.44084878,
            0.439358871,
            0.851047798
          ],
          [
            47.83156185,
            2.180044477,
            89.01146673,
            0.416248644,
            0.898052733
          ],
          [
            51.54817238,
            2.877536102,
            99.78503607,
            0.491311468,
            0.889347856
          ],
          [
            75.95991457,
            4.422615552,
            91.66911956,
            0.480188932,
            0.885591267
          ]
        ],
        [
          469.93956,
          736.292684,
          660.074832,
          513.8996,
          694.61668,
          491.077468,
          713.887668,
          725.047448,
          679.6524,
          661.762784,
          694.194224,
          535.48844,
          619.878776,
          529.53012,
          492.468308,
          744.421716,
          502.953008,
          681.073508,
          489.835172,
          697.183208,
          521.610112,
          716.237712,
          680.084316,
          447.127336,
          651.895316,
          687.436548,
          706.272408,
          590.123896,
          517.538732,
          687.731572,
          757.742988,
          701.7669,
          693.83622,
          527.94118,
          698.118348,
          502.602236,
          620.24714,
          675.548032,
          507.15236,
          497.615424,
          670.999616,
          727.265256,
          486.737,
          574.512724,
          711.075228,
          735.462916,
          627.200696,
          605.798876,
          661.2599,
          715.064016,
          469.311576,
          481.8495,
          741.251796,
          493.803316,
          682.175456,
          706.5847,
          683.915532,
          662.90194,
          698.538696,
          588.235244,
          558.613548,
          669.179416,
          714.72552,
          700.717912,
          482.618768,
          594.670484,
          617.763944,
          720.16014,
          699.147396,
          543.051004,
          547.752324,
          707.99698,
          588.182364,
          597.827308,
          709.635912,
          703.0339,
          626.243492,
          744.905256,
          544.395024,
          691.416536,
          737.363144,
          581.125304,
          556.19946,
          477.14498,
          709.499844,
          626.969456,
          532.554992,
          751.622828,
          680.893636,
          642.263604,
          575.738732,
          572.4401,
          736.794412,
          726.837824,
          755.513232,
          514.553808,
          700.89144,
          670.799312,
          562.482064,
          686.947752,
          574.175904,
          675.9992,
          711.297484,
          547.005892,
          558.050716,
          699.112976,
          686.1287,
          715.487548,
          490.364688,
          535.654724
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "C:/Users/onlyj/Documents/nodeworks_projects/C2",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 277,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "sensitivity analysis": {
    "type": "Node",
    "name": "Sensitivity Analysis Tuned",
    "uniquename": "sensitivity analysis",
    "pos": [
      5155.0,
      5659.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.0010079645439704699,
          0.0015991457750743484,
          -2.4761638827522588e-05,
          0.9765712211924098,
          0.013769108624989495
        ],
        "S1_conf": [
          0.0022072085450787577,
          0.0018211512565784226,
          0.0009429807058614686,
          0.02294371363519184,
          0.004168136030740218
        ],
        "ST": [
          0.005750421734602152,
          0.003484396192481939,
          0.0012994191546238357,
          0.9800852495074946,
          0.01734733299320447
        ],
        "ST_conf": [
          0.0002612536462591599,
          0.0001285017046186651,
          6.051187161502852e-05,
          0.019257603650583308,
          0.000700662686169878
        ],
        "S2": [
          [
            NaN,
            0.0006415808583527902,
            -1.978793861014547e-05,
            0.0014636793042706042,
            0.0020641116077267634
          ],
          [
            NaN,
            NaN,
            0.0004739113474204149,
            0.0002021864236217974,
            -7.865361762228462e-05
          ],
          [
            NaN,
            NaN,
            NaN,
            0.0001608279166213089,
            0.00013658780146008805
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.0011508561145464457
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.0032649780952662983,
            0.0032602472340041403,
            0.0034913078840074297,
            0.0032484539280918257
          ],
          [
            NaN,
            NaN,
            0.002537282098609927,
            0.003207697936753965,
            0.002511241611557726
          ],
          [
            NaN,
            NaN,
            NaN,
            0.0013358187916866979,
            0.0012052010462892243
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.02827159029698603
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 1,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 73,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "parallel coordinates plot": {
    "type": "Node",
    "name": "Parallel Coordinates Plot",
    "uniquename": "parallel coordinates plot",
    "pos": [
      5154.0,
      4823.0
    ],
    "path": [
      "matplotlib",
      "Parallel Coordinates Plot"
    ],
    "terminals": {
      "table": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "value": [],
          "name": "table"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "bezier": true,
      "color": "Kmeans",
      "alpha": 0.5,
      "clusters": 2,
      "labels": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5",
        "DP3"
      ]
    },
    "layer": 70,
    "geometry": [
      505.0,
      406.0
    ]
  },
  "emulator": {
    "type": "Node",
    "name": "Emulator Tuned",
    "uniquename": "emulator",
    "pos": [
      5135.0,
      6273.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 2.9999999999999982,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 248,
    "geometry": [
      217.0,
      97.0
    ]
  },
  "emulator.0": {
    "type": "Node",
    "name": "Emulator",
    "uniquename": "emulator.0",
    "pos": [
      5133.0,
      6170.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 6.92735924e-315,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 239,
    "geometry": [
      220.0,
      95.0
    ]
  },
  "response surface.0": {
    "type": "Node",
    "name": "Response Surface Tuned",
    "uniquename": "response surface.0",
    "pos": [
      4533.0,
      5504.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 0.01,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "DP3",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            61.21880634,
            4.262878501,
            60.81054431,
            0.499348062,
            0.909726256
          ],
          [
            53.34763364,
            4.931477888,
            72.77874051,
            0.409211076,
            0.918145286
          ],
          [
            5.102686031,
            3.4398486,
            93.35037663,
            0.462908833,
            0.851539131
          ],
          [
            33.70707689,
            2.819421215,
            37.58707601,
            0.479431133,
            0.969992997
          ],
          [
            78.08006601,
            3.656785791,
            84.69799328,
            0.430834558,
            0.873881682
          ],
          [
            32.43023978,
            4.704924664,
            64.48838734,
            0.492986787,
            0.939338369
          ],
          [
            23.2093467,
            3.518447135,
            94.55723957,
            0.418258617,
            0.930479239
          ],
          [
            70.94454478,
            4.619135147,
            46.8785792,
            0.415037206,
            0.913484793
          ],
          [
            99.8311867,
            4.448630455,
            87.86291569,
            0.440843112,
            0.941049886
          ],
          [
            76.65922655,
            2.915134034,
            50.49046706,
            0.447855924,
            0.925542137
          ],
          [
            62.71676835,
            3.133976077,
            83.991381,
            0.434715069,
            0.922026751
          ],
          [
            98.59184662,
            4.212352394,
            46.25009075,
            0.474253819,
            0.963656646
          ],
          [
            14.62568546,
            2.71492271,
            32.42302105,
            0.453197495,
            0.943424892
          ],
          [
            3.877362564,
            2.99661721,
            67.00241906,
            0.484354692,
            0.913909144
          ],
          [
            70.05595611,
            3.352659997,
            27.32534869,
            0.487058262,
            0.965582943
          ],
          [
            17.36440685,
            2.929067762,
            12.61316337,
            0.412457359,
            0.867236988
          ],
          [
            40.47507954,
            2.362965774,
            45.16373767,
            0.487734543,
            0.926916091
          ],
          [
            19.95830274,
            4.289271126,
            17.03937601,
            0.444349288,
            0.920627189
          ],
          [
            13.53759665,
            3.301314215,
            18.90895094,
            0.498474244,
            0.877812106
          ],
          [
            10.50921564,
            4.791995856,
            49.9082724,
            0.407143493,
            0.974857375
          ],
          [
            37.73489649,
            4.976989873,
            96.64999579,
            0.485929347,
            0.85516888
          ],
          [
            14.18935204,
            4.113317145,
            69.1288039,
            0.419830257,
            0.893579811
          ],
          [
            66.87664981,
            2.069260922,
            94.26373231,
            0.443474457,
            0.878680137
          ],
          [
            86.996885,
            2.250854203,
            35.04201095,
            0.498058143,
            0.977642382
          ],
          [
            52.72592183,
            3.813968264,
            81.4600772,
            0.446088462,
            0.956025751
          ],
          [
            51.32769905,
            4.004029483,
            54.28798174,
            0.433602346,
            0.969227511
          ],
          [
            57.04304776,
            3.532902387,
            63.69520567,
            0.423857397,
            0.880069118
          ],
          [
            82.3906655,
            3.273833241,
            75.17729197,
            0.460220375,
            0.951808325
          ],
          [
            87.75644195,
            3.561471042,
            15.13399255,
            0.48233004,
            0.940007252
          ],
          [
            21.72888171,
            3.252789924,
            43.03239405,
            0.43720469,
            0.858746117
          ],
          [
            25.18845912,
            4.836982355,
            83.4992026,
            0.400256146,
            0.859910971
          ],
          [
            6.608334644,
            3.890709242,
            36.35965228,
            0.417190418,
            0.953538315
          ],
          [
            32.77445723,
            2.232685742,
            14.67819122,
            0.434009466,
            0.892421092
          ],
          [
            26.32309421,
            4.084416941,
            26.26558503,
            0.485198793,
            0.901439246
          ],
          [
            85.13941839,
            3.083279177,
            90.74637004,
            0.425110351,
            0.97122607
          ],
          [
            84.19555048,
            3.838844326,
            53.57879084,
            0.488890217,
            0.919355423
          ],
          [
            55.28236953,
            4.135607911,
            13.90179607,
            0.465899719,
            0.860791333
          ],
          [
            11.4838616,
            3.737969367,
            48.06343754,
            0.449500675,
            0.904152492
          ],
          [
            15.97031566,
            4.346232721,
            58.62551175,
            0.481407645,
            0.979909193
          ],
          [
            94.04615889,
            3.948270081,
            33.72215299,
            0.492173394,
            0.871097122
          ],
          [
            96.19004642,
            3.749371582,
            11.36309691,
            0.435500179,
            0.975824308
          ],
          [
            29.35775317,
            3.0157794,
            23.84495987,
            0.407899178,
            0.956977833
          ],
          [
            49.76091425,
            4.567552226,
            22.42156083,
            0.496406428,
            0.925741448
          ],
          [
            73.95808097,
            2.333362996,
            18.15585485,
            0.458527809,
            0.968027679
          ],
          [
            81.95320227,
            4.37487997,
            29.72628243,
            0.421686632,
            0.86406645
          ],
          [
            79.0809101,
            2.037578253,
            42.48098119,
            0.400946368,
            0.942293915
          ],
          [
            91.12207426,
            4.540533211,
            41.16099369,
            0.459596973,
            0.894900724
          ],
          [
            24.15970508,
            2.777853171,
            64.84615141,
            0.462305693,
            0.896120069
          ],
          [
            30.28649217,
            4.458262093,
            51.77921064,
            0.455050754,
            0.87329627
          ],
          [
            3.365043799,
            4.041614995,
            98.12293161,
            0.40374506,
            0.928623373
          ],
          [
            71.63257962,
            2.738978065,
            87.56616436,
            0.494707362,
            0.862793109
          ],
          [
            63.10700067,
            4.499191919,
            68.10931761,
            0.490098729,
            0.972422692
          ],
          [
            75.66498466,
            2.658416988,
            70.20967576,
            0.404742279,
            0.960377955
          ],
          [
            9.333128233,
            2.395337083,
            86.04736497,
            0.489371835,
            0.95441348
          ],
          [
            44.81111083,
            2.507687854,
            67.2953895,
            0.438311914,
            0.947223351
          ],
          [
            31.03747767,
            3.398102063,
            31.46848032,
            0.426589288,
            0.915069031
          ],
          [
            38.09103413,
            3.321065433,
            57.80031591,
            0.442121479,
            0.935107776
          ],
          [
            39.57050736,
            3.585908895,
            21.54398288,
            0.45173729,
            0.86874655
          ],
          [
            92.40683208,
            4.886788622,
            19.79847377,
            0.429868807,
            0.957635267
          ],
          [
            64.80775472,
            3.048416148,
            35.65879182,
            0.464534859,
            0.907328376
          ],
          [
            65.82037812,
            3.924224018,
            95.76731423,
            0.471005896,
            0.946761985
          ],
          [
            79.54523309,
            4.0637586,
            65.92532027,
            0.450208933,
            0.85685082
          ],
          [
            59.68805826,
            2.800278388,
            15.91446678,
            0.420033959,
            0.938160689
          ],
          [
            26.15060383,
            2.106067358,
            60.66298971,
            0.426158336,
            0.962886282
          ],
          [
            96.81070638,
            3.460008032,
            79.20528559,
            0.4939135,
            0.899547226
          ],
          [
            47.2215095,
            4.327887169,
            28.55812488,
            0.461430933,
            0.936684687
          ],
          [
            27.95531719,
            2.490514073,
            98.92017949,
            0.448725209,
            0.973821936
          ],
          [
            97.40890642,
            2.444626801,
            26.60360589,
            0.411391801,
            0.922385495
          ],
          [
            54.38874185,
            2.553988224,
            40.31855016,
            0.428426637,
            0.903003977
          ],
          [
            46.49973228,
            2.958472785,
            79.66223689,
            0.470082938,
            0.977103144
          ],
          [
            48.73490918,
            3.15523774,
            48.60827305,
            0.478007072,
            0.865731035
          ],
          [
            1.048717394,
            2.695975992,
            45.7302038,
            0.421979464,
            0.887374104
          ],
          [
            41.7450197,
            3.87122224,
            70.87790691,
            0.467934303,
            0.885279436
          ],
          [
            59.34477438,
            3.49951044,
            44.21477236,
            0.456258633,
            0.958790766
          ],
          [
            6.282984691,
            4.607761099,
            73.83084385,
            0.427629674,
            0.869180508
          ],
          [
            65.71352522,
            2.433910575,
            52.59469807,
            0.418104873,
            0.858163313
          ],
          [
            35.09786259,
            3.978209694,
            86.71560699,
            0.457453568,
            0.912630873
          ],
          [
            68.23387506,
            3.775980076,
            19.959749,
            0.406033367,
            0.895006337
          ],
          [
            12.62657793,
            2.57856187,
            82.37514895,
            0.476934557,
            0.934249859
          ],
          [
            85.98685994,
            4.953819828,
            57.2310843,
            0.438133743,
            0.900335824
          ],
          [
            88.48079365,
            4.298344127,
            80.43898657,
            0.408272548,
            0.882043568
          ],
          [
            21.09345376,
            4.891515959,
            38.8928683,
            0.471899249,
            0.88076735
          ],
          [
            28.31575285,
            3.67719602,
            73.81781755,
            0.474665639,
            0.923559774
          ],
          [
            19.70434601,
            3.625325706,
            51.2797987,
            0.495902602,
            0.949237456
          ],
          [
            40.66580343,
            4.516102241,
            10.61443607,
            0.423119701,
            0.94929826
          ],
          [
            89.8171221,
            2.645436262,
            96.80315357,
            0.454380257,
            0.910291353
          ],
          [
            56.00329188,
            2.131693766,
            31.20578257,
            0.475644881,
            0.950967033
          ],
          [
            35.22777832,
            2.614151254,
            56.51128401,
            0.403615878,
            0.876736518
          ],
          [
            93.52522508,
            2.856151176,
            71.45807517,
            0.445414182,
            0.854243539
          ],
          [
            69.2525305,
            4.834687505,
            78.55581938,
            0.452233315,
            0.929667066
          ],
          [
            7.327706725,
            2.010938158,
            20.87033273,
            0.469680214,
            0.91720859
          ],
          [
            18.44863893,
            4.65193354,
            89.98742569,
            0.465113842,
            0.962186779
          ],
          [
            45.21129545,
            3.710736761,
            39.51867624,
            0.410287725,
            0.8530919
          ],
          [
            90.81448374,
            3.197731707,
            61.71620543,
            0.413096195,
            0.945625494
          ],
          [
            42.86379467,
            3.219203426,
            92.51970374,
            0.402258249,
            0.906000696
          ],
          [
            57.8759597,
            2.277643024,
            75.46874375,
            0.483159345,
            0.872417018
          ],
          [
            17.15824056,
            2.32335941,
            76.52178744,
            0.432190098,
            0.908980324
          ],
          [
            2.73762426,
            2.148345147,
            62.74639872,
            0.456576092,
            0.864883475
          ],
          [
            94.73970703,
            2.205012856,
            55.61336736,
            0.466458088,
            0.93205323
          ],
          [
            8.442301598,
            3.093211926,
            28.84001308,
            0.440957025,
            0.883578881
          ],
          [
            83.7924221,
            2.531070507,
            23.99523305,
            0.46871849,
            0.875288232
          ],
          [
            43.58022484,
            4.765031996,
            34.53194921,
            0.446439536,
            0.888967251
          ],
          [
            36.59381966,
            4.195619154,
            77.80961188,
            0.413780682,
            0.966487323
          ],
          [
            80.57112614,
            4.730390366,
            12.11768373,
            0.478312984,
            0.904647955
          ],
          [
            72.35653028,
            3.387894714,
            59.11914031,
            0.473083649,
            0.891133202
          ],
          [
            73.0529704,
            4.175050313,
            38.3620959,
            0.431538681,
            0.933795272
          ],
          [
            62.05828347,
            4.699308952,
            25.44084878,
            0.439358871,
            0.851047798
          ],
          [
            47.83156185,
            2.180044477,
            89.01146673,
            0.416248644,
            0.898052733
          ],
          [
            51.54817238,
            2.877536102,
            99.78503607,
            0.491311468,
            0.889347856
          ],
          [
            75.95991457,
            4.422615552,
            91.66911956,
            0.480188932,
            0.885591267
          ]
        ],
        [
          469.93956,
          736.292684,
          660.074832,
          513.8996,
          694.61668,
          491.077468,
          713.887668,
          725.047448,
          679.6524,
          661.762784,
          694.194224,
          535.48844,
          619.878776,
          529.53012,
          492.468308,
          744.421716,
          502.953008,
          681.073508,
          489.835172,
          697.183208,
          521.610112,
          716.237712,
          680.084316,
          447.127336,
          651.895316,
          687.436548,
          706.272408,
          590.123896,
          517.538732,
          687.731572,
          757.742988,
          701.7669,
          693.83622,
          527.94118,
          698.118348,
          502.602236,
          620.24714,
          675.548032,
          507.15236,
          497.615424,
          670.999616,
          727.265256,
          486.737,
          574.512724,
          711.075228,
          735.462916,
          627.200696,
          605.798876,
          661.2599,
          715.064016,
          469.311576,
          481.8495,
          741.251796,
          493.803316,
          682.175456,
          706.5847,
          683.915532,
          662.90194,
          698.538696,
          588.235244,
          558.613548,
          669.179416,
          714.72552,
          700.717912,
          482.618768,
          594.670484,
          617.763944,
          720.16014,
          699.147396,
          543.051004,
          547.752324,
          707.99698,
          588.182364,
          597.827308,
          709.635912,
          703.0339,
          626.243492,
          744.905256,
          544.395024,
          691.416536,
          737.363144,
          581.125304,
          556.19946,
          477.14498,
          709.499844,
          626.969456,
          532.554992,
          751.622828,
          680.893636,
          642.263604,
          575.738732,
          572.4401,
          736.794412,
          726.837824,
          755.513232,
          514.553808,
          700.89144,
          670.799312,
          562.482064,
          686.947752,
          574.175904,
          675.9992,
          711.297484,
          547.005892,
          558.050716,
          699.112976,
          686.1287,
          715.487548,
          490.364688,
          535.654724
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "C:/Users/onlyj/Documents/nodeworks_projects/C2",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 270,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "display": {
    "type": "Node",
    "name": "Test Sample Results",
    "uniquename": "display",
    "pos": [
      5866.0,
      6082.0
    ],
    "path": [
      "general",
      "Display"
    ],
    "terminals": {
      "input": {
        "value": null,
        "flipped": false,
        "opts": {
          "widget": "textedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "input"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 271,
    "geometry": [
      382.0,
      359.0
    ]
  },
  "sensitivity analysis.0": {
    "type": "Node",
    "name": "Sensitivity Analysis",
    "uniquename": "sensitivity analysis.0",
    "pos": [
      5155.0,
      5264.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.006494719281614471,
          0.0030391674399633936,
          0.0007875365543329816,
          0.9571663477868346,
          0.015466939898978283
        ],
        "S1_conf": [
          0.003328723844399989,
          0.003410611139602101,
          0.0026952880884030775,
          0.021465335669004548,
          0.00413711270966136
        ],
        "ST": [
          0.014265869731974277,
          0.010747443605904206,
          0.008480313098858348,
          0.9745057508435567,
          0.02777537840297291
        ],
        "ST_conf": [
          0.0005593229383253383,
          0.0005012196739813716,
          0.000348206357833065,
          0.01852465599875166,
          0.0012464942086649468
        ],
        "S2": [
          [
            NaN,
            -0.0037843945824544154,
            -0.004808687507305863,
            -2.557118207913156e-05,
            -0.003677628346225297
          ],
          [
            NaN,
            NaN,
            -0.0008144222434939784,
            0.0004071391541362601,
            -0.0005486941759056813
          ],
          [
            NaN,
            NaN,
            NaN,
            0.000441280127331356,
            -0.0006772245978567855
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.004403867639320557
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.005162503345860897,
            0.005100996969702166,
            0.0047982526708282265,
            0.005220824031812111
          ],
          [
            NaN,
            NaN,
            0.004761082437189456,
            0.00497531406224428,
            0.004718534378222439
          ],
          [
            NaN,
            NaN,
            NaN,
            0.0035242013994251165,
            0.0039932471079788855
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.02342767233463132
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 1,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 64,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "connection": {
    "type": "Connection",
    "name": "connection",
    "line": "cubic",
    "uniquename": "connection",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.0": {
    "type": "Connection",
    "name": "connection.0",
    "line": "cubic",
    "uniquename": "connection.0",
    "input": [
      "code",
      "returnOut"
    ],
    "output": [
      "display",
      "input"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.1": {
    "type": "Connection",
    "name": "connection.1",
    "line": "cubic",
    "uniquename": "connection.1",
    "input": [
      "emulator",
      "result"
    ],
    "output": [
      "code",
      "r2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.2": {
    "type": "Connection",
    "name": "connection.2",
    "line": "cubic",
    "uniquename": "connection.2",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "emulator.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.3": {
    "type": "Connection",
    "name": "connection.3",
    "line": "cubic",
    "uniquename": "connection.3",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "sensitivity analysis",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.4": {
    "type": "Connection",
    "name": "connection.4",
    "line": "cubic",
    "uniquename": "connection.4",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator.0",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.5": {
    "type": "Connection",
    "name": "connection.5",
    "line": "cubic",
    "uniquename": "connection.5",
    "input": [
      "sensitivity analysis",
      "sensitivities"
    ],
    "output": [
      "code.0",
      "sens2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.6": {
    "type": "Connection",
    "name": "connection.6",
    "line": "cubic",
    "uniquename": "connection.6",
    "input": [
      "response surface",
      "Response matrix"
    ],
    "output": [
      "parallel coordinates plot",
      "table"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.7": {
    "type": "Connection",
    "name": "connection.7",
    "line": "cubic",
    "uniquename": "connection.7",
    "input": [
      "emulator.0",
      "result"
    ],
    "output": [
      "code",
      "r1"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.8": {
    "type": "Connection",
    "name": "connection.8",
    "line": "cubic",
    "uniquename": "connection.8",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "sensitivity analysis.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.9": {
    "type": "Connection",
    "name": "connection.9",
    "line": "cubic",
    "uniquename": "connection.9",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "emulator",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.10": {
    "type": "Connection",
    "name": "connection.10",
    "line": "cubic",
    "uniquename": "connection.10",
    "input": [
      "sensitivity analysis.0",
      "sensitivities"
    ],
    "output": [
      "code.0",
      "sens1"
    ],
    "controlpoints": [],
    "feedback": false
  }
}