{
  "parallel coordinates plot": {
    "type": "Node",
    "name": "Parallel Coordinates Plot",
    "uniquename": "parallel coordinates plot",
    "pos": [
      5196.0,
      4571.0
    ],
    "path": [
      "matplotlib",
      "Parallel Coordinates Plot"
    ],
    "terminals": {
      "table": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "value": [],
          "name": "table"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "bezier": true,
      "color": "Kmeans",
      "alpha": 0.5,
      "clusters": 2,
      "labels": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5",
        "y2"
      ]
    },
    "layer": 288,
    "geometry": [
      505.0,
      406.0
    ]
  },
  "code": {
    "type": "Node",
    "name": "Write sensitivities",
    "uniquename": "code",
    "pos": [
      5751.0,
      5120.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "sens1, sens2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "name": "returnOut"
        }
      },
      "sens1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens1"
        }
      },
      "sens2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "sens2"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "import os\n\nSAVE_DIR = r'C:\\Users\\onlyj\\Documents\\nodeworks_projects\\C3'\nFNAME = 'C3_Nodeworks_SA_y2.csv'\n\nT1 = sens1.get('ST')\nS1 = sens1.get('ST_conf')\n\nT2 = sens2.get('ST')\nS2 = sens2.get('ST_conf')\n\nvar_list = [\n    \"t1:P_0\", \"t2:beta\", \"t3:StatWeight\", \"t4:ep_g\", \"t5:VelfacCoeff\"\n    ]\n\nwith open(os.path.join(SAVE_DIR, FNAME), 'w') as f:\n    f.write(\"UQTool,Params,Sobol_mean,Sobol_std\\n\")\n    \n    for v, t, s in zip(var_list, T1, S1):\n        f.write(f\"Nodeworks (GPM),{v},{t},{s}\\n\")\n\n    for v, t, s in zip(var_list, T2, S2):\n        f.write(f\"Nodeworks (GPM Tuned),{v},{t},{s}\\n\")\n\n\nreturnOut = None"
    },
    "layer": 318,
    "geometry": [
      574.0,
      401.0
    ]
  },
  "response surface": {
    "type": "Node",
    "name": "Response Surface",
    "uniquename": "response surface",
    "pos": [
      4572.0,
      4605.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 1e-10,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 2,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "y2",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            115.8923076,
            2.757294572,
            153.2196436,
            0.392295581,
            0.882036645
          ],
          [
            228.3117858,
            4.024961816,
            79.35593714,
            0.490816665,
            0.859088484
          ],
          [
            48.46188178,
            2.352365417,
            77.44889015,
            0.39547985,
            0.923207095
          ],
          [
            244.3298011,
            3.576221378,
            99.54971123,
            0.496715305,
            0.918379059
          ],
          [
            131.8929191,
            2.583340772,
            121.9515094,
            0.403080503,
            0.857743471
          ],
          [
            226.3411412,
            2.685542174,
            56.69683673,
            0.411042731,
            0.906158552
          ],
          [
            162.9109831,
            4.620520592,
            159.2363081,
            0.35,
            0.862279879
          ],
          [
            32.66821865,
            3.418927106,
            72.51556956,
            0.386998716,
            0.94303869
          ],
          [
            181.7798084,
            4.898572007,
            164.3400135,
            0.460278275,
            0.923756727
          ],
          [
            80.03397622,
            2.621564495,
            194.306804,
            0.376430679,
            0.914301344
          ],
          [
            140.8458817,
            2.84745962,
            206.344835,
            0.389628778,
            0.947720999
          ],
          [
            66.58100074,
            4.515809429,
            123.5905364,
            0.429074451,
            0.954147061
          ],
          [
            125.6723807,
            3.412569227,
            20.99259083,
            0.458335339,
            0.877322052
          ],
          [
            77.492924,
            4.169463563,
            91.11133906,
            0.407442433,
            0.879463607
          ],
          [
            132.6423304,
            4.014559679,
            11.38309396,
            0.421703278,
            0.9111221
          ],
          [
            233.5907426,
            2.406315989,
            46.48979697,
            0.475484884,
            0.944919529
          ],
          [
            47.51235166,
            3.77024381,
            163.9640498,
            0.432694846,
            0.972360238
          ],
          [
            1.0,
            4.469163302,
            66.42014252,
            0.456265149,
            0.893119392
          ],
          [
            72.63429407,
            2.188667831,
            27.32174432,
            0.483275623,
            0.869034638
          ],
          [
            6.68028511,
            3.266186375,
            39.64548591,
            0.37352029,
            0.861220634
          ],
          [
            143.7349991,
            4.575295805,
            103.1048232,
            0.371156727,
            0.937036467
          ],
          [
            11.28502792,
            3.507781007,
            172.539852,
            0.450408396,
            0.902993158
          ],
          [
            146.1440512,
            3.153764549,
            75.17262283,
            0.49431005,
            0.885390582
          ],
          [
            116.7497882,
            2.0,
            34.20550084,
            0.49571261,
            0.976571306
          ],
          [
            24.8147223,
            3.084057515,
            23.43908969,
            0.359396594,
            0.908420921
          ],
          [
            157.683177,
            2.823736448,
            176.8684691,
            0.47334219,
            0.874108357
          ],
          [
            36.13654612,
            5.0,
            149.5717067,
            0.478857839,
            0.911931296
          ],
          [
            177.3565191,
            2.930686493,
            62.70455122,
            0.362861142,
            0.920439517
          ],
          [
            141.6531424,
            4.210967378,
            42.91341193,
            0.425941777,
            0.851753935
          ],
          [
            193.3767469,
            3.692718323,
            38.97544439,
            0.464991034,
            0.938502171
          ],
          [
            41.9148212,
            2.667875801,
            105.9886417,
            0.461660262,
            0.863233266
          ],
          [
            246.949189,
            2.968163219,
            13.92622226,
            0.479747167,
            0.853434286
          ],
          [
            51.23072169,
            3.377727224,
            88.95071842,
            0.470678013,
            0.913654237
          ],
          [
            92.79762609,
            2.338694057,
            170.6493984,
            0.360838454,
            0.951878904
          ],
          [
            190.8255504,
            3.313821728,
            198.9054439,
            0.423250847,
            0.890105323
          ],
          [
            236.8225233,
            3.934249706,
            177.619635,
            0.367924201,
            0.925427287
          ],
          [
            155.927926,
            3.491745722,
            28.68882919,
            0.409065816,
            0.95498498
          ],
          [
            56.59383907,
            2.101879334,
            119.2123489,
            0.355355761,
            0.888645465
          ],
          [
            211.7806454,
            3.454238609,
            181.4095225,
            0.358292883,
            0.880381379
          ],
          [
            187.6722034,
            2.314160897,
            85.07213704,
            0.485031762,
            0.898418652
          ],
          [
            20.10142395,
            2.553901262,
            160.8109119,
            0.493139994,
            0.936322847
          ],
          [
            59.78016408,
            4.683501311,
            174.8606219,
            0.412639171,
            0.859558163
          ],
          [
            219.5351715,
            4.549711676,
            205.7580289,
            0.471476874,
            0.900278061
          ],
          [
            12.45227916,
            2.284966931,
            184.7636768,
            0.384189022,
            0.85
          ],
          [
            242.917518,
            2.24108003,
            36.71938065,
            0.431128742,
            0.883793615
          ],
          [
            191.8506717,
            4.375655624,
            129.9808045,
            0.361190797,
            0.978550572
          ],
          [
            29.59292498,
            2.900753099,
            129.6125621,
            0.409588357,
            0.891776032
          ],
          [
            172.447951,
            3.879471932,
            197.8505518,
            0.468627062,
            0.952420174
          ],
          [
            214.1380302,
            4.244595605,
            70.96962382,
            0.433392697,
            0.91538012
          ],
          [
            179.0218025,
            4.092242936,
            25.30498853,
            0.385591997,
            0.886617759
          ],
          [
            96.91041685,
            3.68622785,
            201.2081215,
            0.498039977,
            0.870855985
          ],
          [
            88.51374816,
            2.979316106,
            182.6757475,
            0.427532254,
            0.89730228
          ],
          [
            221.8385382,
            2.150724794,
            94.46150336,
            0.373742622,
            0.955770801
          ],
          [
            20.91315076,
            3.892068059,
            110.6898641,
            0.391108035,
            0.873022444
          ],
          [
            99.06487416,
            3.094723514,
            107.3011131,
            0.382483653,
            0.970365088
          ],
          [
            8.562579445,
            2.789053652,
            86.55931351,
            0.424805743,
            0.966225614
          ],
          [
            236.3955852,
            3.115929932,
            141.3564586,
            0.437582238,
            0.867666946
          ],
          [
            166.7172125,
            3.593853206,
            136.4147216,
            0.376269333,
            0.899670526
          ],
          [
            63.33034234,
            3.346527461,
            146.0678381,
            0.369788898,
            0.852542277
          ],
          [
            223.4230425,
            3.621288875,
            117.6104873,
            0.454338188,
            0.977051098
          ],
          [
            210.7846506,
            4.961318366,
            21.22820424,
            0.445268853,
            0.96372506
          ],
          [
            40.9660926,
            3.941761802,
            57.56997577,
            0.444451504,
            0.885650198
          ],
          [
            112.1645408,
            4.122188087,
            116.6466312,
            0.481240148,
            0.921868931
          ],
          [
            207.0638287,
            2.759727758,
            112.9900499,
            0.5,
            0.941373997
          ],
          [
            123.8676992,
            2.437691495,
            143.5033855,
            0.463326826,
            0.904663227
          ],
          [
            79.20041984,
            2.884506026,
            69.54544337,
            0.465970506,
            0.975009493
          ],
          [
            37.22566988,
            2.478767399,
            202.5409066,
            0.416322751,
            0.958363038
          ],
          [
            165.3257577,
            3.031791518,
            92.5454934,
            0.44787716,
            0.934756891
          ],
          [
            43.69159855,
            4.870042079,
            10.31724175,
            0.366611808,
            0.875756285
          ],
          [
            203.8812075,
            4.711210613,
            124.9126157,
            0.387632953,
            0.910361077
          ],
          [
            30.51892361,
            4.135695188,
            186.8222202,
            0.462093064,
            0.967953389
          ],
          [
            216.8942062,
            3.051803072,
            166.9687427,
            0.401708484,
            0.961482803
          ],
          [
            185.4486521,
            4.069452206,
            147.3843142,
            0.414152679,
            0.94441167
          ],
          [
            182.9329874,
            2.61988661,
            17.51742797,
            0.352013782,
            0.971486871
          ],
          [
            95.23472579,
            4.6185692,
            17.73798195,
            0.438448829,
            0.919660866
          ],
          [
            102.7847873,
            3.240802961,
            134.4846609,
            0.419171488,
            0.927193133
          ],
          [
            174.7307168,
            2.534342006,
            101.6180597,
            0.43425775,
            0.876797276
          ],
          [
            230.9906,
            4.336491215,
            156.7312209,
            0.380701587,
            0.895187096
          ],
          [
            27.47587767,
            4.662868355,
            59.83771511,
            0.489115802,
            0.959561481
          ],
          [
            239.6537084,
            4.783893047,
            195.1014485,
            0.396698824,
            0.973735439
          ],
          [
            73.91644537,
            3.657973076,
            158.5522516,
            0.397418689,
            0.933630559
          ],
          [
            15.43394161,
            4.788946949,
            131.9637092,
            0.467794647,
            0.881464812
          ],
          [
            120.7218825,
            3.785056097,
            83.72297164,
            0.36519652,
            0.962493161
          ],
          [
            118.7894293,
            2.075336534,
            178.80202,
            0.436044511,
            0.940473037
          ],
          [
            129.6028841,
            4.819837127,
            55.18780024,
            0.356307784,
            0.930709509
          ],
          [
            250.0,
            2.025462335,
            115.3410606,
            0.423051008,
            0.932299747
          ],
          [
            135.101624,
            3.293733314,
            127.212363,
            0.477860518,
            0.95779135
          ],
          [
            90.03556097,
            4.34830124,
            96.15558852,
            0.474490416,
            0.855579542
          ],
          [
            148.7726227,
            2.233857884,
            137.4213517,
            0.451351359,
            0.968684546
          ],
          [
            199.8718038,
            2.386751093,
            154.0630107,
            0.443009881,
            0.856366589
          ],
          [
            53.96039391,
            4.264164578,
            15.32151491,
            0.377742089,
            0.939049242
          ],
          [
            100.60517,
            4.746355406,
            75.59888718,
            0.455766544,
            0.946998412
          ],
          [
            159.726417,
            2.156110964,
            188.4532525,
            0.406167428,
            0.916812516
          ],
          [
            85.68120459,
            4.937539463,
            97.9490734,
            0.400527114,
            0.901013062
          ],
          [
            65.65983445,
            2.716425827,
            32.16730139,
            0.453207454,
            0.925986009
          ],
          [
            105.1101243,
            2.491665584,
            50.04183911,
            0.368685505,
            0.894136306
          ],
          [
            16.82372939,
            4.407690752,
            30.64177879,
            0.404255891,
            0.928585498
          ],
          [
            136.7506706,
            4.438314317,
            169.5588059,
            0.489793429,
            0.890866776
          ],
          [
            195.7946865,
            4.849392527,
            81.38294518,
            0.417983161,
            0.871701871
          ],
          [
            107.6668513,
            4.309911488,
            191.5280396,
            0.449037025,
            0.866039256
          ],
          [
            110.7466698,
            3.548271662,
            62.90080876,
            0.41556345,
            0.98
          ],
          [
            170.2295647,
            4.506187829,
            47.53666822,
            0.393743736,
            0.967384648
          ],
          [
            153.0439574,
            3.810625556,
            109.3083745,
            0.441528684,
            0.907420925
          ],
          [
            68.74449127,
            3.851558747,
            44.35654374,
            0.351075836,
            0.904148601
          ],
          [
            58.30066634,
            3.174869096,
            50.31165424,
            0.439779171,
            0.949931131
          ],
          [
            201.9268947,
            3.204192224,
            191.0892585,
            0.486988201,
            0.92971131
          ],
          [
            4.189908871,
            4.193457176,
            140.0514821,
            0.353732374,
            0.9486617
          ],
          [
            82.97879041,
            3.973552973,
            150.2711472,
            0.485863691,
            0.964378062
          ],
          [
            151.8486419,
            2.071701467,
            66.98041212,
            0.379919035,
            0.867166773
          ],
          [
            206.5685689,
            3.742414301,
            52.19519615,
            0.399163186,
            0.864196824
          ]
        ],
        [
          492.0031501,
          368.9365882,
          742.0714018,
          414.8924935,
          540.8967162,
          692.1082309,
          452.0342063,
          790.4405786,
          295.8327841,
          463.2706278,
          544.0121337,
          656.8254261,
          584.7607483,
          580.0889167,
          683.0361173,
          626.165231,
          639.9942657,
          252.7452638,
          529.7196997,
          597.2093876,
          807.243318,
          179.0568041,
          411.2441491,
          553.9218482,
          683.378332,
          206.3490928,
          209.1330398,
          768.21813,
          601.3180852,
          614.3854632,
          365.6075765,
          540.3202901,
          465.8459116,
          845.2550563,
          219.7025303,
          625.0299466,
          728.5202149,
          750.5586255,
          486.8298282,
          469.9684099,
          260.5448139,
          198.4032773,
          134.52698,
          186.7569047,
          624.9828331,
          961.8608611,
          450.7150862,
          270.9547705,
          640.9214706,
          667.0620544,
          102.9528765,
          270.5513798,
          889.6108793,
          433.9754028,
          901.5951972,
          824.4811592,
          342.1566402,
          647.2437292,
          439.7401129,
          816.533284,
          679.8379403,
          534.5165004,
          377.247237,
          436.1538602,
          373.1612365,
          702.6765558,
          454.8796226,
          636.4289651,
          701.7975595,
          639.1951952,
          364.6841679,
          737.0993741,
          629.9980605,
          841.8777964,
          606.9137192,
          577.5980338,
          550.7904179,
          519.0050719,
          671.5069277,
          726.3174458,
          567.5892041,
          188.9246134,
          858.7619153,
          476.9107332,
          790.4909068,
          681.5334684,
          513.4749118,
          315.8544949,
          710.2354052,
          299.5379055,
          701.0489523,
          653.1351801,
          454.2316487,
          611.4686024,
          613.7790254,
          728.6188919,
          636.736094,
          188.2726993,
          557.7578809,
          169.3488741,
          681.3076309,
          798.5477284,
          508.6250261,
          736.6609618,
          686.0570146,
          217.2928017,
          748.7305363,
          425.6342688,
          743.6220801,
          662.0439835
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "C:/Users/onlyj/Documents/nodeworks_projects/C3",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 306,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "code.0": {
    "type": "Node",
    "name": "Code",
    "uniquename": "code.0",
    "pos": [
      5464.0,
      5802.0
    ],
    "path": [
      "code",
      "Code"
    ],
    "terminals": {
      "arguments": {
        "value": "r1, r2",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "dtype": "<class 'str'>",
          "name": "arguments"
        }
      },
      "functionOut": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'method'>",
          "name": "functionOut"
        }
      },
      "returnOut": {
        "value": "None",
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'str'>",
          "name": "returnOut"
        }
      },
      "r1": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r1"
        }
      },
      "r2": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "r2"
        }
      }
    },
    "tunnel": false,
    "forcerun": true,
    "hidden": false,
    "customState": {
      "code": "s_list = []\n\nfor p1, p2 in zip(r1, r2):\n    s_list.append(f'{p1},{p2}')\n    \nreturnOut = '\\n'.join(s_list)"
    },
    "layer": 253,
    "geometry": [
      400.0,
      400.0
    ]
  },
  "emulator": {
    "type": "Node",
    "name": "Emulator",
    "uniquename": "emulator",
    "pos": [
      5175.0,
      5918.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 38.50000000000003,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 239,
    "geometry": [
      220.0,
      95.0
    ]
  },
  "emulator.0": {
    "type": "Node",
    "name": "Emulator Tuned",
    "uniquename": "emulator.0",
    "pos": [
      5177.0,
      6021.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Emulator"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "points": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "points"
        }
      },
      "result": {
        "value": 39.0,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'numpy.ndarray'>",
          "name": "result"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 248,
    "geometry": [
      217.0,
      97.0
    ]
  },
  "sensitivity analysis": {
    "type": "Node",
    "name": "Sensitivity Analysis",
    "uniquename": "sensitivity analysis",
    "pos": [
      5197.0,
      5012.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.02325841736235625,
          0.013463214004639323,
          0.31012263403396484,
          0.2939347998594144,
          0.2642912018417787
        ],
        "S1_conf": [
          0.005793113698288158,
          0.004380925592631296,
          0.014785668029632687,
          0.014042342222453028,
          0.015400249676253678
        ],
        "ST": [
          0.042398812124349476,
          0.0322407865194608,
          0.3829517194061389,
          0.34137119581245573,
          0.33022731892008017
        ],
        "ST_conf": [
          0.0016268584943942962,
          0.0016955145474754653,
          0.012539027323596226,
          0.01096210442336999,
          0.014103597053945576
        ],
        "S2": [
          [
            NaN,
            -0.0007459503633204263,
            -0.00030672033878759164,
            -0.0011441519043290382,
            0.0035057733495320598
          ],
          [
            NaN,
            NaN,
            0.003310444590637285,
            0.002647046594816571,
            0.0026833970384987915
          ],
          [
            NaN,
            NaN,
            NaN,
            0.017947653186929646,
            0.03103769169277576
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.0072072684609761906
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.008787541298143403,
            0.009432911765490942,
            0.009001120578230083,
            0.009709164652026517
          ],
          [
            NaN,
            NaN,
            0.006278566464018852,
            0.007593124745201559,
            0.007584211759278632
          ],
          [
            NaN,
            NaN,
            NaN,
            0.023661722969631392,
            0.02261822098939065
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.02238940805955305
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 1,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 64,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "read csv": {
    "type": "Node",
    "name": "Test Samples",
    "uniquename": "read csv",
    "pos": [
      4827.0,
      5932.0
    ],
    "path": [
      "pandas",
      "Read CSV"
    ],
    "terminals": {
      "file": {
        "value": "C:/Users/onlyj/Documents/nodeworks_projects/C3/C3_10new_samples.csv",
        "flipped": false,
        "opts": {
          "widget": "browse",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "file"
        }
      },
      "sep": {
        "value": ",",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "value": ",",
          "name": "sep"
        }
      },
      "parse dates": {
        "value": false,
        "flipped": false,
        "opts": {
          "widget": "checkbox",
          "in": true,
          "dtype": "<class 'bool'>",
          "name": "parse dates"
        }
      },
      "index column": {
        "value": "",
        "flipped": false,
        "opts": {
          "widget": "lineedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "index column"
        }
      },
      "dataframe": {
        "value": {
          "__nw_type__": "pd_frame",
          "data": "{}"
        },
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'pandas.core.frame.DataFrame'>",
          "name": "dataframe"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 304,
    "geometry": [
      193.0,
      168.0
    ]
  },
  "response surface.0": {
    "type": "Node",
    "name": "Response Surface Tuned",
    "uniquename": "response surface.0",
    "pos": [
      4575.0,
      5252.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Response Surface"
    ],
    "terminals": {
      "matrix/response": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "dtype": "<class 'list'>",
          "multiinput": true,
          "name": "matrix/response"
        }
      },
      "btns": {
        "value": [
          false,
          false
        ],
        "flipped": false,
        "opts": {
          "widget": "toolbuttons",
          "showlabel": false,
          "dtype": "<class 'list'>",
          "buttons": [
            "add",
            "remove"
          ],
          "name": "btns"
        }
      },
      "Model": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'nodeworks.tools.models.GPRS'>",
          "name": "Model"
        }
      },
      "Response matrix": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'list'>",
          "name": "Response matrix"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "parameters": {
        "poly_degree": 3,
        "poly_tol": 0.0001,
        "poly_max_iter": 10000,
        "poly_solver": "lsqr",
        "poly_regressor": "linear",
        "gp_kernel": "Constant*RBF",
        "gp_alpha": 0.01,
        "gp_optimizer": "fmin_l_bfgs_b",
        "gp_n_restart_optimizer": 10,
        "gp_normalize": true,
        "mlp_hidden_layer_sizes": [
          100
        ],
        "mlp_actiavtion": "relu",
        "mlp_solver": "adam",
        "mlp_max_iter": 200,
        "svm_kernel": "rbf",
        "svm_degree": 3,
        "svm_tol": 0.001,
        "svm_max_iter": -1,
        "dec_tree_criterion": "mse",
        "dec_tree_max_depth": 99,
        "dec_tree_max_features": "auto",
        "rnd_forest_n_estimators": 10,
        "rnd_forest_criterion": "mse",
        "rnd_forest_max_depth": 99,
        "rnd_forest_min_samples_split": 2,
        "rnd_forest_min_samples_leaf": 1,
        "rnd_forest_max_features": "auto",
        "grad_boost_loss": "ls",
        "grad_boost_learning_rate": 0.1,
        "grad_boost_n_estimators": 100,
        "grad_boost_subsample": 1.0,
        "grad_boost_criterion": "friedman_mse",
        "grad_boost_min_samples_split": 2,
        "grad_boost_min_samples_leaf": 1,
        "grad_boost_min_weight_fraction_leaf": 0.0,
        "grad_boost_max_depth": 3,
        "grad_boost_min_impurity_decrease": 0,
        "grad_boost_tol": 0.0001,
        "nearest_rescale": false,
        "linear_rescale": false,
        "ct_tolerance": 1e-06,
        "ct_rescale": false,
        "rbf_function": "multiquadric",
        "rbf_epsilon": 1.0,
        "rbf_smooth": 0.0,
        "mars_max_terms": 100,
        "mars_max_degree": 1,
        "mars_penalty": 3.0
      },
      "cross_val_pts": 0,
      "cross_val_repeats": 1,
      "current_tab": 0,
      "fit_models": {
        "gaussian process": true,
        "polynomial": true,
        "multilayer perceptron": false,
        "support vector machine": true,
        "decision tree": true,
        "random forest": true,
        "gradient boosting": true,
        "nearest interpolator": false,
        "linear interpolator": false,
        "cubic interpolator": false,
        "radial basis function": true
      },
      "response_name": "y2",
      "input_data": [
        [
          [
            "t1",
            "t2",
            "t3",
            "t4",
            "t5"
          ],
          [
            115.8923076,
            2.757294572,
            153.2196436,
            0.392295581,
            0.882036645
          ],
          [
            228.3117858,
            4.024961816,
            79.35593714,
            0.490816665,
            0.859088484
          ],
          [
            48.46188178,
            2.352365417,
            77.44889015,
            0.39547985,
            0.923207095
          ],
          [
            244.3298011,
            3.576221378,
            99.54971123,
            0.496715305,
            0.918379059
          ],
          [
            131.8929191,
            2.583340772,
            121.9515094,
            0.403080503,
            0.857743471
          ],
          [
            226.3411412,
            2.685542174,
            56.69683673,
            0.411042731,
            0.906158552
          ],
          [
            162.9109831,
            4.620520592,
            159.2363081,
            0.35,
            0.862279879
          ],
          [
            32.66821865,
            3.418927106,
            72.51556956,
            0.386998716,
            0.94303869
          ],
          [
            181.7798084,
            4.898572007,
            164.3400135,
            0.460278275,
            0.923756727
          ],
          [
            80.03397622,
            2.621564495,
            194.306804,
            0.376430679,
            0.914301344
          ],
          [
            140.8458817,
            2.84745962,
            206.344835,
            0.389628778,
            0.947720999
          ],
          [
            66.58100074,
            4.515809429,
            123.5905364,
            0.429074451,
            0.954147061
          ],
          [
            125.6723807,
            3.412569227,
            20.99259083,
            0.458335339,
            0.877322052
          ],
          [
            77.492924,
            4.169463563,
            91.11133906,
            0.407442433,
            0.879463607
          ],
          [
            132.6423304,
            4.014559679,
            11.38309396,
            0.421703278,
            0.9111221
          ],
          [
            233.5907426,
            2.406315989,
            46.48979697,
            0.475484884,
            0.944919529
          ],
          [
            47.51235166,
            3.77024381,
            163.9640498,
            0.432694846,
            0.972360238
          ],
          [
            1.0,
            4.469163302,
            66.42014252,
            0.456265149,
            0.893119392
          ],
          [
            72.63429407,
            2.188667831,
            27.32174432,
            0.483275623,
            0.869034638
          ],
          [
            6.68028511,
            3.266186375,
            39.64548591,
            0.37352029,
            0.861220634
          ],
          [
            143.7349991,
            4.575295805,
            103.1048232,
            0.371156727,
            0.937036467
          ],
          [
            11.28502792,
            3.507781007,
            172.539852,
            0.450408396,
            0.902993158
          ],
          [
            146.1440512,
            3.153764549,
            75.17262283,
            0.49431005,
            0.885390582
          ],
          [
            116.7497882,
            2.0,
            34.20550084,
            0.49571261,
            0.976571306
          ],
          [
            24.8147223,
            3.084057515,
            23.43908969,
            0.359396594,
            0.908420921
          ],
          [
            157.683177,
            2.823736448,
            176.8684691,
            0.47334219,
            0.874108357
          ],
          [
            36.13654612,
            5.0,
            149.5717067,
            0.478857839,
            0.911931296
          ],
          [
            177.3565191,
            2.930686493,
            62.70455122,
            0.362861142,
            0.920439517
          ],
          [
            141.6531424,
            4.210967378,
            42.91341193,
            0.425941777,
            0.851753935
          ],
          [
            193.3767469,
            3.692718323,
            38.97544439,
            0.464991034,
            0.938502171
          ],
          [
            41.9148212,
            2.667875801,
            105.9886417,
            0.461660262,
            0.863233266
          ],
          [
            246.949189,
            2.968163219,
            13.92622226,
            0.479747167,
            0.853434286
          ],
          [
            51.23072169,
            3.377727224,
            88.95071842,
            0.470678013,
            0.913654237
          ],
          [
            92.79762609,
            2.338694057,
            170.6493984,
            0.360838454,
            0.951878904
          ],
          [
            190.8255504,
            3.313821728,
            198.9054439,
            0.423250847,
            0.890105323
          ],
          [
            236.8225233,
            3.934249706,
            177.619635,
            0.367924201,
            0.925427287
          ],
          [
            155.927926,
            3.491745722,
            28.68882919,
            0.409065816,
            0.95498498
          ],
          [
            56.59383907,
            2.101879334,
            119.2123489,
            0.355355761,
            0.888645465
          ],
          [
            211.7806454,
            3.454238609,
            181.4095225,
            0.358292883,
            0.880381379
          ],
          [
            187.6722034,
            2.314160897,
            85.07213704,
            0.485031762,
            0.898418652
          ],
          [
            20.10142395,
            2.553901262,
            160.8109119,
            0.493139994,
            0.936322847
          ],
          [
            59.78016408,
            4.683501311,
            174.8606219,
            0.412639171,
            0.859558163
          ],
          [
            219.5351715,
            4.549711676,
            205.7580289,
            0.471476874,
            0.900278061
          ],
          [
            12.45227916,
            2.284966931,
            184.7636768,
            0.384189022,
            0.85
          ],
          [
            242.917518,
            2.24108003,
            36.71938065,
            0.431128742,
            0.883793615
          ],
          [
            191.8506717,
            4.375655624,
            129.9808045,
            0.361190797,
            0.978550572
          ],
          [
            29.59292498,
            2.900753099,
            129.6125621,
            0.409588357,
            0.891776032
          ],
          [
            172.447951,
            3.879471932,
            197.8505518,
            0.468627062,
            0.952420174
          ],
          [
            214.1380302,
            4.244595605,
            70.96962382,
            0.433392697,
            0.91538012
          ],
          [
            179.0218025,
            4.092242936,
            25.30498853,
            0.385591997,
            0.886617759
          ],
          [
            96.91041685,
            3.68622785,
            201.2081215,
            0.498039977,
            0.870855985
          ],
          [
            88.51374816,
            2.979316106,
            182.6757475,
            0.427532254,
            0.89730228
          ],
          [
            221.8385382,
            2.150724794,
            94.46150336,
            0.373742622,
            0.955770801
          ],
          [
            20.91315076,
            3.892068059,
            110.6898641,
            0.391108035,
            0.873022444
          ],
          [
            99.06487416,
            3.094723514,
            107.3011131,
            0.382483653,
            0.970365088
          ],
          [
            8.562579445,
            2.789053652,
            86.55931351,
            0.424805743,
            0.966225614
          ],
          [
            236.3955852,
            3.115929932,
            141.3564586,
            0.437582238,
            0.867666946
          ],
          [
            166.7172125,
            3.593853206,
            136.4147216,
            0.376269333,
            0.899670526
          ],
          [
            63.33034234,
            3.346527461,
            146.0678381,
            0.369788898,
            0.852542277
          ],
          [
            223.4230425,
            3.621288875,
            117.6104873,
            0.454338188,
            0.977051098
          ],
          [
            210.7846506,
            4.961318366,
            21.22820424,
            0.445268853,
            0.96372506
          ],
          [
            40.9660926,
            3.941761802,
            57.56997577,
            0.444451504,
            0.885650198
          ],
          [
            112.1645408,
            4.122188087,
            116.6466312,
            0.481240148,
            0.921868931
          ],
          [
            207.0638287,
            2.759727758,
            112.9900499,
            0.5,
            0.941373997
          ],
          [
            123.8676992,
            2.437691495,
            143.5033855,
            0.463326826,
            0.904663227
          ],
          [
            79.20041984,
            2.884506026,
            69.54544337,
            0.465970506,
            0.975009493
          ],
          [
            37.22566988,
            2.478767399,
            202.5409066,
            0.416322751,
            0.958363038
          ],
          [
            165.3257577,
            3.031791518,
            92.5454934,
            0.44787716,
            0.934756891
          ],
          [
            43.69159855,
            4.870042079,
            10.31724175,
            0.366611808,
            0.875756285
          ],
          [
            203.8812075,
            4.711210613,
            124.9126157,
            0.387632953,
            0.910361077
          ],
          [
            30.51892361,
            4.135695188,
            186.8222202,
            0.462093064,
            0.967953389
          ],
          [
            216.8942062,
            3.051803072,
            166.9687427,
            0.401708484,
            0.961482803
          ],
          [
            185.4486521,
            4.069452206,
            147.3843142,
            0.414152679,
            0.94441167
          ],
          [
            182.9329874,
            2.61988661,
            17.51742797,
            0.352013782,
            0.971486871
          ],
          [
            95.23472579,
            4.6185692,
            17.73798195,
            0.438448829,
            0.919660866
          ],
          [
            102.7847873,
            3.240802961,
            134.4846609,
            0.419171488,
            0.927193133
          ],
          [
            174.7307168,
            2.534342006,
            101.6180597,
            0.43425775,
            0.876797276
          ],
          [
            230.9906,
            4.336491215,
            156.7312209,
            0.380701587,
            0.895187096
          ],
          [
            27.47587767,
            4.662868355,
            59.83771511,
            0.489115802,
            0.959561481
          ],
          [
            239.6537084,
            4.783893047,
            195.1014485,
            0.396698824,
            0.973735439
          ],
          [
            73.91644537,
            3.657973076,
            158.5522516,
            0.397418689,
            0.933630559
          ],
          [
            15.43394161,
            4.788946949,
            131.9637092,
            0.467794647,
            0.881464812
          ],
          [
            120.7218825,
            3.785056097,
            83.72297164,
            0.36519652,
            0.962493161
          ],
          [
            118.7894293,
            2.075336534,
            178.80202,
            0.436044511,
            0.940473037
          ],
          [
            129.6028841,
            4.819837127,
            55.18780024,
            0.356307784,
            0.930709509
          ],
          [
            250.0,
            2.025462335,
            115.3410606,
            0.423051008,
            0.932299747
          ],
          [
            135.101624,
            3.293733314,
            127.212363,
            0.477860518,
            0.95779135
          ],
          [
            90.03556097,
            4.34830124,
            96.15558852,
            0.474490416,
            0.855579542
          ],
          [
            148.7726227,
            2.233857884,
            137.4213517,
            0.451351359,
            0.968684546
          ],
          [
            199.8718038,
            2.386751093,
            154.0630107,
            0.443009881,
            0.856366589
          ],
          [
            53.96039391,
            4.264164578,
            15.32151491,
            0.377742089,
            0.939049242
          ],
          [
            100.60517,
            4.746355406,
            75.59888718,
            0.455766544,
            0.946998412
          ],
          [
            159.726417,
            2.156110964,
            188.4532525,
            0.406167428,
            0.916812516
          ],
          [
            85.68120459,
            4.937539463,
            97.9490734,
            0.400527114,
            0.901013062
          ],
          [
            65.65983445,
            2.716425827,
            32.16730139,
            0.453207454,
            0.925986009
          ],
          [
            105.1101243,
            2.491665584,
            50.04183911,
            0.368685505,
            0.894136306
          ],
          [
            16.82372939,
            4.407690752,
            30.64177879,
            0.404255891,
            0.928585498
          ],
          [
            136.7506706,
            4.438314317,
            169.5588059,
            0.489793429,
            0.890866776
          ],
          [
            195.7946865,
            4.849392527,
            81.38294518,
            0.417983161,
            0.871701871
          ],
          [
            107.6668513,
            4.309911488,
            191.5280396,
            0.449037025,
            0.866039256
          ],
          [
            110.7466698,
            3.548271662,
            62.90080876,
            0.41556345,
            0.98
          ],
          [
            170.2295647,
            4.506187829,
            47.53666822,
            0.393743736,
            0.967384648
          ],
          [
            153.0439574,
            3.810625556,
            109.3083745,
            0.441528684,
            0.907420925
          ],
          [
            68.74449127,
            3.851558747,
            44.35654374,
            0.351075836,
            0.904148601
          ],
          [
            58.30066634,
            3.174869096,
            50.31165424,
            0.439779171,
            0.949931131
          ],
          [
            201.9268947,
            3.204192224,
            191.0892585,
            0.486988201,
            0.92971131
          ],
          [
            4.189908871,
            4.193457176,
            140.0514821,
            0.353732374,
            0.9486617
          ],
          [
            82.97879041,
            3.973552973,
            150.2711472,
            0.485863691,
            0.964378062
          ],
          [
            151.8486419,
            2.071701467,
            66.98041212,
            0.379919035,
            0.867166773
          ],
          [
            206.5685689,
            3.742414301,
            52.19519615,
            0.399163186,
            0.864196824
          ]
        ],
        [
          492.0031501,
          368.9365882,
          742.0714018,
          414.8924935,
          540.8967162,
          692.1082309,
          452.0342063,
          790.4405786,
          295.8327841,
          463.2706278,
          544.0121337,
          656.8254261,
          584.7607483,
          580.0889167,
          683.0361173,
          626.165231,
          639.9942657,
          252.7452638,
          529.7196997,
          597.2093876,
          807.243318,
          179.0568041,
          411.2441491,
          553.9218482,
          683.378332,
          206.3490928,
          209.1330398,
          768.21813,
          601.3180852,
          614.3854632,
          365.6075765,
          540.3202901,
          465.8459116,
          845.2550563,
          219.7025303,
          625.0299466,
          728.5202149,
          750.5586255,
          486.8298282,
          469.9684099,
          260.5448139,
          198.4032773,
          134.52698,
          186.7569047,
          624.9828331,
          961.8608611,
          450.7150862,
          270.9547705,
          640.9214706,
          667.0620544,
          102.9528765,
          270.5513798,
          889.6108793,
          433.9754028,
          901.5951972,
          824.4811592,
          342.1566402,
          647.2437292,
          439.7401129,
          816.533284,
          679.8379403,
          534.5165004,
          377.247237,
          436.1538602,
          373.1612365,
          702.6765558,
          454.8796226,
          636.4289651,
          701.7975595,
          639.1951952,
          364.6841679,
          737.0993741,
          629.9980605,
          841.8777964,
          606.9137192,
          577.5980338,
          550.7904179,
          519.0050719,
          671.5069277,
          726.3174458,
          567.5892041,
          188.9246134,
          858.7619153,
          476.9107332,
          790.4909068,
          681.5334684,
          513.4749118,
          315.8544949,
          710.2354052,
          299.5379055,
          701.0489523,
          653.1351801,
          454.2316487,
          611.4686024,
          613.7790254,
          728.6188919,
          636.736094,
          188.2726993,
          557.7578809,
          169.3488741,
          681.3076309,
          798.5477284,
          508.6250261,
          736.6609618,
          686.0570146,
          217.2928017,
          748.7305363,
          425.6342688,
          743.6220801,
          662.0439835
        ]
      ],
      "point_mask": [
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ],
        [
          true,
          true,
          true,
          true,
          true,
          true
        ]
      ],
      "matrix_type": "list",
      "compare_metric": "MSE",
      "compare_plot_type": "bar",
      "preprocess_method": "scale",
      "browse_path": "C:/Users/onlyj/Documents/nodeworks_projects/C3",
      "scale_from": 0.0,
      "scale_to": 1.0,
      "norm": "l2",
      "quantiles": 1000,
      "quantile_dist": "uniform",
      "transform_method": "yeo-johnson",
      "transform_standardize": true
    },
    "layer": 303,
    "geometry": [
      565.0,
      635.0
    ]
  },
  "sensitivity analysis.0": {
    "type": "Node",
    "name": "Sensitivity Analysis Tuned",
    "uniquename": "sensitivity analysis.0",
    "pos": [
      5197.0,
      5407.0
    ],
    "path": [
      "Surrogate Modeling and Analysis",
      "Sensitivity Analysis"
    ],
    "terminals": {
      "model": {
        "value": null,
        "flipped": false,
        "opts": {
          "in": true,
          "name": "model"
        }
      },
      "sensitivities": {
        "value": null,
        "flipped": false,
        "opts": {
          "out": true,
          "dtype": "<class 'SALib.util.results.ResultDict'>",
          "name": "sensitivities"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {
      "method": "sobol analysis",
      "samples": 10000,
      "M": 4,
      "conf_level": 0.95,
      "num_resamples": 10,
      "num_levels": 4,
      "grid_jump": 2,
      "variables": [
        "t1",
        "t2",
        "t3",
        "t4",
        "t5"
      ],
      "sensitivities": {
        "S1": [
          0.024841119376698955,
          0.013707523084822995,
          0.316308065467605,
          0.3030608098854561,
          0.266901402028745
        ],
        "S1_conf": [
          0.005454068102412231,
          0.003762420999216222,
          0.01593214153569104,
          0.013088675589113087,
          0.014686681409667047
        ],
        "ST": [
          0.038984347213688694,
          0.022215430375201517,
          0.37484944570244294,
          0.3354431831736181,
          0.32151858586648585
        ],
        "ST_conf": [
          0.0013415734564263166,
          0.0009989675850943908,
          0.01028184738825669,
          0.00945509677418687,
          0.010970744119666032
        ],
        "S2": [
          [
            NaN,
            -0.0026904919744177892,
            -0.001291474067576348,
            -0.002203226530604785,
            0.004918027384516854
          ],
          [
            NaN,
            NaN,
            0.000829113371097201,
            0.0006375873520143016,
            0.0009096572947021597
          ],
          [
            NaN,
            NaN,
            NaN,
            0.016219050275855573,
            0.02989227799380173
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.004813093586942319
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ],
        "S2_conf": [
          [
            NaN,
            0.008000989893560878,
            0.00891458673489371,
            0.008458559748986136,
            0.009085242059090724
          ],
          [
            NaN,
            NaN,
            0.005576796206597675,
            0.006333345077574924,
            0.006063710169869236
          ],
          [
            NaN,
            NaN,
            NaN,
            0.023198759847789137,
            0.024504074224759118
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            0.02397600209906036
          ],
          [
            NaN,
            NaN,
            NaN,
            NaN,
            NaN
          ]
        ]
      },
      "tab": 1,
      "display_sens": [
        true,
        false,
        false
      ],
      "sort_by": "Total"
    },
    "layer": 73,
    "geometry": [
      502.0,
      368.0
    ]
  },
  "display": {
    "type": "Node",
    "name": "Test Sample Results",
    "uniquename": "display",
    "pos": [
      5908.0,
      5830.0
    ],
    "path": [
      "general",
      "Display"
    ],
    "terminals": {
      "input": {
        "value": null,
        "flipped": false,
        "opts": {
          "widget": "textedit",
          "in": true,
          "dtype": "<class 'str'>",
          "name": "input"
        }
      }
    },
    "tunnel": false,
    "forcerun": false,
    "hidden": false,
    "customState": {},
    "layer": 307,
    "geometry": [
      382.0,
      359.0
    ]
  },
  "connection": {
    "type": "Connection",
    "name": "connection",
    "line": "cubic",
    "uniquename": "connection",
    "input": [
      "emulator.0",
      "result"
    ],
    "output": [
      "code.0",
      "r2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.0": {
    "type": "Connection",
    "name": "connection.0",
    "line": "cubic",
    "uniquename": "connection.0",
    "input": [
      "sensitivity analysis.0",
      "sensitivities"
    ],
    "output": [
      "code",
      "sens2"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.1": {
    "type": "Connection",
    "name": "connection.1",
    "line": "cubic",
    "uniquename": "connection.1",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "emulator.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.2": {
    "type": "Connection",
    "name": "connection.2",
    "line": "cubic",
    "uniquename": "connection.2",
    "input": [
      "emulator",
      "result"
    ],
    "output": [
      "code.0",
      "r1"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.3": {
    "type": "Connection",
    "name": "connection.3",
    "line": "cubic",
    "uniquename": "connection.3",
    "input": [
      "response surface.0",
      "Model"
    ],
    "output": [
      "sensitivity analysis.0",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.4": {
    "type": "Connection",
    "name": "connection.4",
    "line": "cubic",
    "uniquename": "connection.4",
    "input": [
      "sensitivity analysis",
      "sensitivities"
    ],
    "output": [
      "code",
      "sens1"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.5": {
    "type": "Connection",
    "name": "connection.5",
    "line": "cubic",
    "uniquename": "connection.5",
    "input": [
      "response surface",
      "Response matrix"
    ],
    "output": [
      "parallel coordinates plot",
      "table"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.6": {
    "type": "Connection",
    "name": "connection.6",
    "line": "cubic",
    "uniquename": "connection.6",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator.0",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.7": {
    "type": "Connection",
    "name": "connection.7",
    "line": "cubic",
    "uniquename": "connection.7",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "emulator",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.8": {
    "type": "Connection",
    "name": "connection.8",
    "line": "cubic",
    "uniquename": "connection.8",
    "input": [
      "read csv",
      "dataframe"
    ],
    "output": [
      "emulator",
      "points"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.9": {
    "type": "Connection",
    "name": "connection.9",
    "line": "cubic",
    "uniquename": "connection.9",
    "input": [
      "response surface",
      "Model"
    ],
    "output": [
      "sensitivity analysis",
      "model"
    ],
    "controlpoints": [],
    "feedback": false
  },
  "connection.10": {
    "type": "Connection",
    "name": "connection.10",
    "line": "cubic",
    "uniquename": "connection.10",
    "input": [
      "code.0",
      "returnOut"
    ],
    "output": [
      "display",
      "input"
    ],
    "controlpoints": [],
    "feedback": false
  }
}