# csg-eb

Library for parsing [Constructive Solid Geometry (CSG)
files](https://github.com/openscad/openscad/wiki/CSG-File-Format) into an
implicit function that can be used to define [Embedded Boundaries
(EB)](https://amrex-codes.github.io/amrex/docs_html/EB.html).

Uses PEGTL for parsing and Catch2 for tests.


## Build

> :warning: **Requires C++17, such as GCC 7.x or later, or Clang 5.x or later**.

### CMake

#### Installing conan for the first time

    python3 -m pip install conan

#### Building using CMake

    cmake -S . -B build -DCMAKE_BUILD_TYPE=Release
    cmake --build build --target unit_tests_csg
    cd build
    make -j

#### Running unit tests

    ctest


## Using the library in other projects

### Include in the code
* Include the header file

        #include "csg.hpp"

* Create a function object

        auto csg_if = csg::get_csgif(<path_to_file_with_csg_extension>, is_internal_flow);

* Above returns an implicit function which can be operated on a 3D point coordinate (x, y, z) as

        csg_if(x, y, z)

* Can be passed to amrex EB2::makeShop

        auto gshop = EB2::makeShop(*csg_if);


### Note on the return value
* If `internal_flow` is set to `true`
    - **csg_if(x, y, z)** returns a number `less than 0`, if (x, y, z) lies `inside` the CSG object (a hollow)
    - **csg_if(x, y, z)** returns a number `greater than 0`, if (x, y, z) lies `outside` the CSG object (a hollow)
* If `internal_flow` is set to `false`
    - **csg_if(x, y, z)** returns a number `greater than 0`, if (x, y, z) lies `inside` the CSG object (a solid)
    - **csg_if(x, y, z)** returns a number `less than 0`, if (x, y, z) lies `outside` the CSG object (a solid)

### Add to the CMake build
* Add this repo as a git submodule
* Build by adding as subdirectory in appropriate CMake file

        add_subdirectory(<path-to-submodule>)

* Link by setting the dependency in appropriate CMake file

        target_link_libraries(<target> PRIVATE csg)
