!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvC
!                                                                      C
!  Module name: WRITE_USR1 (L)                                         C
!  Purpose: Write user-defined output                                  C
!                                                                      C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Revision Number:                                                    C
!  Purpose:                                                            C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Literature/Document References:                                     C
!                                                                      C
!  Variables referenced:                                               C
!  Variables modified:                                                 C
!                                                                      C
!  Local variables:                                                    C
!                                                                      C
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^C
!
      SUBROUTINE WRITE_USR1(L) 
!...Translated by Pacific-Sierra Research VAST-90 2.06G5  12:17:31  12/09/98  
!...Switches: -xf
!-----------------------------------------------
!   M o d u l e s
!-----------------------------------------------
      USE param
      USE param1
      USE run
      USE output
      USE physprop
      USE geometry
      USE ic
      USE bc
      USE is
      USE fldvar
      USE constant
      USE indices
      USE funits
      USE toleranc
      USE scales
      USE scalars
      USE ur_facs
      USE leqsol
      USE compar         !//d
      USE mpi_utility    !//d
      USE sendrecv    !//d
      USE functions
      IMPLICIT NONE
!-----------------------------------------------
!
!  Include files defining common blocks here
!
!
!  Define local variables here
!
      INTEGER :: L
      INTEGER :: IJK, IJMK
      DOUBLE PRECISION :: Vol_sum, phi_sum, v_s_sum, v_g_sum, T_sum
      DOUBLE PRECISION :: phi_m, v_s_w, v_g_w, T_w, v_r_bar, jy
      DOUBLE PRECISION :: work1, work2
!
!  Open user output file(s) 
!  -> in ll, just do this at the end on the host node
!
!
!  Initialize processor & global variables
!
      Vol_sum = ZERO
      phi_sum = ZERO
      v_s_sum = ZERO
      v_g_sum = ZERO
      T_sum   = ZERO

      phi_m = ZERO
      v_s_w = ZERO
      v_g_w = ZERO
      T_w   = ZERO
      v_r_bar = ZERO
      jy    = ZERO

      work1   = ZERO
      work2   = ZERO
!
!  Sum on processors
!
      DO IJK = IJKSTART3, IJKEND3
        IF (.NOT. IS_ON_myPE_wobnd(I_OF(IJK),J_OF(IJK),K_OF(IJK))) CYCLE
        IF (FLUID_AT(IJK)) THEN
          IJMK = JM_OF(IJK)
          Vol_sum = Vol_sum + VOL(IJK)
          phi_sum = phi_sum + VOL(IJK)*(ONE - EP_G(IJK))
          v_s_sum = v_s_sum + VOL(IJK)*(ONE - EP_G(IJK))*(V_s(IJK,1) + V_s(IJMK,1))/2.0d0
          v_g_sum = v_g_sum + VOL(IJK)*EP_G(IJK)*(V_g(IJK) + V_g(IJMK))/2.0d0
          T_sum   = T_sum   + VOL(IJK)*(ONE - EP_G(IJK))*Theta_m(IJK,1)
        END IF
      END DO
!
!  Summ across processors
!
      CALL GLOBAL_ALL_SUM(Vol_sum)
      CALL GLOBAL_ALL_SUM(phi_sum)
      CALL GLOBAL_ALL_SUM(v_s_sum)
      CALL GLOBAL_ALL_SUM(v_g_sum)
      CALL GLOBAL_ALL_SUM(T_sum)
!
!  calc global weighted values
!
      jy = (v_s_sum + v_g_sum)/Vol_sum

      phi_m   = phi_sum/Vol_sum
      v_s_w   = (v_s_sum/Vol_sum)/phi_m
      v_g_w   = (v_g_sum/Vol_sum)/(ONE - phi_m)
      T_w     = (T_sum/Vol_sum)/phi_m
      v_r_bar = v_s_w - v_g_w
!
!  Final calcs & write out
!
    6 FORMAT (6(E16.8,2x))
      IF (myPE .EQ. PE_IO) THEN
        OPEN(UNIT=801,FILE='output.dat',ACCESS='APPEND',STATUS='OLD')
        WRITE(801,6) TIME, v_r_bar, T_w, v_s_w, phi_m, jy
        CLOSE(801)
      ENDIF
!
!
!
      RETURN  
      END SUBROUTINE WRITE_USR1 
