!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvC
!                                                                      C
!  Module name: USR1                                                   C
!  Purpose: This routine is called from the time loop and is           C
!           user-definable.  The user may insert code in this routine  C
!           or call appropriate user defined subroutines.  This        C
!           can be used for setting or checking errors in quantities   C
!           that vary with time.  This routine is not called from an   C
!           IJK loop, hence all indices are undefined.                 C
!                                                                      C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Revision Number:                                                    C
!  Purpose:                                                            C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Literature/Document References:                                     C
!                                                                      C
!  Variables referenced:                                               C
!  Variables modified:                                                 C
!                                                                      C
!  Local variables:                                                    C
!                                                                      C
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^C
!
      SUBROUTINE USR1
!...Translated by Pacific-Sierra Research VAST-90 2.06G5  12:17:31  12/09/98
!...Switches: -xf
      USE usr
      USE functions
      USE mpi_utility
      USE constant,  ONLY: C
      USE run,       ONLY: TIME
      USE output,    ONLY: USR_DT
      USE fldvar,    ONLY: U_g, V_g, W_g, EP_g 
      USE fldvar,    ONLY: U_s, V_s, W_s, Theta_m
      USE geometry,  ONLY: VOL
      USE compar,    ONLY: myPE, PE_IO
!!      USE bc,        ONLY: BC_V_G 
!!      USE set_bc0_flow_mod
!!      USE toleranc,  ONLY: TOL_RESID

      IMPLICIT NONE

!-----------------------------------------------
!
!  Include files defining common blocks here
!
!
!  Define local variables here
!
      INTEGER :: ijk, imjk, ijmk, ijkm, phiii
      DOUBLE PRECISION :: phijk
      DOUBLE PRECISION :: Vol_tot, flux_tot_y
      DOUBLE PRECISION :: ga_vg, ga_us, ga_vs, ga_ws !global average
      DOUBLE PRECISION :: ga_uus, ga_vvs, ga_wws
      DOUBLE PRECISION :: ga_slip, ga_temp, ga_kapp, ga_phip 
!
!  Include files defining statement functions here
!
!
!  I
!
!     data analysis & printing 
 8882 FORMAT (4(E16.8, 2x))
 8885 FORMAT (5(E16.8, 2x))

!     Normalize vertical velocity variables to Vk' = Vk - jy
!     ie ' variables are relative to the zero net flux plane

      flux_tot_y = 0.0d0
      Vol_tot = 0.0d0
      DO IJK = IJKSTART3, IJKEND3
        IF (.NOT.IS_ON_myPE_wobnd(I_OF(IJK),J_OF(IJK),K_OF(IJK))) CYCLE
        IF (.NOT.FLUID_AT(IJK)) CYCLE
          IJMK = JM_OF(IJK)
          flux_tot_y = flux_tot_y + 0.5d0 * VOL(IJK) * &
                     ( (1.0d0 - EP_G(IJK))*(V_s(IJK,1) + V_s(IJMK,1)) + &
                              + EP_G(IJK) *(V_g(IJK)   + V_g(IJMK)))
!         Vol_tot = Vol_tot + VOL(IJK) 
      ENDDO

      CALL GLOBAL_ALL_SUM(flux_tot_y)
!     this only works for regular rect domains
!     CALL GLOBAL_ALL_SUM(Voltot) 
      Vol_tot = DBLE(XLENGTH*YLENGTH*ZLENGTH)
      flux_tot_y = flux_tot_y / Vol_tot
      
      IF (DABS(flux_tot_y) .GT. 1.0d-15) THEN
        DO IJK = IJKSTART3, IJKEND3
          IF(.NOT.IS_ON_myPE_wobnd(I_OF(IJK), J_OF(IJK), K_OF(IJK))) CYCLE
          IF (.NOT.FLUID_AT(IJK)) CYCLE 
          V_g(IJK)   = V_g(IJK)   - flux_tot_y
          V_s(IJK,1) = V_s(IJK,1) - flux_tot_y 
        ENDDO
      ENDIF 

!     print
      IF(myPE .EQ. PE_IO) THEN
        OPEN(UNIT=889,FILE='drift.dat',STATUS='OLD',ACCESS='APPEND')
        WRITE(889,8882) TIME, flux_tot_y
        CLOSE(889)
      ENDIF


!     check for usr IO time 
      IF (TIME .LT. usr_time_write) RETURN
!     increment next time to write user data
      usr_time_write = usr_time_write + USR_DT(1)

      ga_vg   = 0.0d0
      ga_us   = 0.0d0 
      ga_vs   = 0.0d0
      ga_ws   = 0.0d0
      ga_uus  = 0.0d0 
      ga_vvs  = 0.0d0
      ga_wws  = 0.0d0
      ga_temp = 0.0d0
      ga_phip = 0.0d0
      DO IJK = IJKSTART3, IJKEND3
        IF (.NOT.IS_ON_myPE_wobnd(I_OF(IJK),J_OF(IJK),K_OF(IJK))) CYCLE
        IF (.NOT.FLUID_AT(IJK)) CYCLE
          ImJK = IM_OF(IJK)
          IJmK = JM_OF(IJK)
          IJKm = KM_OF(IJK)

          ga_vg   = ga_vg + 0.5d0*VOL(IJK) &
                  * EP_G(IJK)*(V_G(IJK) + V_G(IJmK))
          ga_us   = ga_us  + 0.5d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(U_S(IJK,1) + U_S(ImJK,1))
          ga_vs   = ga_vs  + 0.5d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(V_S(IJK,1) + V_S(IJmK,1))
          ga_ws   = ga_ws  + 0.5d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(W_S(IJK,1) + W_S(IJKm,1)) 
          ga_uus  = ga_uus + 0.25d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(U_S(IJK,1) + U_S(ImJK,1))**2
          ga_vvs  = ga_vvs + 0.25d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(V_S(IJK,1) + V_S(IJmK,1))**2
          ga_wws  = ga_wws + 0.25d0 * VOL(IJK) &
                  * (1.0d0 - EP_G(IJK))*(W_S(IJK,1) + W_S(IJKm,1))**2
          ga_temp = ga_temp + VOL(IJK)*EP_G(IJK)*Theta_m(IJK,1)
          ga_phip = ga_phip + VOL(IJK)*(EP_G(IJK) - 0.9d0)**2 !hardcode ave epg == 0.9
!         Vol_tot = Vol_tot + VOL(IJK) 
          IF (EP_G(IJK) .GT. 0.35d0) THEN 
            phiii = INT((1.0d0 - EP_G(IJK))/5.0d-3) + 1
            ga_phi_pdf(phiii) = ga_phi_pdf(phiii) + 1.0d0
          ENDIF
      ENDDO

      CALL GLOBAL_ALL_SUM(ga_vg)
      CALL GLOBAL_ALL_SUM(ga_us)
      CALL GLOBAL_ALL_SUM(ga_vs)
      CALL GLOBAL_ALL_SUM(ga_ws)
      CALL GLOBAL_ALL_SUM(ga_uus)
      CALL GLOBAL_ALL_SUM(ga_vvs)
      CALL GLOBAL_ALL_SUM(ga_wws)
      CALL GLOBAL_ALL_SUM(ga_temp)
      CALL GLOBAL_ALL_SUM(ga_phip)
      
      ga_vg   = (ga_vg / Vol_tot) / 0.9d0     !hardcode ave epg == 0.9 
      ga_us   = (ga_us / Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_vs   = (ga_vs / Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_ws   = (ga_ws / Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_uus  = (ga_uus/ Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_vvs  = (ga_vvs/ Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_wws  = (ga_wws/ Vol_tot) / 0.1d0     !hardcode ave epg == 0.9 
      ga_temp = (ga_temp / Vol_tot) / 0.1d0   !hardcode ave epg == 0.9 
      ga_phip = ga_phip / Vol_tot

      ga_slip = ga_vg - ga_vs
      ga_kapp = (ga_uus   + ga_vvs   + ga_wws   &
              -  ga_us**2 - ga_vs**2 - ga_ws**2 & 
              +  3.0d0*ga_temp) / 2.0d0

!     print
      IF(myPE .NE. PE_IO) RETURN
      OPEN(UNIT=888,FILE='global_stats.dat',STATUS='OLD',ACCESS='APPEND')
      WRITE(888,8885) TIME, ga_slip, ga_kapp, ga_phip, ga_temp
      CLOSE(888)

      RETURN
      END SUBROUTINE USR1

