      PROGRAM calc_DP
!---------------------------------------------------------------------------------
!
! Purpose:
!       Calculate the body force and pressure drop for the gas-solid
!       sedimentation problems
!
!---------------------------------------------------------------------------------
      IMPLICIT NONE
!---------------------------------------------------------------------------------
!     Local variables
!---------------------------------------------------------------------------------
      INTEGER :: i, j
      DOUBLE PRECISION :: rho_g, rho_s, Drho, rrho, mu_g
      DOUBLE PRECISION :: phi, diap, Ar, grav, Ly, DP
!---------------------------------------------------------------------------------
!     set variables
!---------------------------------------------------------------------------------
      rho_s =  1.50d+3
      rho_g =  1.30d+0
      diap  = 75.00d-6
      mu_g  =  1.80d-5
      phi   =  0.10d+0
      Ly    = 23.04d-3
      grav  = 98.00d+0
!---------------------------------------------------------------------------------
!     read in
!---------------------------------------------------------------------------------
!---------------------------------------------------------------------------------
!     Calc other variables
!       Ar = rho_g*Drho*grav*diap**3 / mu_g**2
!---------------------------------------------------------------------------------
      rrho  = rho_s/rho_g
      Drho  = rho_s - rho_g
      Ar    = rho_g*Drho*diap**3/mu_g**2
      DP    = (phi*rho_s + (1.0d0 - phi)*rho_g)*grav*Ly
!--------------------------------------------------------------------------------
!     Write out
!---------------------------------------------------------------------------------
    6 FORMAT (A9,F12.6)
   16 FORMAT (A9,F24.16)
      WRITE(*,*)   '  '
      WRITE(*,16)  ' DP    = ', DP
      WRITE(*,*)   '  '
!
!
!
      END PROGRAM calc_DP

