      PROGRAM calc_DP
!---------------------------------------------------------------------------------
!
! Purpose:
!       Calculate the body force and pressure drop for the gas-solid
!       sedimentation problems
!
!---------------------------------------------------------------------------------
      IMPLICIT NONE
!---------------------------------------------------------------------------------
!     Local variables
!---------------------------------------------------------------------------------
      INTEGER :: i, j
      DOUBLE PRECISION :: rho_g, rho_s, Drho, rrho, mu_g
      DOUBLE PRECISION :: phi, diap, Ar, grav, Ly, DP
!---------------------------------------------------------------------------------
!     set variables
!---------------------------------------------------------------------------------
      rho_s = 1.5d0
      rho_g = 1.3d-3
      diap  = 7.5d-3
      mu_g  = 1.8d-4
      phi   = 0.10d0
      Ly    = 2.304d0
      grav  = 9.8d+3
!---------------------------------------------------------------------------------
!     read in
!---------------------------------------------------------------------------------
!---------------------------------------------------------------------------------
!     Calc other variables
!       Ar = rho_g*Drho*grav*diap**3 / mu_g**2
!---------------------------------------------------------------------------------
      rrho  = rho_s/rho_g
      Drho  = rho_s - rho_g
      Ar    = rho_g*Drho*diap**3/mu_g**2
      DP    = (phi*rho_s + (1.0d0 - phi)*rho_g)*grav*Ly
!--------------------------------------------------------------------------------
!     Write out
!---------------------------------------------------------------------------------
    6 FORMAT (A9,F12.6)
   16 FORMAT (A9,F24.16)
      WRITE(*,*)   '  '
      WRITE(*,16)  ' DP    = ', DP
      WRITE(*,*)   '  '
!
!
!
      END PROGRAM calc_DP

